## ----setup, echo=FALSE---------------------------------------------------
knitr::opts_chunk$set(message=FALSE, fig.path='figures/')

## ----include = FALSE-----------------------------------------------------
library(MetaboSignal)

## ---- message = FALSE, tidy = TRUE---------------------------------------
MS_FindKEGG(KEGG_database="organism", match = "rattus")

## ----tidy = TRUE---------------------------------------------------------
MS_FindKEGG(KEGG_database ="pathway", match = c("glycol", "inositol phosphate","insulin signal", "akt"), organism_code = "rno")

## ----tidy = TRUE---------------------------------------------------------
metabo_paths <- c("rno00010","rno00562")
signaling_paths <- c("rno04910", "rno04151")

## ----tidy = TRUE, tidy.opts=list(indent = 4, width.cutoff = 70), results='asis',eval=FALSE----
#  # Adipose tissue-filtered network
#  MetaboSignal_table <- MetaboSignal_matrix(metabo_paths = metabo_paths,
#                                            signaling_paths = signaling_paths,
#                                            organism_name = "rat",
#                                            tissue = c("soft tissue 1", "soft tissue 2" ))
#  
#  # Unfiltered-network
#  MetaboSignal_tableUnfiltered <- MetaboSignal_matrix(metabo_paths = metabo_paths,
#                                                      signaling_paths = signaling_paths)
#  
#  # Check signaling-genes removed by tissue-filtering
#  neglected_genes <- MS_ChangeNames(setdiff(as.vector(MetaboSignal_tableUnfiltered),
#                                            as.vector(MetaboSignal_table)), "rno")
#  

## ----tidy = TRUE---------------------------------------------------------
MetaboSignal_table <- MS_ReplaceNode(node1 = c("cpd:C00267", "cpd:C00221"), 
                                     node2 = "cpd:C00031", MetaboSignal_table)

## ----tidy = TRUE, message = FALSE----------------------------------------
MS_FindMappedNodes(nodes = c("cpd:C00267", "cpd:C00221", "cpd:C00031"),
                   MetaboSignal_table)

## ----tidy = TRUE, message = FALSE----------------------------------------
MetaboSignal_distances(MetaboSignal_table, organism_code = "rno", 
                       source_genes = c("303565", "65038", "309179"), 
                       target_metabolites = "cpd:C00031", names=TRUE)

## ----tidy = TRUE, tidy.opts=list(indent = 4, width.cutoff = 70), eval = FALSE----
#  subnetwork <- MetaboSignal_NetworkCytoscape(MetaboSignal_table, organism_code="rno",
#                                              source_genes = c("303565", "65038", "309179"),
#                                              target_metabolites = "cpd:C00031", type = "bw",
#                                              file_name = "MSCytoscape")

