## ----knitr, include=FALSE, cache=FALSE-----------------------------------
library("knitr")

## ----eval=TRUE-----------------------------------------------------------
library(MetCirc)

## ----eval=TRUE,echo=c(1:3)-----------------------------------------------
## load data
data("sd01_outputXCMS", package = "MetCirc")
data("sd02_deconvoluted", package = "MetCirc")


## load binnedMSP
data("binnedMSP", package = "MetCirc")
## load similarityMat
data("similarityMat", package = "MetCirc")

## ----eval=c(1:2)---------------------------------------------------------
## identify precursor mz
finalMSPLi2015 <- convert2MSP(sd02_deconvoluted, split = " _ ", 
                              splitIndMZ = 2, splitIndRT = 3)

## optional:
## write finalMSPLi2015 to idMSMStoMSPLi2015.RData
save(finalMSPLi2015, file = "idMSMStoMSPLi2015.RData")

## ----eval=TRUE-----------------------------------------------------------
compartment <- sample(c("yl", "ol", "s","r"), size = length(finalMSPLi2015), 
    replace=TRUE) 

## ----eval=TRUE-----------------------------------------------------------
## load idMSMStissueproject
data("idMSMStissueproject", package = "MetCirc")

## ----eval=c(1:18)--------------------------------------------------------
## create vectors with precursor names present in tissue
tissueSPL <- compartmentTissue[compartmentTissue[,"SPL"] == TRUE, 1]
tissueLIM <- compartmentTissue[compartmentTissue[,"LIM"] == TRUE, 1]
tissueANT <- compartmentTissue[compartmentTissue[,"ANT"] == TRUE, 1]
tissueSTY <- compartmentTissue[compartmentTissue[,"STY"] == TRUE, 1]

## truncate tissue
tissueSPL <- tissue[tissue[,4] %in% tissueSPL,] 
tissueLIM <- tissue[tissue[,4] %in% tissueLIM,]
tissueANT <- tissue[tissue[,4] %in% tissueANT,]
tissueSTY <- tissue[tissue[,4] %in% tissueSTY,]

## create msp and combine msp objects of different tissues
finalMSP <- convert2MSP(tissueSPL)
finalMSP <- combine(finalMSP, convert2MSP(tissueLIM))
finalMSP <- combine(finalMSP, convert2MSP(tissueANT))
finalMSP <- combine(finalMSP, convert2MSP(tissueSTY))

## optional:
## write finalMSP to idMSMStoMSP.RData
save(finalMSP, file = "idMSMStoMSP.RData")

## ----eval=TRUE-----------------------------------------------------------
## create vector with compartments
compSPL <- rep("SPL", length(convert2MSP(tissueSPL)))
compLIM <- rep("LIM", length(convert2MSP(tissueLIM)))
compANT <- rep("ANT", length(convert2MSP(tissueANT)))
compSTY <- rep("STY", length(convert2MSP(tissueSTY)))

compartment <- c(compSPL, compLIM, compANT, compSTY)

## ----eval=FALSE----------------------------------------------------------
#  ## create data frame with binned fragments
#  binnedMSP <- binning(msp = finalMSP, tol = 0.01,
#                       group = compartment, method = "median")

## ----eval=FALSE----------------------------------------------------------
#  ## similarity Matrix
#  similarityMat <- createSimilarityMatrix(binnedMSP)

## ----cluster,eval=TRUE,fig.show='hide'-----------------------------------
## load package amap
hClustMSP <- hcluster(similarityMat, method = "spearman")
## visualise clusters
plot(hClustMSP, labels = FALSE, xlab="", sub="")

## ----eval=TRUE-----------------------------------------------------------
nlMSP <- msp2FunctionalLossesMSP(finalMSP)

## ----eval=FALSE----------------------------------------------------------
#  ## bin msp file with functional losses, create table with same fragments
#  ## (binning)
#  nlBinnedMSP <- binning(nlMSP, tol = 0.01, group = compartment, method = "median")
#  ## similarity Matrix
#  nlSimilarityMat <- createSimilarityMatrix(nlBinnedMSP)

## ----eval=FALSE----------------------------------------------------------
#  ## Clustering
#  nlHClustMSP <- hcluster(nlSimilarityMat, method = "spearman")

## ----eval=FALSE----------------------------------------------------------
#  plot(nlHClustMSP, labels = FALSE)
#  
#  ## labels can be reproduced by entering in the console
#  colnames(nlSimilarityMat)[nlHClustMSP$order]

## ----eval=TRUE-----------------------------------------------------------
linkMat <- createLinkMatrix(similarityMatrix = similarityMat, threshold=0.5)

## ----eval=FALSE----------------------------------------------------------
#  selectedFeatures <- shinyCircos(similarityMat)

## ----circos,eval=TRUE,results='hide',message=FALSE,fig.show='hide'-------
## order similarity matrix according to retention time
simM <- createOrderedSimMat(similarityMat, order = "retentionTime")
groupname <- rownames(simM)
## create link matrix
linkMat <- createLinkMatrix(similarityMatrix = simM, threshold=0.99)
## cut link matrix (here: only display links between groups)
linkMat_cut <- cutLinkMatrix(linkMat, type = "inter")

## set circlize paramters
circos.par(gap.degree = 0, cell.padding = c(0, 0, 0, 0), 
            track.margin = c(0, 0))

## here set indSelected arbitrarily
indSelected <- 1
selectedFeatures <- groupname[1]

## actual plotting
plotCircos(groupname, linkMat_cut, initialize = TRUE, featureNames = TRUE, 
    cexFeatureNames = 0.2, groupSector = TRUE, groupName = FALSE, 
    links = FALSE, highlight = TRUE)

highlight(groupname = groupname, ind = indSelected, LinkMatrix = 
            linkMat_cut)

## plot without highlighting
plotCircos(groupname, linkMat_cut, initialize = TRUE, featureNames = TRUE, 
    cexFeatureNames = 0.2, groupSector = TRUE, groupName = FALSE, links = TRUE, 
    highlight = FALSE)

## ----session,eval=TRUE,echo=FALSE----------------------------------------
sessionInfo()

