## ----style, eval=TRUE, echo=FALSE, results="asis"----
BiocStyle::latex2()

## ----'setup', include = FALSE, cache = FALSE-------------------
library("knitr")
opts_chunk$set(fig.align = 'center',
               fig.show = 'hold',
               par = TRUE,
               prompt = FALSE,
               comment = NA)
options(replace.assign = TRUE,
        width = 65)

## ----environment, cache=FALSE, echo=FALSE----------------------
suppressPackageStartupMessages(library(MSnbase))

## ----pSet------------------------------------------------------
getClass("pSet")

## ----MSnExp----------------------------------------------------
getClass("MSnExp")

## ----OnDiskMSnExp----------------------------------------------
getClass("OnDiskMSnExp")

## ----MSnSet----------------------------------------------------
getClass("MSnSet")

## ----as--------------------------------------------------------
data(msnset)
class(msnset)
class(as(msnset, "ExpressionSet"))

data(sample.ExpressionSet)
class(sample.ExpressionSet)
class(as(sample.ExpressionSet, "MSnSet"))

## ----MSnProcess------------------------------------------------
getClass("MSnProcess")

## ----MIAPE-----------------------------------------------------
getClass("MIAPE")

## ----Spectrum--------------------------------------------------
getClass("Spectrum")

## ----Spectrum1-------------------------------------------------
getClass("Spectrum1")

## ----Spectrum2-------------------------------------------------
getClass("Spectrum2")

## ----ReporterIons----------------------------------------------
getClass("ReporterIons")

## ----NAnnotatedDF----------------------------------------------
getClass("NAnnotatedDataFrame")

## ----msl-------------------------------------------------------
getClass("MSnSetList")

## ----sessioninfo, results='asis', echo=FALSE-------------------
toLatex(sessionInfo())

