/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.equations.builtins;

import org.cytoscape.equations.AbstractFunction;
import org.cytoscape.equations.ArgDescriptor;
import org.cytoscape.equations.ArgType;

public class If
extends AbstractFunction {
    public If() {
        super(new ArgDescriptor[]{new ArgDescriptor(ArgType.BOOL, "condition", "A logical test expression."), new ArgDescriptor(ArgType.ANY, "value_if_true", "The return value if the test expression evaluates to true."), new ArgDescriptor(ArgType.ANY, "value_if_false", "The return value if the test expression evaluates to false.")});
    }

    public String getName() {
        return "IF";
    }

    public String getFunctionSummary() {
        return "Returns one of two alternatives based on a boolean value.";
    }

    public Class getReturnType() {
        return Object.class;
    }

    public Object evaluateFunction(Object[] args) throws IllegalArgumentException, ArithmeticException {
        boolean condition = (Boolean)args[0];
        if (args[1].getClass() == args[2].getClass()) {
            return args[condition ? 1 : 2];
        }
        return args[condition ? 1 : 2].toString();
    }
}

