/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.ui;

import cytoscape.Cytoscape;
import cytoscape.visual.VisualPropertyType;
import cytoscape.visual.converter.ValueToStringConverterManager;
import cytoscape.visual.ui.BypassHack;
import cytoscape.visual.ui.ObjectPlacerControl;
import cytoscape.visual.ui.ObjectPlacerGraphic;
import ding.view.ObjectPositionImpl;
import giny.model.GraphObject;
import giny.view.ObjectPosition;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class PopupObjectPositionChooser
extends JDialog
implements PropertyChangeListener {
    private static final long serialVersionUID = 7146654020668346430L;
    private ObjectPosition position;
    private ObjectPosition newPosition;
    private VisualPropertyType targetType;

    public static ObjectPosition showDialog(Window parent, ObjectPosition pos, VisualPropertyType type) {
        PopupObjectPositionChooser placer = new PopupObjectPositionChooser(parent, pos, type);
        return placer.getObjectPosition();
    }

    private PopupObjectPositionChooser(Window parent, ObjectPosition pos, VisualPropertyType type) {
        this.targetType = type;
        this.setModal(true);
        this.setLocationRelativeTo(parent);
        this.init(pos);
    }

    private void init(ObjectPosition pos) {
        this.position = pos == null ? new ObjectPositionImpl() : pos;
        this.newPosition = new ObjectPositionImpl(this.position);
        this.setTitle("Select " + this.targetType.getName());
        JPanel placer = new JPanel();
        placer.setLayout(new BoxLayout(placer, 1));
        placer.setOpaque(true);
        ObjectPlacerGraphic graphic = new ObjectPlacerGraphic(new ObjectPositionImpl(this.position), null, true, this.targetType.getName(), null, null);
        ObjectPlacerControl control = new ObjectPlacerControl(new ObjectPositionImpl(this.position));
        control.addPropertyChangeListener(graphic);
        control.addPropertyChangeListener(this);
        graphic.addPropertyChangeListener(control);
        graphic.addPropertyChangeListener(this);
        placer.add(graphic);
        placer.add(control);
        JPanel buttonPanel = new JPanel();
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupObjectPositionChooser.this.position = PopupObjectPositionChooser.this.newPosition;
                PopupObjectPositionChooser.this.dispose();
            }
        });
        ok.addActionListener(control);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PopupObjectPositionChooser.this.dispose();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        placer.add(buttonPanel);
        this.add(placer);
        this.pack();
        this.setVisible(true);
    }

    private ObjectPosition getObjectPosition() {
        return this.position;
    }

    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("OBJECT_POSITION_CHANGED") && e.getNewValue() instanceof ObjectPosition) {
            this.newPosition = (ObjectPosition)e.getNewValue();
            GraphObject go = BypassHack.getCurrentObject();
            if (go != null) {
                String val = ValueToStringConverterManager.manager.toString(this.newPosition);
                Cytoscape.getNodeAttributes().setAttribute(go.getIdentifier(), VisualPropertyType.NODE_LABEL_POSITION.getBypassAttrName(), val);
                Cytoscape.getVisualMappingManager().getNetworkView().redrawGraph(false, true);
            }
        }
    }
}

