/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.util;

import cytoscape.util.shadegrown.WindowUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;

public abstract class CreditScreen {
    public static void showCredits(URL url, String lines) {
        final JWindow window = new JWindow();
        final ScrollingLinesPanel panel = new ScrollingLinesPanel(url, lines);
        window.add(panel);
        window.pack();
        window.validate();
        window.setPreferredSize(panel.getPreferredSize());
        window.requestFocusInWindow();
        WindowUtilities.centerWindowLocation(window);
        window.setAlwaysOnTop(true);
        window.setVisible(true);
        AbstractAction scrollText = new AbstractAction(){
            boolean shouldDraw = false;

            public void actionPerformed(ActionEvent e) {
                panel.incrementYPos();
                window.repaint();
            }
        };
        final Timer timer = new Timer(100, scrollText);
        window.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                window.dispose();
                timer.stop();
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }
        });
        timer.start();
    }

    private static class ScrollingLinesPanel
    extends JPanel {
        int yPos;
        int xPos;
        ImageIcon background;
        String lines;

        public ScrollingLinesPanel(URL url, String lines) {
            this.background = new ImageIcon(url);
            this.lines = lines;
            this.yPos = this.background.getIconHeight();
            this.xPos = (int)((float)this.background.getIconWidth() / 2.0f);
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(this.background.getIconWidth(), this.background.getIconHeight()));
        }

        protected void paintComponent(Graphics g) {
            g.drawImage(this.background.getImage(), 0, 0, null);
            ((Graphics2D)g).setPaint(Color.white);
            int end = this.lines.indexOf("\n");
            int begin = 0;
            int i = 1;
            int y = this.yPos;
            while (end > 0) {
                String sub = this.lines.substring(begin, end);
                y = this.yPos + 12 * i;
                if (y > 80) {
                    g.drawString(sub, this.xPos, y);
                }
                begin = end + 1;
                end = this.lines.indexOf("\n", begin);
                ++i;
            }
            super.paintComponent(g);
        }

        public void incrementYPos() {
            this.yPos -= 2;
        }
    }
}

