/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.plugin;

import cytoscape.dialogs.plugins.PluginIndex;
import cytoscape.dialogs.plugins.PluginManageDialog;
import cytoscape.plugin.PluginInfo;
import java.util.Vector;
import junit.framework.TestCase;

public class PluginIndexTest
extends TestCase {
    private Vector allPluginVector1;
    private String siteName1 = "Cytoscape";
    private String siteName2 = "OtherSite";

    protected void setUp() throws Exception {
        this.allPluginVector1 = new Vector();
        Vector<Object> pluginVect1 = new Vector<Object>();
        PluginInfo info1 = new PluginInfo();
        info1.setDescription("This is MiMI plugin");
        pluginVect1.add(PluginManageDialog.CURRENTLY_INSTALLED);
        pluginVect1.add("categoty1");
        pluginVect1.add(info1);
        Vector<Object> pluginVect2 = new Vector<Object>();
        PluginInfo info2 = new PluginInfo();
        info2.setDescription("This is BioPax plugin");
        pluginVect2.add(PluginManageDialog.CURRENTLY_INSTALLED);
        pluginVect2.add("categoty2");
        pluginVect2.add(info2);
        Vector<Object> pluginVect3 = new Vector<Object>();
        PluginInfo info3 = new PluginInfo();
        info3.setDescription("This is another");
        pluginVect3.add(PluginManageDialog.AVAILABLE_FOR_INSTALL);
        pluginVect3.add("categoty3");
        pluginVect3.add(info3);
        this.allPluginVector1.add(pluginVect1);
        this.allPluginVector1.add(pluginVect2);
        this.allPluginVector1.add(pluginVect3);
    }

    protected void tearDown() {
    }

    public void testGetSearchResult() {
        Vector filteredPluginVector = new Vector();
        try {
            filteredPluginVector = PluginIndex.getSearchResult("testStr", false, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector, null);
        try {
            PluginIndex.setAllPluginVector(this.allPluginVector1, false, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            filteredPluginVector = PluginIndex.getSearchResult("abcd", false, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector.size(), 0);
        try {
            filteredPluginVector = PluginIndex.getSearchResult("mimi", false, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector.size(), 1);
        Vector returnedVect = (Vector)filteredPluginVector.elementAt(0);
        PluginInfo info = (PluginInfo)returnedVect.elementAt(2);
        PluginIndexTest.assertEquals(info.getDescription(), "This is MiMI plugin");
        try {
            filteredPluginVector = PluginIndex.getSearchResult("plugin", false, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector.size(), 2);
        try {
            filteredPluginVector = PluginIndex.getSearchResult("plugin", true, this.siteName1);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector, null);
        try {
            filteredPluginVector = PluginIndex.getSearchResult("plugin", false, this.siteName2);
        }
        catch (Exception e) {
            // empty catch block
        }
        PluginIndexTest.assertEquals(filteredPluginVector, null);
    }
}

