/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.readers;

import cern.colt.list.IntArrayList;
import cern.colt.map.OpenIntIntHashMap;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.Interaction;
import cytoscape.data.readers.AbstractGraphReader;
import cytoscape.task.TaskMonitor;
import cytoscape.util.FileUtil;
import cytoscape.util.PercentUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class InteractionsReader
extends AbstractGraphReader {
    private TaskMonitor taskMonitor;
    private PercentUtil percentUtil;
    protected List<Interaction> allInteractions = new ArrayList<Interaction>();
    private String zip_entry;
    private boolean is_zip = false;
    private IntArrayList node_indices;
    private OpenIntIntHashMap edges;
    private InputStream inputStream;

    public InteractionsReader(String zip_entry, TaskMonitor monitor, boolean is_zip) {
        super("zip_data");
        this.zip_entry = zip_entry;
        this.is_zip = is_zip;
        this.taskMonitor = monitor;
    }

    public InteractionsReader(String filename) {
        this(filename, null);
    }

    public InteractionsReader(String filename, TaskMonitor monitor) {
        this(FileUtil.getInputStream(filename), filename);
        this.taskMonitor = monitor;
    }

    public InteractionsReader(InputStream is, String name) {
        super(name);
        this.inputStream = is;
    }

    public void setTaskMonitor(TaskMonitor monitor) {
        this.taskMonitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read() throws IOException {
        String rawText;
        block11: {
            if (!this.is_zip) {
                try {
                    rawText = FileUtil.getInputString(this.inputStream);
                    Object var3_2 = null;
                    if (this.inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    if (this.inputStream != null) {
                        this.inputStream.close();
                        this.inputStream = null;
                    }
                    throw throwable;
                }
                this.inputStream.close();
                this.inputStream = null;
            } else {
                rawText = this.zip_entry;
            }
        }
        String delimiter = " ";
        if (rawText.indexOf("\t") >= 0) {
            delimiter = "\t";
        }
        String[] lines = rawText.split(System.getProperty("line.separator"));
        if (this.taskMonitor != null) {
            this.percentUtil = new PercentUtil(6);
        }
        int linesLength = lines.length;
        int i = 0;
        while (true) {
            String newLine;
            if (i >= linesLength) {
                this.createRootGraphFromInteractionData();
                return;
            }
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(1, i, lines.length));
            }
            if ((newLine = lines[i]).length() > 0) {
                Interaction newInteraction = new Interaction(newLine, delimiter);
                this.allInteractions.add(newInteraction);
            }
            ++i;
        }
    }

    public int getCount() {
        return this.allInteractions.size();
    }

    public Interaction[] getAllInteractions() {
        return this.allInteractions.toArray(new Interaction[0]);
    }

    protected void createRootGraphFromInteractionData() {
        Interaction interaction;
        Interaction[] interactions = this.getAllInteractions();
        HashSet<String> nodeNameSet = new HashSet<String>();
        int edgeCount = 0;
        int intSize = interactions.length;
        for (int i = 0; i < intSize; ++i) {
            interaction = interactions[i];
            String sourceName = interaction.getSource();
            nodeNameSet.add(sourceName);
            String[] targets = interaction.getTargets();
            int targetLength = targets.length;
            for (int t = 0; t < targetLength; ++t) {
                nodeNameSet.add(targets[t]);
                ++edgeCount;
            }
            if (this.taskMonitor == null) continue;
            this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(2, i, interactions.length));
        }
        Cytoscape.ensureCapacity(nodeNameSet.size(), edgeCount);
        this.node_indices = new IntArrayList(nodeNameSet.size());
        this.edges = new OpenIntIntHashMap(edgeCount);
        int counter = 0;
        for (String nodeName : nodeNameSet) {
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(3, counter, nodeNameSet.size()));
                ++counter;
            }
            CyNode node = Cytoscape.getCyNode(nodeName, true);
            this.node_indices.add(node.getRootGraphIndex());
        }
        for (int i = 0; i < interactions.length; ++i) {
            String nodeName;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(this.percentUtil.getGlobalPercent(4, i, interactions.length));
            }
            interaction = interactions[i];
            nodeName = interaction.getSource();
            String interactionType = interaction.getType();
            for (String targetNodeName : interaction.getTargets()) {
                String edgeName = CyEdge.createIdentifier(nodeName, interactionType, targetNodeName);
                CyEdge edge = Cytoscape.getCyEdge(nodeName, edgeName, targetNodeName, interactionType);
                this.edges.put(edge.getRootGraphIndex(), 0);
            }
        }
    }

    public int[] getNodeIndicesArray() {
        this.node_indices.trimToSize();
        return this.node_indices.elements();
    }

    public int[] getEdgeIndicesArray() {
        IntArrayList edge_indices = new IntArrayList(this.edges.size());
        this.edges.keys(edge_indices);
        edge_indices.trimToSize();
        return edge_indices.elements();
    }

    public void doPostProcessing(CyNetwork net) {
        this.edges.clear();
        this.node_indices.clear();
        this.edges = null;
        this.node_indices = null;
        this.allInteractions.clear();
        this.allInteractions = null;
    }
}

