/*
 * Decompiled with CFR 0.152.
 */
package ding.view;

import cytoscape.geom.rtree.RTree;
import cytoscape.geom.spacial.MutableSpacialIndex2D;
import cytoscape.geom.spacial.SpacialEntry2DEnumerator;
import cytoscape.graph.fixed.FixedGraph;
import cytoscape.render.immed.GraphGraphics;
import cytoscape.render.stateful.GraphLOD;
import cytoscape.render.stateful.GraphRenderer;
import cytoscape.util.intr.IntBTree;
import cytoscape.util.intr.IntEnumerator;
import cytoscape.util.intr.IntHash;
import cytoscape.util.intr.IntStack;
import ding.view.ArbitraryGraphicsCanvas;
import ding.view.ContentChangeListener;
import ding.view.ContentChangeListenerChain;
import ding.view.DEdgeDetails;
import ding.view.DEdgeView;
import ding.view.DNodeDetails;
import ding.view.DNodeView;
import ding.view.DingCanvas;
import ding.view.EdgeContextMenuListener;
import ding.view.GinyUtil;
import ding.view.GraphViewChangeListenerChain;
import ding.view.GraphViewEdgesHiddenEvent;
import ding.view.GraphViewEdgesRestoredEvent;
import ding.view.GraphViewEdgesUnselectedEvent;
import ding.view.GraphViewNodesHiddenEvent;
import ding.view.GraphViewNodesRestoredEvent;
import ding.view.GraphViewNodesUnselectedEvent;
import ding.view.InnerCanvas;
import ding.view.NodeContextMenuListener;
import ding.view.PrintLOD;
import ding.view.ViewportChangeListener;
import ding.view.ViewportChangeListenerChain;
import giny.model.Edge;
import giny.model.GraphPerspective;
import giny.model.Node;
import giny.model.RootGraph;
import giny.view.EdgeView;
import giny.view.GraphView;
import giny.view.GraphViewChangeListener;
import giny.view.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DGraphView
implements GraphView,
Printable {
    boolean calledFromGetSnapshot = false;
    protected static int DEF_SNAPSHOT_SIZE = 400;
    static final float DEFAULT_ANCHOR_SIZE = 9.0f;
    static final Paint DEFAULT_ANCHOR_SELECTED_PAINT = Color.red;
    static final Paint DEFAULT_ANCHOR_UNSELECTED_PAINT = Color.black;
    final Object m_lock = new Object();
    final float[] m_extentsBuff = new float[4];
    final GeneralPath m_path = new GeneralPath();
    GraphPerspective m_perspective;
    GraphPerspective m_drawPersp;
    GraphPerspective m_structPersp;
    MutableSpacialIndex2D m_spacial;
    MutableSpacialIndex2D m_spacialA;
    DNodeDetails m_nodeDetails;
    DEdgeDetails m_edgeDetails;
    PrintLOD m_printLOD;
    HashMap m_nodeViewMap;
    HashMap m_edgeViewMap;
    String m_identifier;
    final float m_defaultNodeXMin;
    final float m_defaultNodeYMin;
    final float m_defaultNodeXMax;
    final float m_defaultNodeYMax;
    InnerCanvas m_networkCanvas;
    ArbitraryGraphicsCanvas m_backgroundCanvas;
    ArbitraryGraphicsCanvas m_foregroundCanvas;
    boolean m_nodeSelection = true;
    boolean m_edgeSelection = true;
    final IntBTree m_selectedNodes;
    final IntBTree m_selectedEdges;
    final IntBTree m_selectedAnchors;
    boolean m_contentChanged = false;
    boolean m_viewportChanged = false;
    final GraphViewChangeListener[] m_lis = new GraphViewChangeListener[1];
    final ContentChangeListener[] m_cLis = new ContentChangeListener[1];
    final ViewportChangeListener[] m_vLis = new ViewportChangeListener[1];
    private final IntHash m_hash = new IntHash();
    final float[] m_anchorsBuff = new float[2];
    int m_lastSize = 0;
    Paint m_lastPaint = null;
    Paint m_lastTexturePaint = null;
    private BufferedImage snapshotImage;
    private boolean latest;

    public DGraphView(GraphPerspective perspective) {
        this.m_perspective = perspective;
        this.m_drawPersp = this.m_perspective.getRootGraph().createGraphPerspective((int[])null, (int[])null);
        this.m_structPersp = this.m_perspective.getRootGraph().createGraphPerspective((int[])null, (int[])null);
        this.m_spacial = new RTree();
        this.m_spacialA = new RTree();
        this.m_nodeDetails = new DNodeDetails(this);
        this.m_edgeDetails = new DEdgeDetails(this);
        this.m_nodeViewMap = new HashMap();
        this.m_edgeViewMap = new HashMap();
        this.m_printLOD = new PrintLOD();
        this.m_defaultNodeXMin = 0.0f;
        this.m_defaultNodeYMin = 0.0f;
        this.m_defaultNodeXMax = this.m_defaultNodeXMin + 20.0f;
        this.m_defaultNodeYMax = this.m_defaultNodeYMin + 20.0f;
        this.m_networkCanvas = new InnerCanvas(this.m_lock, this);
        this.m_backgroundCanvas = new ArbitraryGraphicsCanvas(this.m_perspective, this, this.m_networkCanvas, Color.white, true, true);
        this.addViewportChangeListener(this.m_backgroundCanvas);
        this.m_foregroundCanvas = new ArbitraryGraphicsCanvas(this.m_perspective, this, this.m_networkCanvas, Color.white, true, false);
        this.addViewportChangeListener(this.m_foregroundCanvas);
        this.m_selectedNodes = new IntBTree();
        this.m_selectedEdges = new IntBTree();
        this.m_selectedAnchors = new IntBTree();
        this.addContentChangeListener(new DGraphViewContentChangeListener());
        this.snapshotImage = null;
        this.latest = false;
    }

    @Override
    public GraphPerspective getGraphPerspective() {
        return this.m_perspective;
    }

    @Override
    public boolean nodeSelectionEnabled() {
        return this.m_nodeSelection;
    }

    @Override
    public boolean edgeSelectionEnabled() {
        return this.m_edgeSelection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableNodeSelection() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_nodeSelection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableNodeSelection() {
        int[] unselectedNodes;
        Object object = this.m_lock;
        synchronized (object) {
            this.m_nodeSelection = false;
            unselectedNodes = this.getSelectedNodeIndices();
            if (unselectedNodes.length > 0) {
                this.m_selectedNodes.empty();
                for (int i = 0; i < unselectedNodes.length; ++i) {
                    ((DNodeView)this.getNodeView(unselectedNodes[i])).unselectInternal();
                }
                this.m_contentChanged = true;
            }
        }
        if (unselectedNodes.length > 0) {
            GraphViewChangeListener listener = this.m_lis[0];
            if (listener != null) {
                listener.graphViewChanged(new GraphViewNodesUnselectedEvent(this, unselectedNodes));
            }
            this.updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enableEdgeSelection() {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_edgeSelection = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disableEdgeSelection() {
        int[] unselectedEdges;
        Object object = this.m_lock;
        synchronized (object) {
            this.m_edgeSelection = false;
            unselectedEdges = this.getSelectedEdgeIndices();
            if (unselectedEdges.length > 0) {
                this.m_selectedEdges.empty();
                for (int i = 0; i < unselectedEdges.length; ++i) {
                    ((DEdgeView)this.getEdgeView(unselectedEdges[i])).unselectInternal();
                }
                this.m_contentChanged = true;
            }
        }
        if (unselectedEdges.length > 0) {
            GraphViewChangeListener listener = this.m_lis[0];
            if (listener != null) {
                listener.graphViewChanged(new GraphViewEdgesUnselectedEvent(this, unselectedEdges));
            }
            this.updateView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedNodeIndices() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            int[] returnThis = new int[elms.numRemaining()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = ~elms.nextInt();
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSelectedNodes() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            ArrayList returnThis = new ArrayList();
            while (elms.numRemaining() > 0) {
                returnThis.add(this.m_nodeViewMap.get(new Integer(~elms.nextInt())));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getSelectedEdgeIndices() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedEdges.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            int[] returnThis = new int[elms.numRemaining()];
            for (int i = 0; i < returnThis.length; ++i) {
                returnThis[i] = ~elms.nextInt();
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getSelectedEdges() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator elms = this.m_selectedEdges.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            ArrayList returnThis = new ArrayList();
            while (elms.numRemaining() > 0) {
                returnThis.add(this.m_edgeViewMap.get(new Integer(~elms.nextInt())));
            }
            return returnThis;
        }
    }

    @Override
    public void addGraphViewChangeListener(GraphViewChangeListener l) {
        this.m_lis[0] = GraphViewChangeListenerChain.add(this.m_lis[0], l);
    }

    @Override
    public void removeGraphViewChangeListener(GraphViewChangeListener l) {
        this.m_lis[0] = GraphViewChangeListenerChain.remove(this.m_lis[0], l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBackgroundPaint(Paint paint) {
        Object object = this.m_lock;
        synchronized (object) {
            if (paint instanceof Color) {
                this.m_backgroundCanvas.setBackground((Color)paint);
                this.m_contentChanged = true;
            } else {
                System.out.println("DGraphView.setBackgroundPaint(): Paint argument must be a Color instance!");
            }
        }
    }

    @Override
    public Paint getBackgroundPaint() {
        return this.m_backgroundCanvas.getBackground();
    }

    @Override
    public Component getComponent() {
        return this.m_networkCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeView addNodeView(int nodeInx) {
        NodeView newView = null;
        Object object = this.m_lock;
        synchronized (object) {
            newView = this.addNodeViewInternal(nodeInx);
            if (newView == null) {
                return (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
            }
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            listener.graphViewChanged(new GraphViewNodesRestoredEvent(this, new int[]{newView.getRootGraphIndex()}));
        }
        return newView;
    }

    private NodeView addNodeViewInternal(int nodeInx) {
        NodeView oldView = (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
        if (oldView != null) {
            return null;
        }
        if (this.m_drawPersp.restoreNode(nodeInx) == 0) {
            if (this.m_drawPersp.getNode(nodeInx) != null) {
                throw new IllegalStateException("something weird is going on - node already existed in graph but a view for it did not exist (debug)");
            }
            throw new IllegalArgumentException("node index specified does not exist in underlying RootGraph");
        }
        this.m_structPersp.restoreNode(nodeInx);
        DNodeView newView = new DNodeView(this, nodeInx);
        this.m_nodeViewMap.put(new Integer(nodeInx), newView);
        this.m_spacial.insert(~nodeInx, this.m_defaultNodeXMin, this.m_defaultNodeYMin, this.m_defaultNodeXMax, this.m_defaultNodeYMax);
        return newView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeView addEdgeView(int edgeInx) {
        NodeView sourceNode = null;
        NodeView targetNode = null;
        DEdgeView edgeView = null;
        Object object = this.m_lock;
        synchronized (object) {
            EdgeView oldView = (EdgeView)this.m_edgeViewMap.get(new Integer(edgeInx));
            if (oldView != null) {
                return oldView;
            }
            Edge edge = this.m_drawPersp.getRootGraph().getEdge(edgeInx);
            if (edge == null) {
                throw new IllegalArgumentException("edge index specified does not exist in underlying RootGraph");
            }
            sourceNode = this.addNodeViewInternal(edge.getSource().getRootGraphIndex());
            targetNode = this.addNodeViewInternal(edge.getTarget().getRootGraphIndex());
            if (this.m_drawPersp.restoreEdge(edgeInx) == 0) {
                if (this.m_drawPersp.getEdge(edgeInx) != null) {
                    throw new IllegalStateException("something weird is going on - edge already existed in graph but a view for it did not exist (debug)");
                }
                throw new IllegalArgumentException("edge index specified does not exist in underlying RootGraph");
            }
            this.m_structPersp.restoreEdge(edgeInx);
            edgeView = new DEdgeView(this, edgeInx);
            this.m_edgeViewMap.put(new Integer(edgeInx), edgeView);
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            if (sourceNode != null || targetNode != null) {
                int[] nodeInx = sourceNode == null ? new int[]{targetNode.getRootGraphIndex()} : (targetNode == null ? new int[]{sourceNode.getRootGraphIndex()} : new int[]{sourceNode.getRootGraphIndex(), targetNode.getRootGraphIndex()});
                listener.graphViewChanged(new GraphViewNodesRestoredEvent(this, nodeInx));
            }
            listener.graphViewChanged(new GraphViewEdgesRestoredEvent(this, new int[]{edgeView.getRootGraphIndex()}));
        }
        return edgeView;
    }

    @Override
    public EdgeView addEdgeView(String className, int edgeInx) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public NodeView addNodeView(String className, int nodeInx) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public NodeView addNodeView(int nodeInx, NodeView replacement) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public NodeView removeNodeView(NodeView nodeView) {
        return this.removeNodeView(nodeView.getRootGraphIndex());
    }

    @Override
    public NodeView removeNodeView(Node node) {
        return this.removeNodeView(node.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeView removeNodeView(int nodeInx) {
        DNodeView returnThis;
        int[] hiddenEdgeInx;
        Object object = this.m_lock;
        synchronized (object) {
            hiddenEdgeInx = this.m_structPersp.getAdjacentEdgeIndicesArray(nodeInx, true, true, true);
            if (hiddenEdgeInx == null) {
                return null;
            }
            for (int i = 0; i < hiddenEdgeInx.length; ++i) {
                this.removeEdgeViewInternal(hiddenEdgeInx[i]);
            }
            returnThis = (DNodeView)this.m_nodeViewMap.remove(new Integer(nodeInx));
            returnThis.unselectInternal();
            this.m_drawPersp.hideNode(nodeInx);
            this.m_structPersp.hideNode(nodeInx);
            this.m_nodeDetails.unregisterNode(~nodeInx);
            this.m_spacial.delete(~nodeInx);
            returnThis.graphView = null;
            this.m_contentChanged = true;
        }
        GraphViewChangeListener listener = this.m_lis[0];
        if (listener != null) {
            if (hiddenEdgeInx.length > 0) {
                listener.graphViewChanged(new GraphViewEdgesHiddenEvent(this, hiddenEdgeInx));
            }
            listener.graphViewChanged(new GraphViewNodesHiddenEvent(this, new int[]{returnThis.getRootGraphIndex()}));
        }
        return returnThis;
    }

    @Override
    public EdgeView removeEdgeView(EdgeView edgeView) {
        return this.removeEdgeView(edgeView.getRootGraphIndex());
    }

    @Override
    public EdgeView removeEdgeView(Edge edge) {
        return this.removeEdgeView(edge.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeView removeEdgeView(int edgeInx) {
        GraphViewChangeListener listener;
        DEdgeView returnThis;
        Object object = this.m_lock;
        synchronized (object) {
            returnThis = this.removeEdgeViewInternal(edgeInx);
            if (returnThis != null) {
                this.m_contentChanged = true;
            }
        }
        if (returnThis != null && (listener = this.m_lis[0]) != null) {
            listener.graphViewChanged(new GraphViewEdgesHiddenEvent(this, new int[]{returnThis.getRootGraphIndex()}));
        }
        return returnThis;
    }

    private DEdgeView removeEdgeViewInternal(int edgeInx) {
        DEdgeView returnThis = (DEdgeView)this.m_edgeViewMap.remove(new Integer(edgeInx));
        if (returnThis == null) {
            return returnThis;
        }
        returnThis.unselectInternal();
        this.m_drawPersp.hideEdge(edgeInx);
        this.m_structPersp.hideEdge(edgeInx);
        this.m_edgeDetails.unregisterEdge(~edgeInx);
        returnThis.m_view = null;
        return returnThis;
    }

    @Override
    public String getIdentifier() {
        return this.m_identifier;
    }

    @Override
    public void setIdentifier(String id) {
        this.m_identifier = id;
    }

    @Override
    public double getZoom() {
        return this.m_networkCanvas.m_scaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setZoom(double zoom, boolean updateView) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_networkCanvas.m_scaleFactor = this.checkZoom(zoom, this.m_networkCanvas.m_scaleFactor);
            this.m_viewportChanged = true;
        }
        if (updateView) {
            this.updateView();
        }
    }

    @Override
    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fitContent(boolean updateView) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_spacial.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, this.m_extentsBuff, 0, false).numRemaining() == 0) {
                return;
            }
            this.m_networkCanvas.m_xCenter = ((double)this.m_extentsBuff[0] + (double)this.m_extentsBuff[2]) / 2.0;
            this.m_networkCanvas.m_yCenter = ((double)this.m_extentsBuff[1] + (double)this.m_extentsBuff[3]) / 2.0;
            double zoom = Math.min((double)this.m_networkCanvas.getWidth() / ((double)this.m_extentsBuff[2] - (double)this.m_extentsBuff[0]), (double)this.m_networkCanvas.getHeight() / ((double)this.m_extentsBuff[3] - (double)this.m_extentsBuff[1]));
            this.m_networkCanvas.m_scaleFactor = this.checkZoom(zoom, this.m_networkCanvas.m_scaleFactor);
            if (this.calledFromGetSnapshot) {
                this.calledFromGetSnapshot = false;
                this.m_networkCanvas.m_scaleFactor = 1.0;
            }
            this.m_viewportChanged = true;
        }
        if (updateView) {
            this.updateView();
        }
    }

    @Override
    public void fitContent() {
        this.fitContent(true);
    }

    @Override
    public void updateView() {
        this.m_networkCanvas.repaint();
    }

    @Override
    public RootGraph getRootGraph() {
        return this.m_perspective.getRootGraph();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getNodeViewsIterator() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_nodeViewMap.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNodeViewCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_nodeViewMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getEdgeViewCount() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_edgeViewMap.size();
        }
    }

    @Override
    public NodeView getNodeView(Node node) {
        return this.getNodeView(node.getRootGraphIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeView getNodeView(int nodeInx) {
        Object object = this.m_lock;
        synchronized (object) {
            return (NodeView)this.m_nodeViewMap.get(new Integer(nodeInx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEdgeViewsList() {
        Object object = this.m_lock;
        synchronized (object) {
            ArrayList returnThis = new ArrayList(this.m_edgeViewMap.size());
            Iterator values = this.m_edgeViewMap.values().iterator();
            while (values.hasNext()) {
                returnThis.add(values.next());
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEdgeViewsList(Node oneNode, Node otherNode) {
        Object object = this.m_lock;
        synchronized (object) {
            List edges = this.m_structPersp.edgesList(oneNode.getRootGraphIndex(), otherNode.getRootGraphIndex(), true);
            if (edges == null) {
                return null;
            }
            ArrayList<EdgeView> returnThis = new ArrayList<EdgeView>();
            for (Edge e : edges) {
                returnThis.add(this.getEdgeView(e));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List getEdgeViewsList(int oneNodeInx, int otherNodeInx, boolean includeUndirected) {
        Object object = this.m_lock;
        synchronized (object) {
            List edges = this.m_structPersp.edgesList(oneNodeInx, otherNodeInx, includeUndirected);
            if (edges == null) {
                return null;
            }
            ArrayList<EdgeView> returnThis = new ArrayList<EdgeView>();
            for (Edge e : edges) {
                returnThis.add(this.getEdgeView(e));
            }
            return returnThis;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeView getEdgeView(int edgeInx) {
        Object object = this.m_lock;
        synchronized (object) {
            return (EdgeView)this.m_edgeViewMap.get(new Integer(edgeInx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator getEdgeViewsIterator() {
        Object object = this.m_lock;
        synchronized (object) {
            return this.m_edgeViewMap.values().iterator();
        }
    }

    @Override
    public EdgeView getEdgeView(Edge edge) {
        return this.getEdgeView(edge.getRootGraphIndex());
    }

    @Override
    public int edgeCount() {
        return this.getEdgeViewCount();
    }

    @Override
    public int nodeCount() {
        return this.getNodeViewCount();
    }

    @Override
    public boolean hideGraphObject(Object obj) {
        return this.hideGraphObjectInternal(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hideGraphObjectInternal(Object obj, boolean fireListenerEvents) {
        if (obj instanceof DEdgeView) {
            GraphViewChangeListener listener;
            int edgeInx;
            Object object = this.m_lock;
            synchronized (object) {
                edgeInx = ((DEdgeView)obj).getRootGraphIndex();
                if (this.m_drawPersp.hideEdge(edgeInx) == 0) {
                    return false;
                }
                ((DEdgeView)obj).unselectInternal();
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                listener.graphViewChanged(new GraphViewEdgesHiddenEvent(this, new int[]{edgeInx}));
            }
            return true;
        }
        if (obj instanceof DNodeView) {
            GraphViewChangeListener listener;
            int[] edges;
            int nodeInx;
            Object object = this.m_lock;
            synchronized (object) {
                DNodeView nView = (DNodeView)obj;
                nodeInx = nView.getRootGraphIndex();
                edges = this.m_drawPersp.getAdjacentEdgeIndicesArray(nodeInx, true, true, true);
                if (edges == null) {
                    return false;
                }
                for (int i = 0; i < edges.length; ++i) {
                    this.hideGraphObjectInternal(this.m_edgeViewMap.get(new Integer(edges[i])), false);
                }
                nView.unselectInternal();
                this.m_spacial.exists(~nodeInx, this.m_extentsBuff, 0);
                nView.m_hiddenXMin = this.m_extentsBuff[0];
                nView.m_hiddenYMin = this.m_extentsBuff[1];
                nView.m_hiddenXMax = this.m_extentsBuff[2];
                nView.m_hiddenYMax = this.m_extentsBuff[3];
                this.m_drawPersp.hideNode(nodeInx);
                this.m_spacial.delete(~nodeInx);
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                if (edges.length > 0) {
                    listener.graphViewChanged(new GraphViewEdgesHiddenEvent(this, edges));
                }
                listener.graphViewChanged(new GraphViewNodesHiddenEvent(this, new int[]{nodeInx}));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean showGraphObject(Object obj) {
        return this.showGraphObjectInternal(obj, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean showGraphObjectInternal(Object obj, boolean fireListenerEvents) {
        if (obj instanceof DNodeView) {
            GraphViewChangeListener listener;
            int nodeInx;
            Object object = this.m_lock;
            synchronized (object) {
                DNodeView nView = (DNodeView)obj;
                nodeInx = nView.getRootGraphIndex();
                if (this.m_structPersp.getNode(nodeInx) == null) {
                    return false;
                }
                if (this.m_drawPersp.restoreNode(nodeInx) == 0) {
                    return false;
                }
                this.m_spacial.insert(~nodeInx, nView.m_hiddenXMin, nView.m_hiddenYMin, nView.m_hiddenXMax, nView.m_hiddenYMax);
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                listener.graphViewChanged(new GraphViewNodesRestoredEvent(this, new int[]{nodeInx}));
            }
            return true;
        }
        if (obj instanceof DEdgeView) {
            GraphViewChangeListener listener;
            int sourceNode = 0;
            int targetNode = 0;
            int newEdge = 0;
            Object object = this.m_lock;
            synchronized (object) {
                Edge edge = this.m_structPersp.getEdge(((DEdgeView)obj).getRootGraphIndex());
                if (edge == null) {
                    return false;
                }
                sourceNode = edge.getSource().getRootGraphIndex();
                if (!this.showGraphObjectInternal(this.getNodeView(sourceNode), false)) {
                    sourceNode = 0;
                }
                if (!this.showGraphObjectInternal(this.getNodeView(targetNode = edge.getTarget().getRootGraphIndex()), false)) {
                    targetNode = 0;
                }
                if (this.m_drawPersp.restoreEdge(newEdge = edge.getRootGraphIndex()) == 0) {
                    return false;
                }
                this.m_contentChanged = true;
            }
            if (fireListenerEvents && (listener = this.m_lis[0]) != null) {
                if (sourceNode != 0) {
                    listener.graphViewChanged(new GraphViewNodesRestoredEvent(this, new int[]{sourceNode}));
                }
                if (targetNode != 0) {
                    listener.graphViewChanged(new GraphViewNodesRestoredEvent(this, new int[]{targetNode}));
                }
                listener.graphViewChanged(new GraphViewEdgesRestoredEvent(this, new int[]{newEdge}));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hideGraphObjects(List objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.hideGraphObject(it.next());
        }
        return true;
    }

    @Override
    public boolean showGraphObjects(List objects) {
        Iterator it = objects.iterator();
        while (it.hasNext()) {
            this.showGraphObject(it.next());
        }
        return true;
    }

    @Override
    public Object[] getContextMethods(String className, boolean plusSuperclass) {
        return null;
    }

    @Override
    public Object[] getContextMethods(String className, Object[] methods) {
        return null;
    }

    @Override
    public boolean addContextMethod(String className, String methodClassName, String methodName, Object[] args, ClassLoader loader) {
        return false;
    }

    @Override
    public void setAllNodePropertyData(int nodeInx, Object[] data) {
    }

    @Override
    public Object[] getAllNodePropertyData(int nodeInx) {
        return null;
    }

    @Override
    public void setAllEdgePropertyData(int edgeInx, Object[] data) {
    }

    @Override
    public Object[] getAllEdgePropertyData(int edgeInx) {
        return null;
    }

    @Override
    public Object getNodeObjectProperty(int nodeInx, int property) {
        return null;
    }

    @Override
    public boolean setNodeObjectProperty(int nodeInx, int property, Object value) {
        return false;
    }

    @Override
    public Object getEdgeObjectProperty(int edgeInx, int property) {
        return null;
    }

    @Override
    public boolean setEdgeObjectProperty(int edgeInx, int property, Object value) {
        return false;
    }

    @Override
    public double getNodeDoubleProperty(int nodeInx, int property) {
        return 0.0;
    }

    @Override
    public boolean setNodeDoubleProperty(int nodeInx, int property, double val) {
        return false;
    }

    @Override
    public double getEdgeDoubleProperty(int edgeInx, int property) {
        return 0.0;
    }

    @Override
    public boolean setEdgeDoubleProperty(int edgeInx, int property, double val) {
        return false;
    }

    @Override
    public float getNodeFloatProperty(int nodeInx, int property) {
        return 0.0f;
    }

    @Override
    public boolean setNodeFloatProperty(int nodeInx, int property, float value) {
        return false;
    }

    @Override
    public float getEdgeFloatProperty(int edgeInx, int property) {
        return 0.0f;
    }

    @Override
    public boolean setEdgeFloatProperty(int edgeInx, int property, float value) {
        return false;
    }

    @Override
    public boolean getNodeBooleanProperty(int nodeInx, int property) {
        return false;
    }

    @Override
    public boolean setNodeBooleanProperty(int nodeInx, int property, boolean val) {
        return false;
    }

    @Override
    public boolean getEdgeBooleanProperty(int edgeInx, int property) {
        return false;
    }

    @Override
    public boolean setEdgeBooleanProperty(int edgeInx, int property, boolean val) {
        return false;
    }

    @Override
    public int getNodeIntProperty(int nodeInx, int property) {
        return 0;
    }

    @Override
    public boolean setNodeIntProperty(int nodeInx, int property, int value) {
        return false;
    }

    @Override
    public int getEdgeIntProperty(int edgeInx, int property) {
        return 0;
    }

    @Override
    public boolean setEdgeIntProperty(int edgeInx, int property, int value) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenter(double x, double y) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_networkCanvas.m_xCenter = x;
            this.m_networkCanvas.m_yCenter = y;
            this.m_viewportChanged = true;
        }
        this.updateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point2D getCenter() {
        Object object = this.m_lock;
        synchronized (object) {
            return new Point2D.Double(this.m_networkCanvas.m_xCenter, this.m_networkCanvas.m_yCenter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fitSelected() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator selectedElms = this.m_selectedNodes.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            if (selectedElms.numRemaining() == 0 && this.edgeSelectionEnabled() && (selectedElms = this.getSelectedEdgeNodes()).numRemaining() == 0) {
                return;
            }
            float xMin = Float.POSITIVE_INFINITY;
            float yMin = Float.POSITIVE_INFINITY;
            float xMax = Float.NEGATIVE_INFINITY;
            float yMax = Float.NEGATIVE_INFINITY;
            int leftMost = 0;
            int rightMost = 0;
            while (selectedElms.numRemaining() > 0) {
                int node = selectedElms.nextInt();
                this.m_spacial.exists(node, this.m_extentsBuff, 0);
                if (this.m_extentsBuff[0] < xMin) {
                    xMin = this.m_extentsBuff[0];
                    leftMost = node;
                }
                if (this.m_extentsBuff[2] > xMax) {
                    xMax = this.m_extentsBuff[2];
                    rightMost = node;
                }
                yMin = Math.min(yMin, this.m_extentsBuff[1]);
                yMax = Math.max(yMax, this.m_extentsBuff[3]);
            }
            this.m_networkCanvas.m_xCenter = ((double)(xMin -= (float)(this.getLabelWidth(leftMost) / 2)) + (double)(xMax += (float)(this.getLabelWidth(rightMost) / 2))) / 2.0;
            this.m_networkCanvas.m_yCenter = ((double)yMin + (double)yMax) / 2.0;
            double zoom = Math.min((double)this.m_networkCanvas.getWidth() / ((double)xMax - (double)xMin), (double)this.m_networkCanvas.getHeight() / ((double)yMax - (double)yMin));
            this.m_networkCanvas.m_scaleFactor = this.checkZoom(zoom, this.m_networkCanvas.m_scaleFactor);
            this.m_viewportChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IntEnumerator getSelectedEdgeNodes() {
        Object object = this.m_lock;
        synchronized (object) {
            IntEnumerator selectedEdges = this.m_selectedEdges.searchRange(Integer.MIN_VALUE, Integer.MAX_VALUE, false);
            IntHash nodeIds = new IntHash();
            while (selectedEdges.numRemaining() > 0) {
                int edge = ~selectedEdges.nextInt();
                Edge currEdge = this.getEdgeView(edge).getEdge();
                Node source = currEdge.getSource();
                int sourceId = ~source.getRootGraphIndex();
                nodeIds.put(sourceId);
                Node target = currEdge.getTarget();
                int targetId = ~target.getRootGraphIndex();
                nodeIds.put(targetId);
            }
            return nodeIds.elements();
        }
    }

    private int getLabelWidth(int node) {
        DNodeView x = (DNodeView)this.getNodeView(~node);
        if (x == null) {
            return 0;
        }
        String s = x.getText();
        if (s == null) {
            return 0;
        }
        char[] lab = s.toCharArray();
        if (lab == null) {
            return 0;
        }
        if (this.m_networkCanvas.m_fontMetrics == null) {
            return 0;
        }
        return this.m_networkCanvas.m_fontMetrics.charsWidth(lab, 0, lab.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGraphLOD(GraphLOD lod) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_networkCanvas.m_lod[0] = lod;
            this.m_contentChanged = true;
        }
    }

    public GraphLOD getGraphLOD() {
        return this.m_networkCanvas.m_lod[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPrintingTextAsShape(boolean textAsShape) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_printLOD.setPrintingTextAsShape(textAsShape);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getNodesIntersectingRectangle(double xMinimum, double yMinimum, double xMaximum, double yMaximum, boolean treatNodeShapesAsRectangle, IntStack returnVal) {
        Object object = this.m_lock;
        synchronized (object) {
            float xMin = (float)xMinimum;
            float yMin = (float)yMinimum;
            float xMax = (float)xMaximum;
            float yMax = (float)yMaximum;
            SpacialEntry2DEnumerator under = this.m_spacial.queryOverlap(xMin, yMin, xMax, yMax, null, 0, false);
            int totalHits = under.numRemaining();
            if (treatNodeShapesAsRectangle) {
                for (int i = 0; i < totalHits; ++i) {
                    returnVal.push(~under.nextInt());
                }
            } else {
                double x = xMin;
                double y = yMin;
                double w = (double)xMax - (double)xMin;
                double h = (double)yMax - (double)yMin;
                for (int i = 0; i < totalHits; ++i) {
                    int node = under.nextExtents(this.m_extentsBuff, 0);
                    if (this.m_extentsBuff[0] < xMin && this.m_extentsBuff[1] < yMin || this.m_extentsBuff[0] < xMin && this.m_extentsBuff[3] > yMax || this.m_extentsBuff[2] > xMax && this.m_extentsBuff[3] > yMax || this.m_extentsBuff[2] > xMax && this.m_extentsBuff[1] < yMin) {
                        this.m_networkCanvas.m_grafx.getNodeShape(this.m_nodeDetails.shape(node), this.m_extentsBuff[0], this.m_extentsBuff[1], this.m_extentsBuff[2], this.m_extentsBuff[3], this.m_path);
                        if (w > 0.0 && h > 0.0) {
                            if (!this.m_path.intersects(x, y, w, h)) continue;
                            returnVal.push(~node);
                            continue;
                        }
                        if (!this.m_path.contains(x, y)) continue;
                        returnVal.push(~node);
                        continue;
                    }
                    returnVal.push(~node);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryDrawnEdges(int xMin, int yMin, int xMax, int yMax, IntStack returnVal) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_networkCanvas.computeEdgesIntersecting(xMin, yMin, xMax, yMax, returnVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExtents(double[] extentsBuff) {
        Object object = this.m_lock;
        synchronized (object) {
            if (this.m_spacial.queryOverlap(Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, this.m_extentsBuff, 0, false).numRemaining() == 0) {
                return false;
            }
            extentsBuff[0] = this.m_extentsBuff[0];
            extentsBuff[1] = this.m_extentsBuff[1];
            extentsBuff[2] = this.m_extentsBuff[2];
            extentsBuff[3] = this.m_extentsBuff[3];
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void xformComponentToNodeCoords(double[] coords) {
        Object object = this.m_lock;
        synchronized (object) {
            this.m_networkCanvas.m_grafx.xformImageToNodeCoords(coords);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSnapshot(Image img, GraphLOD lod, Paint bgPaint, double xCenter, double yCenter, double scaleFactor) {
        Object object = this.m_lock;
        synchronized (object) {
            GraphRenderer.renderGraph((FixedGraph)((Object)this.m_drawPersp), this.m_spacial, lod, this.m_nodeDetails, this.m_edgeDetails, this.m_hash, new GraphGraphics(img, false), bgPaint, xCenter, yCenter, scaleFactor);
        }
    }

    public void addContentChangeListener(ContentChangeListener l) {
        this.m_cLis[0] = ContentChangeListenerChain.add(this.m_cLis[0], l);
    }

    public void removeContentChangeListener(ContentChangeListener l) {
        this.m_cLis[0] = ContentChangeListenerChain.remove(this.m_cLis[0], l);
    }

    public void addViewportChangeListener(ViewportChangeListener l) {
        this.m_vLis[0] = ViewportChangeListenerChain.add(this.m_vLis[0], l);
    }

    public void removeViewportChangeListener(ViewportChangeListener l) {
        this.m_vLis[0] = ViewportChangeListenerChain.remove(this.m_vLis[0], l);
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int page) {
        if (page == 0) {
            ((Graphics2D)g).translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double image_scale = Math.min(pageFormat.getImageableWidth() / (double)this.getComponent().getWidth(), pageFormat.getImageableHeight() / (double)this.getComponent().getHeight());
            if (image_scale < 1.0) {
                ((Graphics2D)g).scale(image_scale, image_scale);
            }
            g.clipRect(0, 0, this.getComponent().getWidth(), this.getComponent().getHeight());
            this.getComponent().print(g);
            return 0;
        }
        return 1;
    }

    public InnerCanvas getCanvas() {
        return this.m_networkCanvas;
    }

    public DingCanvas getCanvas(Canvas canvasId) {
        if (canvasId == Canvas.BACKGROUND_CANVAS) {
            return this.m_backgroundCanvas;
        }
        if (canvasId == Canvas.NETWORK_CANVAS) {
            return this.m_networkCanvas;
        }
        if (canvasId == Canvas.FOREGROUND_CANVAS) {
            return this.m_foregroundCanvas;
        }
        return null;
    }

    private Image createImage(int width, int height, double shrink, boolean skipBackground) {
        Dimension originalSize;
        if (width < 0 || height < 0) {
            throw new IllegalArgumentException("DGraphView.createImage(int width, int height): width and height arguments must be greater than zero");
        }
        if (shrink < 0.0 || shrink > 1.0) {
            System.out.println("DGraphView.createImage(width,height,shrink) shrink is invalid: " + shrink + "  using default of 1.0");
            shrink = 1.0;
        }
        BufferedImage image = new BufferedImage(width, height, 3);
        Graphics g = ((Image)image).getGraphics();
        if (!skipBackground) {
            originalSize = this.m_backgroundCanvas.getSize();
            this.m_backgroundCanvas.setSize(width, height);
            this.m_backgroundCanvas.paint(g);
            this.m_backgroundCanvas.setSize(originalSize);
        }
        originalSize = this.m_networkCanvas.getSize();
        this.m_networkCanvas.setSize(width, height);
        this.fitContent(false);
        this.setZoom(this.getZoom() * shrink, false);
        this.m_networkCanvas.paint(g);
        this.m_networkCanvas.setSize(originalSize);
        this.fitContent(false);
        originalSize = this.m_foregroundCanvas.getSize();
        this.m_foregroundCanvas.setSize(width, height);
        this.m_foregroundCanvas.paint(g);
        this.m_foregroundCanvas.setSize(originalSize);
        return image;
    }

    public Image createImage(int width, int height, double shrink) {
        return this.createImage(width, height, shrink, false);
    }

    public NodeView getPickedNodeView(Point2D pt) {
        NodeView nv = null;
        double[] locn = new double[]{pt.getX(), pt.getY()};
        int chosenNode = 0;
        this.xformComponentToNodeCoords(locn);
        IntStack nodeStack = new IntStack();
        this.getNodesIntersectingRectangle((float)locn[0], (float)locn[1], (float)locn[0], (float)locn[1], (this.m_networkCanvas.getLastRenderDetail() & 1) == 0, nodeStack);
        int n = chosenNode = nodeStack.size() > 0 ? nodeStack.peek() : 0;
        if (chosenNode != 0) {
            nv = this.getNodeView(chosenNode);
        }
        return nv;
    }

    public EdgeView getPickedEdgeView(Point2D pt) {
        EdgeView ev = null;
        IntStack edgeStack = new IntStack();
        this.queryDrawnEdges((int)pt.getX(), (int)pt.getY(), (int)pt.getX(), (int)pt.getY(), edgeStack);
        int chosenEdge = 0;
        int n = chosenEdge = edgeStack.size() > 0 ? edgeStack.peek() : 0;
        if (chosenEdge != 0) {
            ev = this.getEdgeView(chosenEdge);
        }
        return ev;
    }

    public void addNodeContextMenuListener(NodeContextMenuListener l) {
        this.getCanvas().addNodeContextMenuListener(l);
    }

    public void removeNodeContextMenuListener(NodeContextMenuListener l) {
        this.getCanvas().removeNodeContextMenuListener(l);
    }

    public void addEdgeContextMenuListener(EdgeContextMenuListener l) {
        this.getCanvas().addEdgeContextMenuListener(l);
    }

    public void removeEdgeContextMenuListener(EdgeContextMenuListener l) {
        this.getCanvas().removeEdgeContextMenuListener(l);
    }

    public final float getAnchorSize() {
        return 9.0f;
    }

    public final Paint getAnchorSelectedPaint() {
        return DEFAULT_ANCHOR_SELECTED_PAINT;
    }

    public final Paint getAnchorUnselectedPaint() {
        return DEFAULT_ANCHOR_UNSELECTED_PAINT;
    }

    public static Map<Integer, Shape> getNodeShapes() {
        Map<Byte, Shape> nodeShapes = GraphGraphics.getNodeShapes();
        HashMap<Integer, Shape> ginyKeyShapes = new HashMap<Integer, Shape>();
        for (Byte key : nodeShapes.keySet()) {
            Shape shape = nodeShapes.get(key);
            ginyKeyShapes.put(GinyUtil.getGinyNodeType(key), shape);
        }
        return ginyKeyShapes;
    }

    public static Map<Integer, Shape> getArrowShapes() {
        Map<Byte, Shape> arrowShapes = GraphGraphics.getArrowShapes();
        HashMap<Integer, Shape> ginyKeyShapes = new HashMap<Integer, Shape>();
        for (Byte key : arrowShapes.keySet()) {
            Shape shape = arrowShapes.get(key);
            ginyKeyShapes.put(GinyUtil.getGinyArrowType(key), shape);
        }
        return ginyKeyShapes;
    }

    private double checkZoom(double zoom, double orig) {
        if (zoom > 0.0) {
            return zoom;
        }
        return orig;
    }

    TexturePaint getSnapshot(double width, double height) {
        if (!this.latest) {
            this.snapshotImage = (BufferedImage)this.createImage(DEF_SNAPSHOT_SIZE, DEF_SNAPSHOT_SIZE, 1.0, true);
            this.latest = true;
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(-width / 2.0, -height / 2.0, width, height);
        TexturePaint texturePaint = new TexturePaint(this.snapshotImage, rect);
        return texturePaint;
    }

    private byte[] convertToCompressedImage(BufferedImage bufferedImage) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(100000);
            ImageIO.write((RenderedImage)bufferedImage, "png", baos);
            byte[] retval = baos.toByteArray();
            return retval;
        }
        catch (IOException e) {
            System.err.println("Failed to convert a BufferedImage to a PNG! (" + e + ")");
            return null;
        }
    }

    private BufferedImage convertToBufferedImage(byte[] compressedImage) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(compressedImage);
            BufferedImage retval = ImageIO.read(is);
            return retval;
        }
        catch (IOException e) {
            System.err.println("Failed to convert a PNG to a BufferedImage! (" + e + ")");
            return null;
        }
    }

    private final class DGraphViewContentChangeListener
    implements ContentChangeListener {
        private DGraphViewContentChangeListener() {
        }

        public void contentChanged() {
            DGraphView.this.latest = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ShapeType {
        NODE_SHAPE,
        LINE_TYPE,
        ARROW_SHAPE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Canvas {
        BACKGROUND_CANVAS,
        NETWORK_CANVAS,
        FOREGROUND_CANVAS;

    }
}

