## ----knitr, echo=FALSE, results="hide"-----------------------------------
library("knitr")
opts_chunk$set(tidy=FALSE,
               fig.width=9,fig.height=5,
               message=FALSE)

## ----style, eval=TRUE, echo=FALSE, results="asis"---------------------------------------
BiocStyle::latex()

## ----package-load,message=FALSE---------------------------------------------------------
library(DEGreport)
data(humanSexDEedgeR)
library(edgeR)

## ----chunk-1----------------------------------------------------------------------------
des<-humanSexDEedgeR$design
fit <- glmFit(humanSexDEedgeR,des)
lrt <- glmLRT(fit)
tab<-cbind(lrt$table,p.adjust(lrt$table$PValue,method="BH"))
detags <- rownames(tab[tab[,5]<=0.1,])
plotSmear(humanSexDEedgeR, de.tags=detags)

## ----chunk-2----------------------------------------------------------------------------
counts<-cpm(humanSexDEedgeR,log=FALSE)
g1<-colnames(counts)[1:41]
g2<-colnames(counts)[42:85]
design<-data.frame(condition=sub("1","Male",sub("0","Female",des[,2])))

## ----chunk-3----------------------------------------------------------------------------
data(geneInfo)

## ----chunk-4----------------------------------------------------------------------------
detag10<-detags[1:10]
pval<-tab[,4]
fc<-tab[detag10,1]

## ----chunk-6, eval=FALSE----------------------------------------------------------------
#  degObj(counts,design,"degObj.rda")
#  library(shiny)
#  runGist(9930881)

## ----chunk-7----------------------------------------------------------------------------
degMean(pval,counts)
degVar(pval,counts)
degMV(humanSexDEedgeR$samples$group,pval,counts)
degMB(detags,g1,g2,counts)
degVB(detags,g1,g2,counts)
# require(rjags)
# rank<-degRank(g1,g2,counts[detag10,],fc,400,500)
# degPR(rank)

## ----deseq2-----------------------------------------------------------------------------
data(humanSexDEedgeR)
library(DESeq2)
idx <- c(1:10, 75:85)
dse <- DESeqDataSetFromMatrix(humanSexDEedgeR$counts[1:1000, idx], 
humanSexDEedgeR$samples[idx,], design=~group)
dse <- DESeq(dse)
res <- degResults(dds=dse, name="test", org=NULL, 
do_go=FALSE, group="group", xs="group", path_results = NULL)

## ----pattern----------------------------------------------------------------------------
data(humanSexDEedgeR)
ma <- humanSexDEedgeR$counts[1:100,]
des <- data.frame(row.names=colnames(ma), 
sex=as.factor(humanSexDEedgeR$samples$group))
res <- degPatterns(ma, des, time="sex", col=NULL)

