/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperTestBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public abstract class IDMapperCapabilitiesTest
extends IDMapperTestBase {
    protected static IDMapperCapabilities capabilities;

    @Test
    public void testDataSourceSupported() throws Exception {
        this.report("DataSourceSupported");
        Set<DataSource> dataSources = capabilities.getSupportedSrcDataSources();
        Assert.assertTrue((boolean)dataSources.contains(DataSource1));
        Assert.assertTrue((boolean)dataSources.contains(DataSource2));
        Assert.assertTrue((boolean)dataSources.contains(DataSource3));
        Assert.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testDataTargetSupported() throws Exception {
        this.report("DataTagerSupported");
        Set<DataSource> dataSources = capabilities.getSupportedTgtDataSources();
        DataSource expected = dataSources.iterator().next();
        Assert.assertTrue((boolean)dataSources.contains(DataSource1));
        Assert.assertTrue((boolean)dataSources.contains(DataSource2));
        Assert.assertTrue((boolean)dataSources.contains(DataSource3));
        Assert.assertFalse((boolean)dataSources.contains(DataSourceBad));
    }

    @Test
    public void testIsMappingSupported() throws IDMapperException {
        this.report("isMappingSupported");
        Assert.assertTrue((boolean)capabilities.isMappingSupported(DataSource1, DataSource2));
        Assert.assertFalse((boolean)capabilities.isMappingSupported(DataSource1, DataSourceBad));
    }

    @Test
    public void testGetKeys() throws IDMapperException {
        this.report("GetKeys");
        Assert.assertNotNull(capabilities.getKeys());
    }

    @Test
    public void testKeysHaveProperties() {
        this.report("KeysHaveProperties");
        for (String key : capabilities.getKeys()) {
            Assert.assertNotNull((Object)capabilities.getProperty(key));
        }
    }

    @Test
    public void testBadKeyNoProperties() {
        this.report("BadKeyNoProperties");
        Assert.assertNull((Object)capabilities.getProperty(badKey));
    }
}

