/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb;

import org.bridgedb.DataSource;
import org.junit.Assert;
import org.junit.Test;

public class DataSourceTest {
    @Test
    public void testAsDataSource() {
        DataSource source = DataSource.register("X", "Affymetrix").asDataSource();
        Assert.assertNotNull((Object)source);
    }

    @Test
    public void testBuilding() {
        DataSource source = DataSource.register("X", "Affymetrix").asDataSource();
        Assert.assertEquals((Object)"X", (Object)source.getSystemCode());
        Assert.assertEquals((Object)"Affymetrix", (Object)source.getFullName());
    }

    @Test
    public void testBuildingMainUrl() {
        DataSource source = DataSource.register("X", "Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
        Assert.assertEquals((Object)"http://www.affymetrix.com", (Object)source.getMainUrl());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testChangeMainUrl() {
        DataSource source = DataSource.register("X", "Affymetrix").mainUrl("http://www.affymetrix.com").asDataSource();
        source = DataSource.register("X", "Affymetrix").mainUrl("http://www.affymetrix.com/A").asDataSource();
    }

    @Test
    public void testBuildingType() {
        DataSource source = DataSource.register("X", "Affymetrix").type("probe").asDataSource();
        Assert.assertEquals((Object)"probe", (Object)source.getType());
        Assert.assertFalse((boolean)source.isMetabolite());
    }

    public void testBuildingType1() {
        DataSource source = DataSource.register("X", "Affymetrix").type("metabolite").asDataSource();
        Assert.assertEquals((Object)"metabolite", (Object)source.getType());
        Assert.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testBuildingPrimary() {
        DataSource source = DataSource.register("X", "Affymetrix").primary(false).asDataSource();
        Assert.assertFalse((boolean)source.isPrimary());
        source = DataSource.register("X", "Affymetrix").primary(true).asDataSource();
        Assert.assertTrue((boolean)source.isPrimary());
    }

    @Test
    public void testBuildingMetabolite() {
        DataSource source = DataSource.register("F", "MetaboLoci").type("metabolite").asDataSource();
        Assert.assertEquals((Object)"metabolite", (Object)source.getType());
        Assert.assertTrue((boolean)source.isMetabolite());
    }

    @Test
    public void testDeprecated() {
        DataSource source = DataSource.register("EnAg", "Ensembl Mosquito").deprecated(true).asDataSource();
        Assert.assertTrue((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecated_False() {
        DataSource source = DataSource.register("EnAg", "Ensembl Mosquito").deprecated(true).deprecated(false).asDataSource();
        Assert.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDefaultNotDeprecated() {
        DataSource source = DataSource.register("F", "MetaboLoci").asDataSource();
        Assert.assertFalse((boolean)source.isDeprecated());
    }

    @Test
    public void testDeprecatedBy() {
        DataSource source = DataSource.register("EnAg", "Ensembl Mosquito").deprecatedBy(DataSource.register("En", "Ensembl").asDataSource()).asDataSource();
        Assert.assertTrue((boolean)source.isDeprecated());
        Assert.assertNotNull((Object)source.isDeprecatedBy());
        Assert.assertEquals((Object)"En", (Object)source.isDeprecatedBy().getSystemCode());
    }

    @Test
    public void testDeprecatedByUndoneByDeprecatedFalse() {
        DataSource source = DataSource.register("EnAg", "Ensembl Mosquito").deprecatedBy(DataSource.register("En", "Ensembl").asDataSource()).deprecated(false).asDataSource();
        Assert.assertFalse((boolean)source.isDeprecated());
        Assert.assertNull((Object)source.isDeprecatedBy());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDeprecatedByNullCausesException() {
        DataSource.register("EnAg", "Ensembl Mosquito").deprecatedBy(null).asDataSource();
    }

    @Test
    public void testDefaultNoDeprecatedBy() {
        DataSource source = DataSource.register("Cps", "PubChem-substance").asDataSource();
        Assert.assertNull((Object)source.isDeprecatedBy());
    }

    @Test
    public void testEquals() {
        DataSource source = DataSource.register("Cps", "PubChem-substance").asDataSource();
        DataSource source2 = DataSource.register("Cps", "PubChem-substance").asDataSource();
        Assert.assertEquals((Object)source, (Object)source2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEqualsToo() {
        DataSource source = DataSource.register("Cpc", "PubChem-compound").asDataSource();
        DataSource source2 = DataSource.register("Cpc", "PubChem compound").asDataSource();
        Assert.assertEquals((Object)source, (Object)source2);
    }

    public void testChangeType() {
        DataSource source = DataSource.register("X", "Affymetrix").type("metabolite").asDataSource();
        Assert.assertEquals((Object)"metabolite", (Object)source.getType());
        Assert.assertTrue((boolean)source.isMetabolite());
        source = DataSource.register("X", "Affymetrix").type("probe").asDataSource();
        Assert.assertEquals((Object)"probe", (Object)source.getType());
        Assert.assertFalse((boolean)source.isMetabolite());
    }

    @Test
    public void testBuildingAlternative() {
        DataSource source = DataSource.register("F", "MetaboLoci").alternative("MetaboLoci Alternative").asDataSource();
        Assert.assertEquals((Object)"MetaboLoci Alternative", (Object)source.getAlternative());
    }

    @Test
    public void testBuildingDescription() {
        DataSource source = DataSource.register("F", "MetaboLoci").description("MetaboLoci description").asDataSource();
        Assert.assertEquals((Object)"MetaboLoci description", (Object)source.getDescription());
    }
}

