/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.bio;

import java.util.Set;
import org.bridgedb.DataSource;
import org.bridgedb.DataSourcePatterns;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.bio.Organism;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BioDataSourceTest {
    boolean eventReceived = false;

    @Before
    public void setUp() {
        BioDataSource.init();
    }

    @Test
    public void testInit() {
        for (DataSource ds : DataSource.getDataSources()) {
            Assert.assertNotNull((Object)ds);
            Assert.assertNotNull((Object)ds.getFullName());
            if ("blahblahblah".equals(ds.getFullName())) continue;
            Assert.assertNotNull((String)("Unexpected null system code for " + ds.getFullName()), (Object)ds.getSystemCode());
        }
    }

    @Test
    public void testURN() {
        Xref ref = new Xref("3643", BioDataSource.ENTREZ_GENE);
        Xref ref2 = new Xref("GO:00001", BioDataSource.GENE_ONTOLOGY);
        Assert.assertEquals((Object)"urn:miriam:ncbigene:3643", (Object)ref.getURN());
        Assert.assertEquals((Object)"urn:miriam:go:GO%3A00001", (Object)ref2.getURN());
    }

    @Test
    public void testSpeciesSpecificEnsembl() {
        Assert.assertEquals((Object)BioDataSource.ENSEMBL_COW, (Object)BioDataSource.getSpeciesSpecificEnsembl(Organism.BosTaurus));
        Assert.assertEquals((Object)BioDataSource.ENSEMBL_MOSQUITO, (Object)BioDataSource.getSpeciesSpecificEnsembl(Organism.AnophelesGambiae));
    }

    @Test
    public void testBioDataSources() {
        Assert.assertEquals((Object)((Object)Organism.CaenorhabditisElegans), (Object)BioDataSource.WORMBASE.getOrganism());
        Assert.assertEquals((Object)((Object)Organism.GallusGallus), (Object)BioDataSource.ENSEMBL_CHICKEN.getOrganism());
        Assert.assertEquals((Object)"metabolite", (Object)BioDataSource.CAS.getType());
    }

    @Test
    public void testNCBITaxonomy() {
        Assert.assertNotNull((Object)BioDataSource.TAXONOMY_NCBI.getFullName());
        Assert.assertNotNull((Object)BioDataSource.TAXONOMY_NCBI.getSystemCode());
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("9606").contains(BioDataSource.TAXONOMY_NCBI));
    }

    @Test
    public void testUniprotPatterns() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("Q8JH47").contains(BioDataSource.UNIPROT));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("F6X8M0").contains(BioDataSource.UNIPROT));
    }

    @Test
    public void testWikiPathwayPatterns() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("WP784").contains(BioDataSource.WIKIPATHWAYS));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("WP784_r48306").contains(BioDataSource.WIKIPATHWAYS));
    }

    @Test
    public void testPatterns() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("1.1.1.1").contains(BioDataSource.ENZYME_CODE));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("50-99-7").contains(BioDataSource.CAS));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("HMDB00122").contains(BioDataSource.HMDB));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("C00031").contains(BioDataSource.KEGG_COMPOUND));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("CHEBI:17925").contains(BioDataSource.CHEBI));
    }

    @Test
    public void testBadCASNumbers() {
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-99-77").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("1-99-77").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-1-7").contains(BioDataSource.CAS));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("50-333-7").contains(BioDataSource.CAS));
    }

    @Test
    public void testXMetDB_Regex() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("XMETDB175").contains(DataSource.getBySystemCode("Xm")));
    }

    @Test
    public void testXMetDB() {
        DataSource xmetdb = DataSource.getBySystemCode("Xm");
        Assert.assertNotNull((Object)xmetdb);
        Assert.assertEquals((Object)"XMetDB", (Object)xmetdb.getFullName());
    }

    @Test
    public void testUniprotIDs() {
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("P62158").contains(BioDataSource.UNIPROT));
        Assert.assertFalse((boolean)DataSourcePatterns.getDataSourceMatches("PA2158").contains(BioDataSource.UNIPROT));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("G4XXL9").contains(BioDataSource.UNIPROT));
        Assert.assertTrue((boolean)DataSourcePatterns.getDataSourceMatches("G4XXL9XXL9").contains(BioDataSource.UNIPROT));
    }

    @Test
    public void testDataSource() {
        DataSource ds = BioDataSource.ENSEMBL;
        Assert.assertEquals((Object)"Ensembl", (Object)ds.getFullName());
        Assert.assertEquals((Object)"En", (Object)ds.getSystemCode());
        DataSource ds4 = DataSource.getBySystemCode("En");
        Assert.assertEquals((Object)ds, (Object)ds4);
        DataSource ds5 = DataSource.getByFullName("Entrez Gene");
        Assert.assertEquals((Object)BioDataSource.ENTREZ_GENE, (Object)ds5);
    }

    @Test
    public void testDataSourceFilter() {
        Set<DataSource> f1 = DataSource.getFilteredSet(true, null, null);
        Assert.assertTrue((boolean)f1.contains(BioDataSource.ENSEMBL_HUMAN));
        Assert.assertTrue((boolean)f1.contains(BioDataSource.HMDB));
        Assert.assertFalse((boolean)f1.contains(BioDataSource.AFFY));
        Set<DataSource> f2 = DataSource.getFilteredSet(null, null, (Object)Organism.CaenorhabditisElegans);
        Assert.assertTrue((boolean)f2.contains(BioDataSource.ENSEMBL_CELEGANS));
        Assert.assertTrue((boolean)f2.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f2.contains(BioDataSource.ZFIN));
        Set<DataSource> f3 = DataSource.getFilteredSet(null, true, null);
        Assert.assertTrue((boolean)f3.contains(BioDataSource.HMDB));
        Assert.assertFalse((boolean)f3.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f3.contains(BioDataSource.ENSEMBL_HUMAN));
        Set<DataSource> f4 = DataSource.getFilteredSet(null, false, null);
        Assert.assertTrue((boolean)f4.contains(BioDataSource.ENSEMBL_HUMAN));
        Assert.assertTrue((boolean)f4.contains(BioDataSource.WORMBASE));
        Assert.assertFalse((boolean)f4.contains(BioDataSource.HMDB));
    }

    @Test
    public void testAlias() {
        DataSource ds = DataSource.getByAlias("ensembl_gene_id");
        Assert.assertSame((Object)BioDataSource.ENSEMBL, (Object)ds);
    }

    @Test
    public void testFromUrn() {
        Xref ref = Xref.fromUrn("urn:miriam:ncbigene:3643");
        Assert.assertEquals((Object)BioDataSource.ENTREZ_GENE, (Object)ref.getDataSource());
        Assert.assertEquals((Object)"3643", (Object)ref.getId());
        ref = Xref.fromUrn("urn:miriam:blahblahblah:abc");
        Assert.assertEquals((Object)DataSource.getByFullName("blahblahblah"), (Object)ref.getDataSource());
        ref = Xref.fromUrn("blahblahblha");
        Assert.assertNull((Object)ref);
        ref = Xref.fromUrn("urn:miriam:go:GO%3A00001234");
        Assert.assertEquals((Object)BioDataSource.GENE_ONTOLOGY, (Object)ref.getDataSource());
        Assert.assertEquals((Object)"GO:00001234", (Object)ref.getId());
    }
}

