/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bridgedb.impl.InternalUtils;

public class ConfigFile {
    private Map<String, List<String>> mappers = new HashMap<String, List<String>>();
    List<String> drivers = new ArrayList<String>();

    public ConfigFile(File f) throws IOException {
        System.out.println("Parsing gene database configuration: " + f.getAbsolutePath());
        this.parse(f);
    }

    private void parse(File f) throws IOException {
        String section = "MAIN";
        BufferedReader in = new BufferedReader(new FileReader(f));
        String line = in.readLine();
        while (line != null) {
            int pos = (line = line.trim()).indexOf(35);
            if (pos > -1) {
                line = line.substring(0, pos);
            }
            if (!line.equals("")) {
                if (line.matches("^\\[.*\\]\\s*$")) {
                    section = line.trim().substring(1, line.length() - 1);
                } else if (section.equalsIgnoreCase("MAIN")) {
                    String[] kv = line.split("\t");
                    if (kv.length == 2) {
                        String key = kv[0];
                        String value = kv[1];
                        if (!value.startsWith("idmapper")) {
                            value = "idmapper-pgdb:" + value;
                        }
                        InternalUtils.multiMapAdd(this.mappers, key, value);
                    } else {
                        System.out.println("Invalid key/value pair in gene database configuration: " + line);
                    }
                } else if (section.equalsIgnoreCase("drivers")) {
                    this.drivers.add(line);
                } else {
                    System.out.println("Warning: Unknown section [" + section + "]");
                }
            }
            line = in.readLine();
        }
        in.close();
    }

    public List<String> getDrivers() {
        return this.drivers;
    }

    public Map<String, List<String>> getMappers() {
        return this.mappers;
    }
}

