/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import buildsystem.Measure;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.AttributeMapper;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;

public class Test {
    private Measure measure;

    @Before
    public void setUp() {
        this.measure = new Measure("bridgedb_timing.txt");
    }

    @org.junit.Test
    @Ignore
    public void testDerbyClient() throws IDMapperException, ClassNotFoundException {
        long start = System.currentTimeMillis();
        Class.forName("org.bridgedb.rdb.IDMapperRdb");
        Class.forName("org.apache.derby.jdbc.ClientDriver");
        IDMapper mapper = BridgeDb.connect("idmapper-derbyclient:Homo sapiens?host=www.wikipathways.org");
        long end = System.currentTimeMillis();
        long delta = end - start;
        this.measure.add("timing::idmapper-derbyclient connect to two databases", "" + delta, "msec");
        for (String key : mapper.getCapabilities().getKeys()) {
            System.out.println(key + " -> " + mapper.getCapabilities().getProperty(key));
        }
        System.out.println(mapper.getCapabilities().getSupportedTgtDataSources());
        HashSet symbols = new HashSet();
        AttributeMapper attr = (AttributeMapper)((Object)mapper);
        for (String key : attr.getAttributeSet()) {
            System.out.println(key);
        }
        start = System.currentTimeMillis();
        Map<Xref, String> symbolMap = attr.freeAttributeSearch("p53", "symbol", 100);
        end = System.currentTimeMillis();
        delta = end - start;
        System.out.println(delta);
        this.measure.add("timing::idmapper-derbyclient free query for p53", "" + delta, "msec");
        System.out.println(symbols);
        start = System.currentTimeMillis();
        Xref insr = new Xref("ENSG00000171105", DataSource.getBySystemCode("EnHs"));
        for (String x : new String[]{"Description", "Symbol", "Chromosome"}) {
            Set<String> result = attr.getAttributes(insr, x);
            Assert.assertTrue((String)("No result for " + x), (result.size() > 0 ? 1 : 0) != 0);
            System.out.println(result);
        }
        end = System.currentTimeMillis();
        delta = end - start;
        this.measure.add("timing::idmapper-derbyclient query for backpage attributes", "" + delta, "msec");
        System.out.println(delta);
    }
}

