/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapperException;
import org.bridgedb.rdb.IDMapperRdb;

public abstract class SimpleGdb
extends IDMapperRdb {
    private final String connectionString;
    private boolean singleConnection = true;
    private boolean neverCloseConnection = true;
    private Connection con = null;
    protected final String dbName;
    public static final int NO_LIMIT = 0;
    public static final int NO_TIMEOUT = 0;
    public static final int QUERY_TIMEOUT = 5;

    SimpleGdb(String dbName, String connectionString) {
        this.connectionString = connectionString;
        this.dbName = dbName;
    }

    public synchronized Connection getConnection() throws SQLException {
        if (!this.singleConnection || this.con == null) {
            this.con = DriverManager.getConnection(this.connectionString);
            this.con.setReadOnly(true);
        }
        return this.con;
    }

    @Override
    public final boolean isConnected() {
        return true;
    }

    @Override
    public final String getDbName() {
        return this.dbName;
    }

    @Override
    public final void close() throws IDMapperException {
    }

    public final int getGeneCount() throws IDMapperException {
        int result = 0;
        try {
            ResultSet r = this.getConnection().createStatement().executeQuery("SELECT COUNT(*) FROM datanode");
            r.next();
            result = r.getInt(1);
            r.close();
        }
        catch (SQLException e) {
            throw new IDMapperException(e);
        }
        return result;
    }

    public final int getGeneCount(DataSource ds) throws IDMapperException {
        int result = 0;
        try {
            ResultSet r = this.getConnection().createStatement().executeQuery("SELECT COUNT(*) FROM datanode WHERE code = '" + ds.getSystemCode() + "'");
            r.next();
            result = r.getInt(1);
            r.close();
        }
        catch (SQLException e) {
            throw new IDMapperException(e);
        }
        return result;
    }

    final class QueryLifeCycle {
        private Connection con = null;
        private ResultSet rs = null;
        private PreparedStatement pst = null;
        private final String sql;
        private boolean inited = false;
        public static final int QUERY_TIMEOUT = 20;
        public static final int NO_LIMIT = 0;
        public static final int NO_TIMEOUT = 0;

        public QueryLifeCycle(String aSql) {
            this.sql = aSql;
        }

        public void init(int limit) throws SQLException {
            this.init();
            this.pst.setQueryTimeout(20);
            if (limit > 0) {
                this.pst.setMaxRows(limit);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void init() throws SQLException {
            if (this.inited) {
                throw new IllegalStateException("Must call cleanup() between two init() calls");
            }
            try {
                if (this.con == null) {
                    this.con = SimpleGdb.this.getConnection();
                }
                if (this.pst == null) {
                    this.pst = this.con.prepareStatement(this.sql);
                }
            }
            finally {
                this.inited = true;
            }
        }

        public void setString(int index, String val) throws SQLException {
            if (!this.inited) {
                throw new IllegalStateException("Must call init() before setString()");
            }
            this.pst.setString(index, val);
        }

        public ResultSet executeQuery() throws SQLException {
            if (!this.inited) {
                throw new IllegalStateException("Must call init() before executeQuery()");
            }
            this.rs = this.pst.executeQuery();
            return this.rs;
        }

        public void cleanup() {
            if (!this.inited) {
                throw new IllegalStateException("Must call init() before cleanup()");
            }
            this.inited = false;
            if (this.rs != null) {
                try {
                    this.rs.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            if (SimpleGdb.this.neverCloseConnection) {
                return;
            }
            if (this.pst != null) {
                try {
                    this.pst.close();
                }
                catch (SQLException ignore) {
                    // empty catch block
                }
            }
            this.pst = null;
            if (this.con != null) {
                try {
                    this.con.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            this.con = null;
        }
    }
}

