## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
sapply(c("sesame","sesameData","ExperimentHub"),
    function(x) as.character(packageVersion(x)))
with(R.Version(), paste0(major, ".", minor))

## ----message=FALSE------------------------------------------------------------
library(sesame)
sesameDataCache()

## -----------------------------------------------------------------------------
tools::R_user_dir("ExperimentHub", which="cache")

## ----base1, eval=FALSE--------------------------------------------------------
#  idat_dir = system.file("extdata/", package = "sesameData")
#  betas = openSesame(idat_dir, BPPARAM = BiocParallel::MulticoreParam(2))

## ----base2, eval=FALSE--------------------------------------------------------
#  ##  The above openSesame call is equivalent to:
#  betas = do.call(cbind, BiocParallel::bplapply(
#      searchIDATprefixes(idat_dir), function(pfx) {
#          getBetas(prepSesame(readIDATpair(pfx), "QCDPB"))
#  }, BPPARAM = BiocParallel::MulticoreParam(2)))
#  
#  ## or even more explicitly (if one needs to control argument passed
#  ## to a specific preprocessing function)
#  betas = do.call(cbind, BiocParallel::bplapply(
#      searchIDATprefixes(idat_dir), function(pfx) {
#          getBetas(noob(pOOBAH(dyeBiasNL(inferInfiniumIChannel(qualityMask(
#              readIDATpair(pfx)))))))
#  }, BPPARAM = BiocParallel::MulticoreParam(2)))

## ----base12, eval=FALSE-------------------------------------------------------
#  betas = openSesame(idat_dir, func = getBetas) # getBetas is the default
#  sdfs = openSesame(idat_dir, func = NULL) # return SigDF list
#  allele_freqs = openSesame(idat_dir, func = getAFs) # SNP allele frequencies
#  sdfs = openSesame(sdfs, prep = "Q", func = NULL)   # take and return SigDFs

## ----base9--------------------------------------------------------------------
sdf = sesameDataGet('EPIC.1.SigDF')
sdf_preped = openSesame(sdf, prep="DB", func=NULL)

## ----base10, echo=FALSE, result="asis"----------------------------------------
library(knitr)
df <- data.frame(rbind(
   c("EPIC/HM450", "human", "QCDPB"),
   c("EPIC/HM450", "non-human organism", "SQCDPB"),
   c("MM285", "mouse", "TQCDPB"),
   c("MM285", "non-mouse organism", "SQCDPB"),
   c("Mammal40", "human", "HCDPB"),
   c("Mammal40", "non-human organism", "SHCDPM")))
colnames(df) <- c("Platform", "Sample Organism", "Prep Code")
kable(df, caption="Recommended Preprocessing")

## ----base11-------------------------------------------------------------------
prepSesameList()

## -----------------------------------------------------------------------------
sessionInfo()

