## ----ky1, load-depenencies, results="hide", message=FALSE, warning=FALSE------
library(sesame)
sesameDataCache()

## ----ky2, message=FALSE-------------------------------------------------------
query <- KYCG_getDBs("MM285.designGroup")[["PGCMeth"]]
head(query)

## ----ky3, fig.width=8, fig.height=5, message=FALSE----------------------------
results_pgc <- testEnrichment(query)
head(results_pgc)

## ----ky4----------------------------------------------------------------------
KYCG_plotEnrichAll(results_pgc)

## ----ky9, echo = FALSE, results="asis"----------------------------------------
library(knitr)
df = data.frame(
    "Continuous DB"=c("Correlation-based","GSEA"),
    "Discrete DB"=c("GSEA","Fisher's Exact Test"))
rownames(df) = c("Continuous Query", "Discrete Query")
kable(df, caption="Four KnowYourCG Testing Scenarios")

## ----ky10, run-test-single, echo=TRUE, eval=TRUE, message=FALSE---------------
library(SummarizedExperiment)

## prepare a query
df <- rowData(sesameDataGet('MM285.tissueSignature'))
query <- df$Probe_ID[df$branch == "fetal_brain" & df$type == "Hypo"]

results <- testEnrichment(query, "TFBS")
results %>% dplyr::filter(overlap>10) %>% head

## prepare another query
query <- df$Probe_ID[df$branch == "fetal_liver" & df$type == "Hypo"]
results <- testEnrichment(query, "TFBS")
results %>% dplyr::filter(overlap>10) %>%
    dplyr::select(dbname, estimate, test, FDR) %>% head

## ----ky5, list-data, eval=TRUE, echo=TRUE-------------------------------------
KYCG_listDBGroups("MM285")

## ----ky6, cache-data, eval=TRUE, warning=FALSE--------------------------------
dbs <- KYCG_getDBs("MM285.design")

## ----ky7, view-data1, eval=TRUE, warning=FALSE--------------------------------
str(dbs[["PGCMeth"]])

## ----ky8, message=FALSE-------------------------------------------------------
df <- rowData(sesameDataGet('MM285.tissueSignature'))
query <- df$Probe_ID[df$branch == "B_cell"]
head(query)

## ----ky16, fig.width=7, fig.height=6, echo=TRUE, warning=FALSE, message=FALSE----
query <- names(sesameData_getProbesByGene("Dnmt3a", "MM285"))
results <- testEnrichment(query, KYCG_buildGeneDBs(query, max_distance=100000))
results[,c("dbname","estimate","gene_name","FDR", "nQ", "nD", "overlap")]

## ----ky17, fig.width=5, fig.height=4, echo=TRUE-------------------------------
KYCG_plotLollipop(results, label="gene_name")

## ----ky18, message=FALSE------------------------------------------------------
df <- rowData(sesameDataGet('MM285.tissueSignature'))
query <- df$Probe_ID[df$branch == "fetal_liver" & df$type == "Hypo"]
genes <- sesameData_getGenesByProbes(query)
genes

## ----ky19, eval = FALSE-------------------------------------------------------
#  library(gprofiler2)
#  
#  ## use gene name
#  gostres <- gost(genes$gene_name, organism = "mmusculus")
#  gostres$result[order(gostres$result$p_value),]
#  gostplot(gostres)
#  
#  ## use Ensembl gene ID, note we need to remove the version suffix
#  gene_ids <- sapply(strsplit(names(genes),"\\."), function(x) x[1])
#  gostres <- gost(gene_ids, organism = "mmusculus")
#  gostres$result[order(gostres$result$p_value),]
#  gostplot(gostres)

## ----ky21, run-test-data, echo=TRUE, eval=TRUE, message=FALSE-----------------
query <- KYCG_getDBs("KYCG.MM285.designGroup")[["TSS"]]

## ----ky22, echo=TRUE, eval=TRUE, message=FALSE--------------------------------
res <- testEnrichmentGSEA(query, "MM285.seqContextN")
res[, c("dbname", "test", "estimate", "FDR", "nQ", "nD", "overlap")]

## ----ky23, warning=FALSE, eval=FALSE------------------------------------------
#  beta_values <- getBetas(sesameDataGet("MM285.1.SigDF"))
#  res <- testEnrichmentGSEA(beta_values, "MM285.chromHMM")
#  res[, c("dbname", "test", "estimate", "FDR", "nQ", "nD", "overlap")]

## -----------------------------------------------------------------------------
sessionInfo()

