/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.fastq;

import htsjdk.samtools.Defaults;
import htsjdk.samtools.fastq.AsyncFastqWriter;
import htsjdk.samtools.fastq.BasicFastqWriter;
import htsjdk.samtools.fastq.FastqWriter;
import java.io.File;

public class FastqWriterFactory {
    boolean useAsyncIo = Defaults.USE_ASYNC_IO;
    boolean createMd5 = Defaults.CREATE_MD5;

    public void setUseAsyncIo(boolean useAsyncIo) {
        this.useAsyncIo = useAsyncIo;
    }

    public void setCreateMd5(boolean createMd5) {
        this.createMd5 = createMd5;
    }

    public FastqWriter newWriter(File out) {
        BasicFastqWriter writer = new BasicFastqWriter(out, this.createMd5);
        if (this.useAsyncIo) {
            return new AsyncFastqWriter(writer, 2000);
        }
        return writer;
    }
}

