## ----echo=FALSE---------------------------------------------------------------
knitr::opts_chunk$set( fig.path = "inst/figures/")

## ----echo=FALSE, message=FALSE, warning=FALSE---------------------------------
library(dplyr)
library(sccomp)
library(ggplot2)
library(forcats)
library(tidyr)
library(rstan)
data("seurat_obj")
data("sce_obj")
data("counts_obj")

## ----eval=FALSE---------------------------------------------------------------
#  if (!requireNamespace("BiocManager")) {
#     install.packages("BiocManager")
#   }
#   BiocManager::install("sccomp")

## ----eval=FALSE---------------------------------------------------------------
#  devtools::install_github("stemangiola/sccomp")

## ----eval=FALSE---------------------------------------------------------------
#  install.packages("cmdstanr", repos = c("https://mc-stan.org/r-packages/", getOption("repos")))
#  check_cmdstan_toolchain()
#  install_cmdstan(cores = 2)
#  # Then, check the correct cmdstanr installation here
#  # https://mc-stan.org/cmdstanr/articles/cmdstanr.html
#  
#  # Then install sccomp with the cmdstanr branch
#  devtools::install_github("stemangiola/sccomp@cmdstanr")

## ----eval=FALSE---------------------------------------------------------------
#  
#  res =
#    seurat_obj |>
#    sccomp_glm(
#     formula_composition = ~ type,
#      formula_variability = ~ 1,
#      sample,
#      cell_group
#    )
#  

## ----eval=FALSE---------------------------------------------------------------
#  res =
#    sce_obj |>
#    sccomp_glm(
#      formula_composition = ~ type,
#      formula_variability = ~ 1,
#      sample,
#      cell_group
#    )
#  

## ----eval=FALSE---------------------------------------------------------------
#  
#  res =
#    seurat_obj[[]] |>
#    sccomp_glm(
#      formula_composition = ~ type,
#      formula_variability = ~ 1,
#      sample,
#      cell_group
#    )
#  

## ----warning=FALSE------------------------------------------------------------

res =
  counts_obj |>
  sccomp_glm( 
    formula_composition = ~ type, 
    formula_variability = ~ 1, 
    .sample = sample,
    .cell_group = cell_group,
    .count = count
  )

res

## ---- out.height="200%"-------------------------------------------------------
plots = plot_summary(res) 



## -----------------------------------------------------------------------------
plots$boxplot


## -----------------------------------------------------------------------------
plots$credible_intervals_1D


## -----------------------------------------------------------------------------
res %>% attr("fit") %>% rstan::traceplot("beta[2,1]")

## ----warning=FALSE------------------------------------------------------------

res = 
  counts_obj |>
  sccomp_glm( 
    formula_composition = ~ type, 
    formula_variability = ~ type, 
    .sample = sample,
    .cell_group = cell_group,
    .count = count
  )

res

## -----------------------------------------------------------------------------
plots = plot_summary(res)

plots$credible_intervals_1D

## -----------------------------------------------------------------------------
plots$credible_intervals_2D

## -----------------------------------------------------------------------------
sessionInfo()

