/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.utils.orientation;

public class WordGenerator {
    public static final int WORD_SIZE = 8;
    public static final int MAX_NUM_WORD = 65536;
    public static final int MASK = 65535;
    private static final int MAX_ASCII = 128;
    private String seqString;
    private int nextWord = 0;
    private int baseCount = 1;
    private int position = 0;
    private boolean invalid = false;
    private static int[] charLookup = new int[128];

    public WordGenerator(String seq) {
        this.seqString = seq;
    }

    public boolean hasNext() {
        int charIndex = 0;
        --this.baseCount;
        while (this.baseCount < 8 && this.position < this.seqString.length()) {
            char nextBase;
            if ((charIndex = charLookup[nextBase = this.seqString.charAt(this.position++)]) == -1) {
                this.baseCount = -1;
                charIndex = 0;
            }
            ++this.baseCount;
            this.nextWord <<= 2;
            this.nextWord &= 0xFFFF;
            this.nextWord |= charIndex;
        }
        if (this.baseCount < 8) {
            this.invalid = true;
            return false;
        }
        return true;
    }

    public int next() {
        if (this.invalid) {
            throw new IllegalStateException("Attempt to call WordGenerator.next() when no more words.");
        }
        return this.nextWord;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            WordGenerator.charLookup[i] = -1;
        }
        WordGenerator.charLookup[65] = 0;
        WordGenerator.charLookup[84] = 1;
        WordGenerator.charLookup[85] = 1;
        WordGenerator.charLookup[71] = 2;
        WordGenerator.charLookup[67] = 3;
        WordGenerator.charLookup[97] = 0;
        WordGenerator.charLookup[116] = 1;
        WordGenerator.charLookup[117] = 1;
        WordGenerator.charLookup[103] = 2;
        WordGenerator.charLookup[99] = 3;
    }
}

