## ----setup, include=FALSE---------------------------------------------------------------------------------------------
options(width=120)
knitr::opts_chunk$set(
    echo=TRUE
)

## ---- eval=FALSE------------------------------------------------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("pgca")

## ---------------------------------------------------------------------------------------------------------------------
library(pgca)

## ---------------------------------------------------------------------------------------------------------------------
head(BET2007_v339)

## ---------------------------------------------------------------------------------------------------------------------
subset(BET2007_v339, N %in% N[Gene_Symbol == 'PRSS2'])

## ---------------------------------------------------------------------------------------------------------------------
subset(BET2047_v339, N %in% N[Gene_Symbol == 'PRSS2'])

## ---------------------------------------------------------------------------------------------------------------------
dict <- pgcaDict(
    BET2007_v339,
    BET2047_v339,
    col.mapping=c(gene.symbol="Gene_Symbol")
)

## ---------------------------------------------------------------------------------------------------------------------
dict

## ---------------------------------------------------------------------------------------------------------------------
subset(dict$dictionary, pg %in% pg[gene == 'PRSS2'])

## ---------------------------------------------------------------------------------------------------------------------
translated <- applyDict(BET2007_v339, BET2047_v339, dict=dict)

## ---------------------------------------------------------------------------------------------------------------------
subset(translated$BET2007_v339, Gene_Symbol == "PRSS2")
subset(translated$BET2047_v339, Gene_Symbol == "PRSS2")

## ---------------------------------------------------------------------------------------------------------------------
dict.from.files <- pgcaDict(
    system.file("extdata", "BET1947_v339.txt", package="pgca"),
    system.file("extdata", "BET2007_v339.txt", package="pgca"),
    system.file("extdata", "BET2047_v339.txt", package="pgca"),
    system.file("extdata", "BET2067_v339.txt", package="pgca"),
    col.mapping=c(gene.symbol="Gene_Symbol")
)

dict.from.files

## ---------------------------------------------------------------------------------------------------------------------
dict.from.dir <- pgcaDict(
    system.file("extdata", package="pgca"),
    col.mapping=c(gene.symbol="Gene_Symbol")
)
dict.from.dir

## ---------------------------------------------------------------------------------------------------------------------
subset(dict.from.dir$dictionary, pg %in% pg[gene == "PRSS2"])

## ---------------------------------------------------------------------------------------------------------------------
translated2 <- applyDict(BET1947_v339, BET2007_v339, BET2047_v339, BET2067_v339,
                         dict=dict.from.dir)

## ---------------------------------------------------------------------------------------------------------------------
subset(translated2$BET1947_v339, Gene_Symbol == 'PRSS2')
subset(translated2$BET2007_v339, Gene_Symbol == 'PRSS2')

## ---------------------------------------------------------------------------------------------------------------------
dictOutFile <- tempfile()
saveDict(dict.from.dir, file=dictOutFile)

## ---- echo=FALSE, results='asis'--------------------------------------------------------------------------------------
cat('<span id="ref-1" style="margin-left: -2em; float: left;">[1]</span>')
print(readCitationFile("../inst/CITATION"), style = "text")


