## ---- echo=FALSE--------------------------------------------------------------
knitr::opts_chunk$set(cache = FALSE,
                        fig.width = 9,
                        message = FALSE,
                        warning = FALSE)

## ----install-bioc,eval=FALSE--------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  

## ----eval=FALSE, include=FALSE------------------------------------------------
#  library(miaSim)
#  A_normal <- powerlawA(n_species = 4, alpha = 3)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  A_uniform <- randomA(n_species = 10, d = -0.4, min_strength = -0.8,
#                          max_strength = 0.8, connectance = 0.5)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  
#  A_normal <- powerlawA(n_species = 4, alpha = 3)
#  
#  ExampleGLV <- simulateGLV(n_species = 4, A_normal, t_start = 0,
#      t_store = 1000, stochastic = FALSE, norm = FALSE)
#  
#  ExampleRicker <- simulateRicker(n_species=4, A_normal, tend=100, norm = FALSE)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  Time <- simulationTimes(t_start = 0, t_end = 100, t_step = 0.5,
#                             t_store = 100)
#  Time$t.index

## ----eval=FALSE, include=FALSE------------------------------------------------
#  ExampleHubbell <- simulateHubbell(n_species = 8, M = 10, I = 1000, d = 50,
#                                      m = 0.02, tend = 100)
#  
#  ExampleHubbellRates <- simulateHubbellRates(community_initial = c(0,5,10),
#      migration_p = 0.1, metacommunity_p = NULL, k_events = 1,
#      growth_rates = NULL, norm = FALSE, t_end=1000)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  ExampleSOI <- simulateSOI(n_species = 4, I = 1000, A_normal, k=5, com = NULL,
#                                              tend = 150, norm = TRUE)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  ExampleLogistic <- simulateStochasticLogistic(n_species = 5)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  ExampleConsumerResource <- simulateConsumerResource(n_species = 2,
#      n_resources = 4, eff = randomE(n_species = 2, n_resources = 4))
#  
#  # visualize the dynamics of the model
#  Consumer_plot <- matplot(ExampleConsumerResource, type = "l")

## ----eval=FALSE, include=FALSE------------------------------------------------
#  ExampleHubbellRates <- simulateHubbellRates(community_initial = c(0,5,10),
#      migration_p = 0.1, metacommunity_p = NULL, k_events = 1,
#      growth_rates = NULL, norm = FALSE, t_end=1000)
#  
#  HubbellSE <- convertToSE(matrix = ExampleHubbellRates$counts,
#                          colData = ExampleHubbellRates$time,
#                          metadata = ExampleHubbellRates$metadata)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  library(TreeSummarizedExperiment)
#  help("TreeSummarizedExperiment-constructor", package = TreeSummarizedExperiment)

## ----eval=FALSE, include=FALSE------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("miaViz")

## ----eval=FALSE, include=FALSE------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("mia")

## ----eval=FALSE, include=FALSE------------------------------------------------
#  library(miaViz)
#  
#  HubbellDensityPlot <- plotAbundanceDensity(HubbellSE, abund_values = "counts")

## ----eval=FALSE, include=FALSE------------------------------------------------
#  A_normal <- powerlawA(n_species = 4, alpha = 3)
#  
#  ExampleGLV <- simulateGLV(n_species = 4, A_normal, t_start = 0,
#      t_store = 1000, stochastic = FALSE, norm = FALSE)
#  
#  rownames(ExampleGLV) <- c(paste("Species", rownames(ExampleGLV), sep = "_"))
#  colnames(ExampleGLV) <- c(paste("Sample", seq_len(ncol(ExampleGLV)), sep = "_"))
#  
#  df <- DataFrame(sampleID = colnames(ExampleGLV),
#              Time = seq(1, 1000, 1),
#              SubjectID = rep(1:4, 250),
#              row.names = colnames(ExampleGLV))
#  
#  SE_GLV <- convertToSE(matrix = ExampleGLV,
#                        colData = df)

## -----------------------------------------------------------------------------
sessionInfo()

