/*
 * Decompiled with CFR 0.152.
 */
package ciat.agrobio.io;

import ciat.agrobio.io.FastaFileDecoderInterface;
import java.nio.ByteBuffer;

public class FastaDecoder
implements FastaFileDecoderInterface<byte[]> {
    private static final byte LF = 10;

    @Override
    public byte[] decode(ByteBuffer buffer) {
        int lineStartPos = buffer.position();
        int limit = buffer.limit();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b != 10) continue;
            int lineEndPos = buffer.position();
            if (buffer.limit() < lineEndPos + 1) {
                buffer.position(lineStartPos).limit(lineEndPos);
            } else {
                buffer.position(lineStartPos).limit(lineEndPos + 1);
            }
            byte[] line = this.parseBytes(buffer, lineEndPos - lineStartPos - 1);
            if (line != null) {
                buffer.position(lineEndPos);
                buffer.limit(limit);
                lineStartPos = lineEndPos;
            }
            if (line.length == 0) continue;
            return line;
        }
        buffer.position(lineStartPos);
        return null;
    }

    private byte[] parseBytes(ByteBuffer buffer, int length) {
        byte[] bytes = new byte[length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = buffer.get();
        }
        return bytes;
    }
}

