/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ObjectOp;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObject<T> {
    private AtomicReference<T> myValue;

    public SharedObject() {
        this.myValue = new AtomicReference();
    }

    public SharedObject(T t) {
        this.myValue = new AtomicReference<T>(t);
    }

    public T get() {
        return this.myValue.get();
    }

    public void set(T t) {
        this.myValue.set(t);
    }

    public T getAndSet(T t) {
        return this.myValue.getAndSet(t);
    }

    public boolean compareAndSet(T t, T t2) {
        return this.myValue.compareAndSet(t, t2);
    }

    public boolean weakCompareAndSet(T t, T t2) {
        return this.myValue.weakCompareAndSet(t, t2);
    }

    public T reduce(T t, ObjectOp<T> objectOp) {
        T t2;
        T t3;
        while (!this.myValue.compareAndSet(t3 = this.myValue.get(), t2 = objectOp.op(t3, t))) {
        }
        return t2;
    }

    public String toString() {
        return this.myValue.toString();
    }
}

