/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri.test;

import edu.rit.mri.SpinSignalDifference;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.NonLinearLeastSquares;
import edu.rit.numeric.plot.Dots;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.Strokes;
import java.awt.Color;
import java.io.File;
import java.util.Scanner;

public class Test01 {
    private Test01() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length < 3 || stringArray.length % 2 != 1) {
            Test01.usage();
        }
        File file = new File(stringArray[0]);
        int n2 = (stringArray.length - 1) / 2;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = Double.parseDouble(stringArray[2 * i + 1]);
            dArray2[i] = Double.parseDouble(stringArray[2 * i + 2]);
        }
        ListXYSeries listXYSeries = new ListXYSeries();
        listXYSeries.add(new Scanner(file));
        SpinSignalDifference spinSignalDifference = new SpinSignalDifference(listXYSeries, n2);
        NonLinearLeastSquares nonLinearLeastSquares = new NonLinearLeastSquares(spinSignalDifference){

            protected void subclassDebug(int n) {
                System.out.println("Iteration " + n);
                for (int i = 0; i < this.N; ++i) {
                    System.out.println("\tx[" + i + "] = " + this.x[i]);
                }
                System.out.println("\tinfo = " + this.info);
            }
        };
        for (n = 0; n < n2; ++n) {
            nonLinearLeastSquares.x[n << 1] = dArray[n];
            nonLinearLeastSquares.x[(n << 1) + 1] = dArray2[n];
        }
        nonLinearLeastSquares.nprint = 1;
        nonLinearLeastSquares.solve();
        for (n = 0; n < n2; ++n) {
            dArray[n] = nonLinearLeastSquares.x[n << 1];
            dArray2[n] = nonLinearLeastSquares.x[(n << 1) + 1];
        }
        Plot plot = new Plot();
        plot.xAxisLength(1200.0).xAxisMajorDivisions(20).yAxisLength(600.0).yAxisMajorDivisions(10).seriesDots(Dots.circle(Color.BLACK, null, null, 5.0)).seriesColor(Color.BLACK).seriesStroke(Strokes.solid(2.0)).xySeries(listXYSeries);
        double d = 0.0;
        ListXYSeries listXYSeries2 = new ListXYSeries();
        for (int i = 0; i < listXYSeries.length(); ++i) {
            double d2 = listXYSeries.x(i);
            double d3 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d3 += dArray[j] * (1.0 - 2.0 * Math.exp(-dArray2[j] * d2));
            }
            double d4 = d3 - listXYSeries.y(i);
            d += d4 * d4;
            listXYSeries2.add(d2, d3);
        }
        System.out.println("chi^2 = " + d);
        plot.seriesDots(null).seriesColor(Color.RED).seriesStroke(Strokes.solid(1.0)).xySeries(listXYSeries2);
        plot.getFrame().setVisible(true);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.mri.test.Test01 <datafile> <rho1> <x1> ...");
        System.err.println("<datafile> = File containing t and S(t) values");
        System.err.println("<rho1> = Spin density");
        System.err.println("<x1> = Spin relaxation rate");
        System.exit(1);
    }
}

