/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Arrow;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.OutlinedItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;

public class Line
extends OutlinedItem
implements Externalizable {
    public static final Arrow NORMAL_START_ARROW = Arrow.NONE;
    public static final Arrow NORMAL_END_ARROW = Arrow.NONE;
    public static final double NORMAL_ROUND = 0.0;
    private static final long serialVersionUID = -4094248146984537516L;
    LinkedList<Point> myPoints = new LinkedList();
    Arrow myStartArrow = theDefaultStartArrow;
    Arrow myEndArrow = theDefaultEndArrow;
    double myRound = theDefaultRound;
    static Arrow theDefaultStartArrow = NORMAL_START_ARROW;
    static Arrow theDefaultEndArrow = NORMAL_END_ARROW;
    static double theDefaultRound = 0.0;
    Point myLastPoint;
    Point myNw;
    Point mySe;
    Size mySize;

    public Line() {
    }

    public Line(Line line) {
        super(line);
        this.myPoints.clear();
        this.myPoints.addAll(line.myPoints);
        this.myStartArrow = line.myStartArrow;
        this.myEndArrow = line.myEndArrow;
        this.myRound = line.myRound;
        if (!this.myPoints.isEmpty()) {
            this.myLastPoint = this.myPoints.get(this.myPoints.size() - 1);
        }
    }

    public static Arrow defaultStartArrow() {
        return theDefaultStartArrow;
    }

    public static void defaultStartArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        theDefaultStartArrow = arrow;
    }

    public static Arrow defaultEndArrow() {
        return theDefaultEndArrow;
    }

    public static void defaultEndArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        theDefaultEndArrow = arrow;
    }

    public static double defaultRound() {
        return theDefaultRound;
    }

    public static void defaultRound(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        theDefaultRound = d;
    }

    public Size size() {
        this.computeBoundingBox();
        return this.mySize;
    }

    public double width() {
        this.computeBoundingBox();
        return this.mySize.width;
    }

    public double height() {
        this.computeBoundingBox();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeBoundingBox();
        return this.myNw;
    }

    public Line outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Line clear() {
        this.myPoints.clear();
        this.myLastPoint = null;
        this.myNw = null;
        return this;
    }

    public Line to(double d, double d2) {
        return this.addEndpoint(new Point(d, d2));
    }

    public Line to(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        return this.addEndpoint(point);
    }

    public Line hto(double d) {
        return this.addEndpoint(new Point(d, this.myLastPoint.y));
    }

    public Line hto(Point point) {
        return this.addEndpoint(new Point(point.x, this.myLastPoint.y));
    }

    public Line vto(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x, d));
    }

    public Line vto(Point point) {
        return this.addEndpoint(new Point(this.myLastPoint.x, point.y));
    }

    public Line by(double d, double d2) {
        return this.addEndpoint(new Point(this.myLastPoint.x + d, this.myLastPoint.y + d2));
    }

    public Line by(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x + size.width, this.myLastPoint.y + size.height));
    }

    public Line hby(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x + d, this.myLastPoint.y));
    }

    public Line hby(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x + size.width, this.myLastPoint.y));
    }

    public Line vby(double d) {
        return this.addEndpoint(new Point(this.myLastPoint.x, this.myLastPoint.y + d));
    }

    public Line vby(Size size) {
        return this.addEndpoint(new Point(this.myLastPoint.x, this.myLastPoint.y + size.height));
    }

    public Arrow startArrow() {
        return this.myStartArrow;
    }

    public Line startArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        this.myStartArrow = arrow;
        return this;
    }

    public Arrow endArrow() {
        return this.myEndArrow;
    }

    public Line endArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        this.myEndArrow = arrow;
        return this;
    }

    public double round() {
        return this.myRound;
    }

    public Line round(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myRound = d;
        return this;
    }

    public Line add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Line add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Line addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Line addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(this.myPoints.size());
        for (Point point : this.myPoints) {
            objectOutput.writeObject(point);
        }
        objectOutput.writeObject(this.myStartArrow);
        objectOutput.writeObject(this.myEndArrow);
        objectOutput.writeDouble(this.myRound);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.myPoints.clear();
        for (int i = 0; i < n; ++i) {
            this.myPoints.add((Point)objectInput.readObject());
        }
        this.myStartArrow = (Arrow)objectInput.readObject();
        this.myEndArrow = (Arrow)objectInput.readObject();
        this.myRound = objectInput.readDouble();
        if (!this.myPoints.isEmpty()) {
            this.myLastPoint = this.myPoints.get(this.myPoints.size() - 1);
        }
        this.myNw = null;
        this.mySe = null;
        this.mySize = null;
    }

    public void draw(Graphics2D graphics2D) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        Point point;
        Point point2;
        super.draw(graphics2D);
        GeneralPath generalPath = this.computePath();
        this.myOutline.setGraphicsContext(graphics2D);
        graphics2D.draw(generalPath);
        int n = this.myPoints.size();
        if (n < 2) {
            return;
        }
        if (this.myStartArrow == null && this.myEndArrow == null) {
            return;
        }
        float f = this.myOutline.getStrokeWidth();
        graphics2D.setStroke(new BasicStroke(f));
        if (this.myStartArrow != null) {
            point2 = this.myPoints.get(0);
            point = this.myPoints.get(1);
            d5 = point2.x;
            d4 = point2.y;
            d3 = d5 - point.x;
            d2 = d4 - point.y;
            d = d3 == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d2, d3);
            this.myStartArrow.draw(graphics2D, f, d5, d4, d);
        }
        if (this.myEndArrow != null) {
            point2 = this.myPoints.get(n - 1);
            point = this.myPoints.get(n - 2);
            d5 = point2.x;
            d4 = point2.y;
            d3 = d5 - point.x;
            d2 = d4 - point.y;
            d = d3 == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d2, d3);
            this.myEndArrow.draw(graphics2D, f, d5, d4, d);
        }
    }

    private Line addEndpoint(Point point) {
        this.myLastPoint = point;
        this.myPoints.add(point);
        this.myNw = null;
        return this;
    }

    private void computeBoundingBox() {
        if (this.myNw == null) {
            this.myNw = new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.mySe = new Point(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            for (Point point : this.myPoints) {
                this.myNw = this.myNw.min(point);
                this.mySe = this.mySe.max(point);
            }
            this.mySize = this.mySe.difference(this.myNw);
        }
    }

    private GeneralPath computePath() {
        GeneralPath generalPath = new GeneralPath();
        int n = this.myPoints.size();
        Iterator iterator = this.myPoints.iterator();
        Point point = null;
        if (n != 0) {
            if (n == 1) {
                point = (Point)iterator.next();
                generalPath.moveTo((float)point.x, (float)point.y);
            } else if (n == 2) {
                point = (Point)iterator.next();
                generalPath.moveTo((float)point.x, (float)point.y);
                point = (Point)iterator.next();
                generalPath.lineTo((float)point.x, (float)point.y);
            } else if (this.myRound == 0.0) {
                point = (Point)iterator.next();
                generalPath.moveTo((float)point.x, (float)point.y);
                while (iterator.hasNext()) {
                    point = (Point)iterator.next();
                    generalPath.lineTo((float)point.x, (float)point.y);
                }
            } else {
                point = (Point)iterator.next();
                generalPath.moveTo((float)point.x, (float)point.y);
                double d = point.x;
                double d2 = point.y;
                double d3 = d;
                double d4 = d2;
                point = (Point)iterator.next();
                double d5 = point.x;
                double d6 = point.y;
                double d7 = 1.0;
                double d8 = 0.5;
                while (iterator.hasNext()) {
                    point = (Point)iterator.next();
                    double d9 = point.x;
                    double d10 = point.y;
                    if (!iterator.hasNext()) {
                        d8 = 1.0;
                    }
                    double d11 = d5 - d;
                    double d12 = d6 - d2;
                    double d13 = Math.sqrt(d11 * d11 + d12 * d12);
                    double d14 = Math.min(this.myRound / d13, d7);
                    double d15 = 1.0 - d14;
                    double d16 = d14 * d + d15 * d5;
                    double d17 = d14 * d2 + d15 * d6;
                    d11 = d5 - d9;
                    d12 = d6 - d10;
                    d13 = Math.sqrt(d11 * d11 + d12 * d12);
                    d14 = Math.min(this.myRound / d13, d8);
                    d15 = 1.0 - d14;
                    double d18 = d14 * d9 + d15 * d5;
                    double d19 = d14 * d10 + d15 * d6;
                    d14 = 0.4477152501692067;
                    d15 = 0.5522847498307933;
                    double d20 = d14 * d16 + d15 * d5;
                    double d21 = d14 * d17 + d15 * d6;
                    double d22 = d14 * d18 + d15 * d5;
                    double d23 = d14 * d19 + d15 * d6;
                    if (d3 != d16 || d4 != d17) {
                        generalPath.lineTo((float)d16, (float)d17);
                    }
                    generalPath.curveTo((float)d20, (float)d21, (float)d22, (float)d23, (float)d18, (float)d19);
                    d3 = d18;
                    d4 = d19;
                    d = d5;
                    d2 = d6;
                    d5 = d9;
                    d6 = d10;
                    d7 = 0.5;
                }
                if (d3 != d5 || d4 != d6) {
                    generalPath.lineTo((float)d5, (float)d6);
                }
            }
        }
        return generalPath;
    }
}

