/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.Distance;
import edu.rit.compbio.phyl.DnaSequence;
import edu.rit.compbio.phyl.DnaSequenceList;
import edu.rit.compbio.phyl.DnaSequenceTree;
import edu.rit.compbio.phyl.FitchParsimony;
import edu.rit.compbio.phyl.HammingDistance;
import edu.rit.compbio.phyl.JukesCantorDistance;
import edu.rit.compbio.phyl.LeastSquaresBranchLengths;
import edu.rit.compbio.phyl.MaximumParsimonyResults;
import edu.rit.compbio.phyl.TreeDrawing;
import edu.rit.draw.Drawing;
import edu.rit.swing.Displayable;
import edu.rit.swing.DisplayableIO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Date;
import java.util.Formatter;

public class Results {
    private Results() {
    }

    public static void report(File file, String string, String string2, int n, File file2, DnaSequenceList dnaSequenceList, DnaSequenceList dnaSequenceList2, int n2, int n3, MaximumParsimonyResults maximumParsimonyResults, long l, long l2, long l3) throws IOException {
        Object object;
        if (!file.exists()) {
            file.mkdirs();
        }
        File file3 = new File(file, "index.html");
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file3)));
        printStream.println("<HTML>");
        printStream.println("<HEAD>");
        printStream.print("<TITLE>Maximum Parsimony Phylogenetic Tree Search Results -- ");
        printStream.print(file2);
        printStream.println("</TITLE>");
        printStream.println("<STYLE TYPE=\"text/css\">");
        printStream.println("<!--");
        printStream.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printStream.println("body {font-size: small;}");
        printStream.println("h1 {font-size: 140%; font-weight: bold;}");
        printStream.println("h2 {font-size: 120%; font-weight: bold;}");
        printStream.println("h3 {font-size: 100%; font-weight: bold;}");
        printStream.println("table {font-size: 100%;}");
        printStream.println("tt {font-family: Courier, Monospace; font-size: 100%;}");
        printStream.println("tt b {font-family: Courier, Monospace; font-size: 100%; font-weight: normal; background: #e8e8e8;}");
        printStream.println("pre {font-family: Courier, Monospace; font-size: 100%;}");
        printStream.println("pre b {font-family: Courier, Monospace; font-size: 100%; font-weight: normal; background: #e8e8e8;}");
        printStream.println("-->");
        printStream.println("</STYLE>");
        printStream.println("</HEAD>");
        printStream.println("<BODY>");
        printStream.println("<H1>Maximum Parsimony Phylogenetic Tree Search Results</H1>");
        printStream.println("<P><HR/><H2>Summary</H2></P>");
        printStream.println("<P>");
        printStream.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Date/time:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(new Date(l3));
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Program:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(string);
        printStream.println("</TD>");
        printStream.println("</TR>");
        if (string2 != null) {
            printStream.println("<TR>");
            printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Computer:&nbsp;&nbsp;</TD>");
            printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
            printStream.print(string2.replaceAll("<", "&lt;").replaceAll(">", "&gt;"));
            printStream.println("</TD>");
            printStream.println("</TR>");
        }
        if (n > 0) {
            printStream.println("<TR>");
            printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Parallel threads:&nbsp;&nbsp;</TD>");
            printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
            printStream.print(n);
            printStream.println("</TD>");
            printStream.println("</TR>");
        }
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Sequence file:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(file2);
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Number of sequences:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(dnaSequenceList.length());
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Number of sites:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(dnaSequenceList.seq(0).length());
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Number of informative sites:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(dnaSequenceList.informativeSiteCount());
        printStream.println("</TD>");
        printStream.println("</TR>");
        if (n2 >= 0) {
            printStream.println("<TR>");
            printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Parsimony score initial bound:&nbsp;&nbsp;</TD>");
            printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
            printStream.print(n2);
            printStream.println("</TD>");
            printStream.println("</TR>");
        }
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Maximum trees saved:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(n3);
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Number of trees:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(maximumParsimonyResults.size());
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">Number of state changes:&nbsp;&nbsp;</TD>");
        printStream.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.print(maximumParsimonyResults.score());
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("</TABLE>");
        printStream.println("</P>");
        printStream.println("<P>");
        printStream.println("<A HREF=\"#sequences\">Sequences</A>");
        printStream.println("<BR/><A HREF=\"#distances\">Distances</A>");
        printStream.println("<BR/><A HREF=\"#trees\">Trees</A>");
        printStream.println("</P>");
        dnaSequenceList.write(new File(file, "sequences.phy"), 70, true, false);
        printStream.println("<P><HR/><A NAME=\"sequences\"><H2>Sequences</H2></A></P>");
        printStream.println("<P>Sequences in interleaved PHYLIP format:&nbsp;&nbsp;<A HREF=\"sequences.phy\">sequences.phy</A></P>");
        printStream.println("<P>");
        printStream.println("Notes:");
        printStream.print("<BR/>&diams;&nbsp;&nbsp;Number of sequences: ");
        printStream.println(dnaSequenceList.length());
        printStream.print("<BR/>&diams;&nbsp;&nbsp;Number of sites: ");
        printStream.println(dnaSequenceList.seq(0).length());
        printStream.print("<BR/>&diams;&nbsp;&nbsp;Number of informative sites: ");
        printStream.println(dnaSequenceList.informativeSiteCount());
        printStream.println("<BR/>&diams;&nbsp;&nbsp;Informative sites <TT><B>marked</B></TT>");
        printStream.println("</P>");
        printStream.println("<PRE>");
        dnaSequenceList.write(printStream, 70, true, true);
        printStream.println("</PRE>");
        printStream.println("<P><HR/><A NAME=\"distances\"><H2>Distances</H2></A></P>");
        HammingDistance hammingDistance = new HammingDistance();
        Results.printDistanceMatrix(printStream, "Hamming distances:", "%.0f", dnaSequenceList, hammingDistance);
        JukesCantorDistance jukesCantorDistance = new JukesCantorDistance();
        Results.printDistanceMatrix(printStream, "Jukes-Cantor distances:", "%.2f", dnaSequenceList, jukesCantorDistance);
        printStream.println("<P><HR/><A NAME=\"trees\"><H2>Trees</H2></A></P>");
        printStream.println("<P>Trees in Newick Standard format:&nbsp;&nbsp;<A HREF=\"trees.txt\">trees.txt</A></P>");
        printStream.println("<P>");
        printStream.println("Notes:");
        printStream.println("<BR/>&diams;&nbsp;&nbsp;These are unrooted trees");
        printStream.println("<BR/>&diams;&nbsp;&nbsp;Each interior node marked with number of state changes at that node");
        printStream.println("<BR/>&diams;&nbsp;&nbsp;Each branch marked with least squares branch length, Jukes-Cantor distances");
        printStream.print("<BR/>&diams;&nbsp;&nbsp;Number of trees: ");
        printStream.print(maximumParsimonyResults.size());
        printStream.print("<BR/>&diams;&nbsp;&nbsp;Total number of state changes: ");
        printStream.print(maximumParsimonyResults.score());
        printStream.println("</P>");
        int n4 = maximumParsimonyResults.size();
        Object[] objectArray = new TreeInfo[n4];
        for (int i = 0; i < n4; ++i) {
            object = dnaSequenceList2.toTree(maximumParsimonyResults.tree(i));
            FitchParsimony.computeScore((DnaSequenceTree)object);
            double d = LeastSquaresBranchLengths.solve((DnaSequenceTree)object, jukesCantorDistance);
            double d2 = Results.averageRootHeight((DnaSequenceTree)object);
            objectArray[i] = new TreeInfo((DnaSequenceTree)object, d, d2);
        }
        Arrays.sort(objectArray);
        PrintStream printStream2 = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(file, "trees.txt"))));
        object = Drawing.defaultDrawing();
        TreeDrawing treeDrawing = new TreeDrawing();
        for (int i = 0; i < n4; ++i) {
            DnaSequenceTree dnaSequenceTree = ((TreeInfo)objectArray[i]).tree;
            double d = ((TreeInfo)objectArray[i]).sqrerr;
            double d3 = ((TreeInfo)objectArray[i]).avgheight;
            printStream.print("<P><H3>Tree ");
            printStream.print(i + 1);
            printStream.print(" of ");
            printStream.print(n4);
            printStream.print("</H3></P>");
            printStream.println("<PRE>");
            printStream.println(dnaSequenceTree);
            printStream.println("</PRE>");
            printStream2.println(dnaSequenceTree);
            ((Drawing)object).clear();
            treeDrawing.draw(dnaSequenceTree);
            StringBuilder stringBuilder = new StringBuilder();
            Formatter formatter = new Formatter(stringBuilder);
            formatter.format("tree_%03d.png", i + 1);
            String string3 = stringBuilder.toString();
            DisplayableIO.writeGrayscalePNGFile((Displayable)object, new File(file, string3));
            printStream.print("<IMG SRC=\"");
            printStream.print(string3);
            printStream.println("\"/>");
            printStream.println("<P>");
            printStream.print("Squared error = ");
            printStream.println(d);
            printStream.println("</P>");
        }
        printStream2.close();
        long l4 = System.currentTimeMillis();
        printStream.println("<P><HR/></P>");
        printStream.println("<P>");
        printStream.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printStream.println("<TR>");
        printStream.print("<TD ALIGN=\"right\" VALIGN=\"top\">");
        printStream.print(l2 - l);
        printStream.println("&nbsp;</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">msec preprocessing</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.print("<TD ALIGN=\"right\" VALIGN=\"top\">");
        printStream.print(l3 - l2);
        printStream.println("&nbsp;</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">msec calculation</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.print("<TD ALIGN=\"right\" VALIGN=\"top\">");
        printStream.print(l4 - l3);
        printStream.println("&nbsp;</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">msec postprocessing</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.print("<TD ALIGN=\"right\" VALIGN=\"top\">");
        printStream.print(l4 - l);
        printStream.println("&nbsp;</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">msec total</TD>");
        printStream.println("</TR>");
        printStream.println("</TABLE>");
        printStream.println("</P>");
        printStream.println("<P>");
        printStream.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.println("Powered by Parallel Java:&nbsp;&nbsp;");
        printStream.println("</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.println("<A HREF=\"http://www.cs.rit.edu/~ark/pj.shtml\">http://www.cs.rit.edu/~ark/pj.shtml</A>");
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.println("Developed by Alan Kaminsky:&nbsp;&nbsp;");
        printStream.println("</TD>");
        printStream.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printStream.println("<A HREF=\"http://www.cs.rit.edu/~ark/\">http://www.cs.rit.edu/~ark/</A>");
        printStream.println("</TD>");
        printStream.println("</TR>");
        printStream.println("</TABLE>");
        printStream.println("</P>");
        printStream.println("</BODY>");
        printStream.println("</HTML>");
        printStream.close();
    }

    private static void printDistanceMatrix(PrintStream printStream, String string, String string2, DnaSequenceList dnaSequenceList, Distance distance) {
        DnaSequence dnaSequence;
        int n;
        printStream.print("<P>");
        printStream.print(string);
        printStream.println("</P>");
        printStream.println("<TABLE BORDER=1 CELLPADDING=2 CELLSPACING=0>");
        printStream.println("<TR>");
        printStream.println("<TD ALIGN=\"center\" BGCOLOR=\"#e8e8e8\">&nbsp;</TD>");
        for (n = 0; n < dnaSequenceList.length(); ++n) {
            dnaSequence = dnaSequenceList.seq(n);
            printStream.print("<TD ALIGN=\"center\" BGCOLOR=\"#e8e8e8\">");
            printStream.print(dnaSequence.name());
            printStream.println("</TD>");
        }
        printStream.println("</TR>");
        for (n = 0; n < dnaSequenceList.length(); ++n) {
            dnaSequence = dnaSequenceList.seq(n);
            printStream.println("<TR>");
            printStream.print("<TD ALIGN=\"center\" BGCOLOR=\"#e8e8e8\">");
            printStream.print(dnaSequence.name());
            printStream.println("</TD>");
            for (int i = 0; i < dnaSequenceList.length(); ++i) {
                DnaSequence dnaSequence2 = dnaSequenceList.seq(i);
                printStream.print("<TD ALIGN=\"center\">");
                printStream.format(string2, distance.distance(dnaSequence, dnaSequence2));
                printStream.println("</TD>");
            }
            printStream.println("</TR>");
        }
        printStream.println("</TABLE>");
    }

    private static double averageRootHeight(DnaSequenceTree dnaSequenceTree) {
        double d = 0.0;
        int n = dnaSequenceTree.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (dnaSequenceTree.child1(i) != -1) continue;
            d += Results.rootHeight(dnaSequenceTree, i);
            ++n2;
        }
        return d / (double)n2;
    }

    private static double rootHeight(DnaSequenceTree dnaSequenceTree, int n) {
        double d = 0.0;
        while (n != -1) {
            Double d2 = dnaSequenceTree.branchLength(n);
            if (d2 != null) {
                d += d2.doubleValue();
            }
            n = dnaSequenceTree.parent(n);
        }
        return d;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TreeInfo
    implements Comparable<TreeInfo> {
        public DnaSequenceTree tree;
        public double sqrerr;
        public double avgheight;

        public TreeInfo(DnaSequenceTree dnaSequenceTree, double d, double d2) {
            this.tree = dnaSequenceTree;
            this.sqrerr = d;
            this.avgheight = d2;
        }

        @Override
        public int compareTo(TreeInfo treeInfo) {
            if (this.sqrerr < treeInfo.sqrerr) {
                return -1;
            }
            if (this.sqrerr > treeInfo.sqrerr) {
                return 1;
            }
            if (this.avgheight < treeInfo.avgheight) {
                return -1;
            }
            if (this.avgheight > treeInfo.avgheight) {
                return 1;
            }
            return 0;
        }
    }
}

