## ---- eval=FALSE--------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly=TRUE))
#      install.packages("BiocManager")
#  BiocManager::install('biodbUniprot')

## ---- results='hide'----------------------------------------------------------
mybiodb <- biodb::newInst()

## -----------------------------------------------------------------------------
conn <- mybiodb$getFactory()$createConn('uniprot')

## -----------------------------------------------------------------------------
entries <- conn$getEntry(c('P01011', 'P09237'))

## -----------------------------------------------------------------------------
mybiodb$entriesToDataframe(entries)

## -----------------------------------------------------------------------------
conn$wsSearch('reviewed:true AND organism_id:9606', fields=c('accession', 'id'),
    size=2, retfmt='plain')

## -----------------------------------------------------------------------------
conn$wsSearch('reviewed:true AND organism_id:9606', fields=c('accession', 'id'),
    size=2, retfmt='parsed')

## -----------------------------------------------------------------------------
conn$wsSearch('reviewed:true AND organism_id:9606', fields=c('accession', 'id'),
    size=2, retfmt='ids')

## -----------------------------------------------------------------------------
conn$wsSearch('reviewed:true AND organism_id:9606', fields=c('accession', 'id'),
    size=2, retfmt='request')

## -----------------------------------------------------------------------------
ids <- conn$geneSymbolToUniprotIds('G-CSF')
mybiodb$entryIdsToDataframe(ids[['G-CSF']], 'uniprot', fields=c('accession',
    'gene.symbol'))

## -----------------------------------------------------------------------------
ids <- conn$geneSymbolToUniprotIds('G-CSF', ignore.nonalphanum=TRUE)
mybiodb$entryIdsToDataframe(ids[['G-CSF']], 'uniprot', fields=c('accession',
    'gene.symbol'))

## -----------------------------------------------------------------------------
ids <- conn$geneSymbolToUniprotIds('G-CSF', partial.match=TRUE)
mybiodb$entryIdsToDataframe(ids[['G-CSF']], 'uniprot', fields=c('accession',
    'gene.symbol'))

## -----------------------------------------------------------------------------
mybiodb$terminate()

## -----------------------------------------------------------------------------
sessionInfo()

