## ----setup, include = FALSE---------------------------------------------------
if(!"root_dir"%in%ls()){
  root_dir<-FALSE
}
# root_dir<-TRUE;knitr::knit("vignettes/vignette.Rmd", output = "README.md")
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
options(scipen=999)
library(Travel)
library(inline)
Travel:::deploy_filesystem()
Travel:::set_verbose(FALSE)

## -----------------------------------------------------------------------------
x <- 1:(1024*1024*1024*1024)
length(x)
typeof(x)

## -----------------------------------------------------------------------------
head(x)

## ---- error=TRUE--------------------------------------------------------------
## Short sequence
x1 <- 1:10
x1[1] <- 10 
head(x1)

## long sequence 
x2 <- 1:(64*1024*1024*1024)
x2[1] <- 10

## ---- include=FALSE-----------------------------------------------------------
if(root_dir){
  making_altrep <- "vignettes/making_altrep.png"
  data_request <- "vignettes/data_request.png"
}else{
  making_altrep <- "making_altrep.png"
  data_request <- "data_request.png"
}

## -----------------------------------------------------------------------------
x <- 1:(64*1024*1024*1024)
y <- wrap_altrep(x)

x[1:10]
y[1:10]

## ---- error=TRUE--------------------------------------------------------------
x[1] <- 10
x[1:10]

y[1] <- 10
y[1:10]

## ---- error=TRUE--------------------------------------------------------------
## We only compute the sum of the first 10 elements
code <- 
'
  double* ptr = (double*)DATAPTR(x);
  double total = 0;
    for(int i = 0; i < 10; ++i){
    total = total + ptr[i];
    }
  return ScalarReal(total);
'
my_sum <- inline::cxxfunction(signature(x="SEXP"),
                    body=code)

## An error will be given for x
my_sum(x)
## No error will be given and the sum can be computed
my_sum(y)

## -----------------------------------------------------------------------------
sessionInfo()

