tabItem(tabName = "meanmet",

        fluidRow(
            column(8,  bsAlert("meanmetmessage"),
                   bsCollapse(id = "collapsemeanmet", open = "Mean DNA methylation plot",
                              bsCollapsePanel("Mean DNA methylation plot", uiOutput("meanMetplot"), style = "default"))),
            column(4,
                   box(title = "Mean DNA methylation",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = FALSE,
                       box(title = "Data",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = FALSE,
                           shinyFilesButton('meanmetfile', 'Select file', 'Please select SummarizedExperiment object',
                                            multiple = FALSE),
                           bsTooltip("meanmetfile", "An R object (.rda) with a summarized experiment of DNA methylation",
                                     "left")
                           ),
                       box(title = "Parameters control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput('meanmetgroupCol',
                                          "Group column",
                                          choices = NULL,  multiple = FALSE),
                           bsTooltip("meanmetgroupCol", "A column from the SummarizedExperiment object that maps each sample to one group",
                                     "left"),
                           selectizeInput('meanmetsubgroupCol',
                                          "Sub group column",
                                          choices = NULL,  multiple = FALSE),
                           bsTooltip("meanmetsubgroupCol", "A column from the SummarizedExperiment object that maps each sample to one group",
                                     "left"),
                           checkboxInput("meanmetplotjitter", "Plot jitters?", value = TRUE, width = NULL),
                           checkboxInput("meanmetSetLimits", "Select y limits?", value = FALSE, width = NULL),
                           numericInput("meanmetylimup", "Y upper limit",
                                        step=0.1, min = 0, max = 1, value = 1),
                           numericInput("meanmetylimlow", "Y lower limit",
                                        step=0.1, min = 0, max = 1, value = 0),
                           checkboxInput("meanmetSortCB", "Sort plot?", value = FALSE, width = NULL),
                           selectizeInput('meanmetsort',
                                          "Sort method",
                                          choices = c("None"=NULL,
                                                      "Ascending by mean"="mean.asc",
                                                      "Descending by mean"="mean.desc",
                                                      "Ascending by median"="median.asc",
                                                      "Descending by median"="median.desc"),
                                          multiple = FALSE),
                           checkboxInput("meanmetXnames", "Add x-axis text?", value = FALSE, width = NULL),
                           sliderInput("meanmetAxisAngle", "x-axis label angle:",   min = 0, max = 360, value = 90, step= 45)),
                       box(title = "Legend control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           selectizeInput('meanmetLegendPos',
                                          "Legend position",
                                          choices = c("top","bottom","right","left"),selected = "top",  multiple = FALSE),
                           selectizeInput('meanmetLegendTitlePos',
                                          "Legend Title position",
                                          choices = c("top","bottom","right","left"),selected = "top",  multiple = FALSE),
                           numericInput("meanmetLegendncols", "Number of legend columns",
                                        step=1, min = 0, max = 10, value = 3)
                       ),
                       box(title = "Size control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("meanmetwidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                           sliderInput("meanmetheight", "Plot Height (px)", min = 0, max = 1200, value = 800)),
                       actionButton("meanmetPlot",
                                    "DNA mean methylation plot",
                                    style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                    icon = icon("picture-o")),
                       downloadButton('savemeanmetpicture', 'Export figure', class = "butt2"),
                       textInput("meanmetPlot.filename", label = "Filename", value = "volcano.pdf"),
                       bsTooltip("meanmetPlot.filename", "Filename (pdf, png, svg)", "left")
                       )
            )
        )
)
