tabItem(tabName = "ea",
        fluidRow(
            column(8,
                   bsAlert("eamessage"),
                   bsCollapse(id = "collapseEA", open = "EA plots",
                              bsCollapsePanel("EA plots", uiOutput("eaPlot"), style = "default"))),
            column(4,
                   box(title = "EA analysis",width = NULL,
                       status = "danger",
                       solidHeader = FALSE, collapsible = FALSE,
                       box(title = "Gene selection",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE,collapsed = FALSE,
                           radioButtons("tcgaEaInputRb", "Genes by:",
                                        c("Selection"="Selection",
                                          "Text"="text",
                                          "File"="file")),
                           bsTooltip("eaGenesTextArea", "Genes separeted by (;), (,) or (new line)",
                                     "left"),
                           useShinyjs(),
                           inputTextarea('eaGenesTextArea', '', 2, 30),
                           selectizeInput('eagenes',
                                          "Genes",
                                          choices = NULL,
                                          multiple = TRUE),
                           bsTooltip("eaGenesFiles", "Expecting a column Gene_symbol or mRNA in the file (csv,txt,rda). If it is the DEA_results files, it will ignore the insignificant genes",
                                     "left"),
                           shinyFilesButton('eaGenesFiles', 'Select file with genes', 'Please select a file with genes',  multiple = FALSE)),
                       box(title = "Parameters control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           numericInput("eaSizeText", "Size of the text",
                                        step=0.1, min = 0.1, max = 3, value = 1),
                           numericInput("eaxlim", "X upper limit",
                                        step=1, min = 0, max = 50, value = 0),
                           sliderInput("nBar", "Number of bar histogram to show",
                                       step=1, min = 1, max = 20, value = 10)),
                       box(title = "Plot selection",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           checkboxInput("eaPlotBPCB", " Plot biological process?", value = TRUE, width = NULL),
                           checkboxInput("eaPlotCCCB", " Plot Cellular Component?", value = TRUE, width = NULL),
                           checkboxInput("eaPlotMFCB", " Plot Molecular function?", value = TRUE, width = NULL),
                           checkboxInput("eaPlotPatCB", " Plot Pathways?", value = TRUE, width = NULL)),
                       box(title = "Colors control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           colourpicker::colourInput("colBP", "Biological Process", value = "orange"),
                           colourpicker::colourInput("colCC", "Cellular Component color", value = "cyan"),
                           colourpicker::colourInput("colMF", "Molecular function color", value = "green"),
                           colourpicker::colourInput("colPat", "Pathways color", value = "yellow")),
                       box(title = "Size control",width = NULL,
                           solidHeader = TRUE, collapsible = TRUE, collapsed = TRUE,
                           sliderInput("eawidth", "Plot Width (%)", min = 0, max = 100, value = 100),
                           sliderInput("eaheight", "Plot Height (px)", min = 0, max = 1000, value = 800)),
                       actionButton("eaplot",
                                    "EA barplot",
                                    style = "background-color: #000080;
                                            color: #FFFFFF;
                                            margin-left: auto;
                                            margin-right: auto;
                                            width: 100%",
                                    icon = icon("picture-o")),
                       downloadButton('saveeapicture', 'Export figure', class = "butt2"),
                       textInput("eaPlot.filename", label = "Filename", value = "enrichmentAnalysis.pdf"),
                       bsTooltip("eaPlot.filename", "Filename (pdf, png, svg)", "left")
                   )
            )
        )
)
