/*
 * Decompiled with CFR 0.152.
 */
package reder.application;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingWorker;
import reder.application.RedeR;
import reder.application.RederMainFrame;
import reder.application.Zoom;
import reder.application.graph.EdgeBank;
import reder.application.graph.LegendBank;
import reder.application.graph.NodeBank;

public class Methods {
    private NodeBank nodeAccount = null;
    private NodeBank nodeAccountFound = null;
    private EdgeBank edgeAccount = null;
    private boolean isToAssignTree = false;
    private tarefaFilterZoom taskFilterZoom = null;

    public void deSelectGraph() {
        this.deSelectNodes();
        this.deSelectEdges();
    }

    public void selectGraph() {
        this.selectAllNodes();
        this.selectAllEdges();
    }

    public void selectAllNodes() {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (this.nodeAccount.isContainerHided()) continue;
            this.nodeAccount.setDestaque(true);
        }
    }

    public void bringToFront() {
        RedeR.mf.requestFocus();
        RedeR.mf.toFront();
    }

    public boolean anyNodeSelected() {
        boolean anySelected = false;
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            anySelected = true;
            break;
        }
        return anySelected;
    }

    public boolean anyEdgeSelected() {
        boolean anySelected = false;
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (!this.edgeAccount.getDestaque()) continue;
            anySelected = true;
            break;
        }
        return anySelected;
    }

    public int nNodesSelected() {
        int nelected = 0;
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            if (this.nodeAccount.isContainer()) {
                nelected += this.nodeAccount.getContainerComponents().size();
                continue;
            }
            ++nelected;
        }
        return nelected;
    }

    public int nUnNestedNodes() {
        int nelected = 0;
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (this.nodeAccount.isNodeNested()) continue;
            ++nelected;
        }
        return nelected;
    }

    public void taskHighlight() {
        tarefaHighlight newTask = new tarefaHighlight();
        newTask.execute();
    }

    public int selectNeighbours(String nodeA) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (!a.getNodeID().equals(nodeA)) continue;
            a.setDestaqueNeighbours(true);
            return 1;
        }
        return 0;
    }

    public void selectAllEdges() {
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (!RederMainFrame.isToShowTree() && this.edgeAccount.isDefaultEdgeAssignmet() && RederMainFrame.NodeList.get(this.edgeAccount.getA()).isContainer()) continue;
            this.edgeAccount.setDestaque(true);
        }
    }

    public void deSelectNodes() {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setDestaque(false);
            this.nodeAccount.setDestaqueTree(false);
        }
    }

    public void deSelectEdges() {
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            this.edgeAccount.setDestaque(false);
        }
    }

    public void selectEdge(String nodeA, String nodeB) {
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            boolean cc2;
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            String na = RederMainFrame.NodeList.get(a).getNodeID();
            String nb = RederMainFrame.NodeList.get(b).getNodeID();
            String aliasa = RederMainFrame.NodeList.get(a).getAliases();
            String aliasb = RederMainFrame.NodeList.get(b).getAliases();
            boolean c1 = na.equals(nodeA) && nb.equals(nodeB);
            boolean c2 = na.equals(nodeB) && nb.equals(nodeA);
            boolean cc1 = c1 || c2;
            c1 = aliasa.equals(nodeA) && aliasb.equals(nodeB);
            c2 = aliasa.equals(nodeB) && aliasb.equals(nodeA);
            boolean bl = cc2 = c1 || c2;
            if (!cc1 && !cc2) continue;
            this.edgeAccount.setDestaque(true);
            break;
        }
    }

    public int selectNode(String nodeA, String nt, boolean setAnchor) {
        for (NodeBank a : RederMainFrame.NodeList) {
            if (nt != null) {
                if (!a.isNodeNested()) continue;
                int nrt = RederMainFrame.keyNodeArray.indexOf(a.getNestedAssignment());
                String roodId = RederMainFrame.NodeList.get(nrt).getNodeID();
                String roodAlias = RederMainFrame.NodeList.get(nrt).getAliases();
                if (!roodId.equals(nt) || !roodAlias.equals(nt)) continue;
            }
            if (!a.getNodeID().equals(nodeA) && !a.getAliases().equals(nodeA)) continue;
            a.setDestaque(true);
            a.setAnchored(setAnchor);
            return 1;
        }
        return 0;
    }

    public String aninhar(ArrayList<Integer> listaMarcados, Color containerColor, boolean setHide, boolean setTransparency, boolean setAnchor, boolean setAssigned) {
        boolean condition3;
        String rootPanel = "assignRoot_meaninglessCode1245ty890xyz";
        int[] marcadosLevel = new int[listaMarcados.size()];
        String[] marcadosRoot = new String[listaMarcados.size()];
        for (int i = 0; i < listaMarcados.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(listaMarcados.get(i));
            marcadosRoot[i] = this.nodeAccount.getNestedAssignment();
            marcadosLevel[i] = 0;
            boolean flagRoot = false;
            String rootPath = marcadosRoot[i];
            while (!flagRoot) {
                if (rootPath.equals(rootPanel)) {
                    flagRoot = true;
                    continue;
                }
                marcadosLevel[i] = marcadosLevel[i] + 1;
                rootPath = RederMainFrame.NodeList.get(RederMainFrame.keyNodeArray.indexOf(rootPath)).getNestedAssignment();
            }
        }
        String validRoot = "";
        int validRootLevel = 0;
        for (int i = 0; i < marcadosLevel.length; ++i) {
            validRootLevel = marcadosLevel[i];
            validRoot = marcadosRoot[i];
            for (int j = 0; j < marcadosLevel.length; ++j) {
                if (validRootLevel <= marcadosLevel[j]) continue;
                validRootLevel = marcadosLevel[j];
                validRoot = marcadosRoot[j];
            }
        }
        int nFilhosValidos = 0;
        int nFilhos = 0;
        ArrayList<String> listaAninhados = new ArrayList<String>();
        for (int i = 0; i < listaMarcados.size(); ++i) {
            if (marcadosLevel[i] == validRootLevel) {
                ++nFilhos;
            }
            if (!marcadosRoot[i].equals(validRoot)) continue;
            ++nFilhosValidos;
            listaAninhados.add(RederMainFrame.NodeList.get(listaMarcados.get(i)).getNodeID());
        }
        int nNetosValidos = 0;
        int nNetos = 0;
        if (nFilhosValidos >= 1) {
            for (int i = 0; i < listaMarcados.size(); ++i) {
                if (marcadosLevel[i] <= validRootLevel) continue;
                ++nNetos;
                String rootPath = marcadosRoot[i];
                for (int j = 0; j < marcadosLevel[i]; ++j) {
                    for (int k = 0; k < listaAninhados.size(); ++k) {
                        if (!rootPath.equals(listaAninhados.get(k))) continue;
                        ++nNetosValidos;
                        break;
                    }
                    rootPath = RederMainFrame.NodeList.get(RederMainFrame.keyNodeArray.indexOf(rootPath)).getNestedAssignment();
                }
            }
        }
        boolean condition1 = nFilhosValidos >= 1;
        boolean condition2 = nFilhosValidos == nFilhos;
        boolean bl = condition3 = nNetosValidos == nNetos;
        if (condition1 && condition2 && condition3) {
            RederMainFrame.lockMouse = true;
            int gn = 1;
            int tn = 1;
            for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
                this.nodeAccount = RederMainFrame.NodeList.get(i);
                if (!this.nodeAccount.isContainer()) continue;
                String testNumber = this.nodeAccount.getNodeID();
                testNumber = (String)testNumber.subSequence(1, testNumber.length());
                try {
                    tn = Integer.parseInt(testNumber);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (tn < gn) continue;
                gn = tn + 1;
            }
            String containerName = "N" + gn;
            while (true) {
                if (!RederMainFrame.keyNodeHash.containsKey(containerName)) {
                    boolean flag = false;
                    for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
                        this.nodeAccount = RederMainFrame.NodeList.get(i);
                        boolean b = this.nodeAccount.getNodeID().contains(".$" + containerName);
                        if (!b) continue;
                        flag = true;
                    }
                    if (!flag) break;
                }
                containerName = "N" + ++gn;
            }
            RederMainFrame.NodeList.add(new NodeBank(containerName, RederMainFrame.NodeList.size()));
            int newContainer = RederMainFrame.NodeList.size() - 1;
            RederMainFrame.keyNodeHash.put(containerName, newContainer);
            RederMainFrame.keyNodeArray.add(containerName);
            NodeBank containerAccount = RederMainFrame.NodeList.get(newContainer);
            containerAccount.setContainer(true);
            if (!validRoot.equals(rootPanel)) {
                Integer root = (Integer)RederMainFrame.keyNodeHash.get(validRoot);
                RederMainFrame.EdgeList.add(0, new EdgeBank(root, newContainer, RederMainFrame.EdgeList.size()));
                this.edgeAccount = RederMainFrame.EdgeList.get(0);
                this.edgeAccount.setEdgeColor(containerColor);
                this.edgeAccount.setLine(2.0f, "DOTTED");
            }
            for (int i = 0; i < listaMarcados.size(); ++i) {
                int marcado = listaMarcados.get(i);
                this.nodeAccount = RederMainFrame.NodeList.get(marcado);
                if (!this.nodeAccount.getNestedAssignment().equals(validRoot)) continue;
                if (this.nodeAccount.isNodeNested()) {
                    for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
                        this.edgeAccount = RederMainFrame.EdgeList.get(j);
                        int nA = this.edgeAccount.getA();
                        int nB = this.edgeAccount.getB();
                        if (!RederMainFrame.NodeList.get(nA).isContainer() || !RederMainFrame.NodeList.get(nB).getNodeID().equals(this.nodeAccount.getNodeID()) || !this.edgeAccount.isDefaultEdgeAssignmet()) continue;
                        RederMainFrame.EdgeList.remove(this.edgeAccount);
                    }
                }
                RederMainFrame.EdgeList.add(0, new EdgeBank(newContainer, marcado, RederMainFrame.EdgeList.size()));
                this.edgeAccount = RederMainFrame.EdgeList.get(0);
                this.edgeAccount.setEdgeColor(containerColor);
                this.edgeAccount.setLine(2.0f, "DOTTED");
            }
            this.updateBanks();
            containerAccount.updateContainer();
            containerAccount.setFontSize(18);
            containerAccount.setFontPositionX("left");
            containerAccount.setFontPositionY("top");
            containerAccount.setFontOffsetX(-5.0f);
            containerAccount.setFontOffsetY(-5.0f);
            containerAccount.setNodeColor(containerColor);
            containerAccount.setNodeLineColor(containerColor);
            containerAccount.setNodeGradient(true);
            containerAccount.setNodeLineWidth(containerAccount.getNodeSizeScale() / 20.0f);
            containerAccount.setContainerHided(setHide);
            containerAccount.setContainerTransparent(setTransparency);
            containerAccount.setAnchored(setAnchor);
            int flag = 0;
            this.deSelectNodes();
            for (int a = 0; a < listaMarcados.size() - flag; ++a) {
                RederMainFrame.NodeList.get(listaMarcados.get(a)).setDestaque(true);
            }
            this.globalChangeOrder("forward");
            this.deSelectNodes();
            listaMarcados.clear();
            if (this.isToAssignTree()) {
                this.assignTree(containerAccount);
            } else if (setAssigned) {
                this.assignTree(containerAccount);
            }
            if (containerAccount.getContainerComponents().size() <= 2) {
                this.removeMockNodes();
            }
            RederMainFrame.lockMouse = false;
            return containerAccount.getNodeID();
        }
        String aviso = "";
        if (!condition1 && (condition2 || condition3)) {
            aviso = "Your request is inconsistent with the hierarchy!";
        } else if (!condition2 || !condition3) {
            aviso = "Your request is inconsistent with the hierarchy!";
        }
        RederMainFrame.lockMouse = false;
        return aviso;
    }

    public void removeMockNodes() {
        this.deSelectNodes();
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.isMock()) continue;
            this.nodeAccount.setDestaque(true);
        }
        RederMainFrame.methods.globalActionDeleteNode();
    }

    public void assignTreePermanently() {
        this.isToAssignTree = true;
    }

    public boolean isToAssignTree() {
        return this.isToAssignTree;
    }

    private void assignTree(NodeBank container) {
        if (container.isContainer()) {
            container.assignTree();
            RederMainFrame.keyNodeArray.clear();
            RederMainFrame.keyNodeHash.clear();
            for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
                this.nodeAccount = RederMainFrame.NodeList.get(i);
                String name = this.nodeAccount.getNodeID();
                RederMainFrame.keyNodeArray.add(name);
                RederMainFrame.keyNodeHash.put(name, i);
            }
            this.updateBanks();
        }
    }

    public void mergeContainerOutEdges(ArrayList<Integer> listaContainers) {
        RederMainFrame.lockMouse = true;
        for (int a = 0; a < listaContainers.size(); ++a) {
            this.deSelectNodes();
            this.deSelectEdges();
            int nest = listaContainers.get(a);
            this.nodeAccountFound = RederMainFrame.NodeList.get(nest);
            if (!this.nodeAccountFound.isContainer()) continue;
            this.nodeAccountFound.setDestaqueTree(true);
            ArrayList<Integer> components = this.nodeAccountFound.getContainerComponents();
            for (int i = 0; i < components.size(); ++i) {
                this.nodeAccount = RederMainFrame.NodeList.get(components.get(i));
                int oneComponent = (Integer)RederMainFrame.keyNodeHash.get(this.nodeAccount.getNodeID());
                ArrayList<Integer> parceiros = this.nodeAccount.getParceiros();
                for (int j = 0; j < parceiros.size(); ++j) {
                    boolean c2;
                    boolean c1;
                    EdgeBank ref;
                    int k;
                    EdgeBank merge2;
                    EdgeBank merge1;
                    int umParceiro = parceiros.get(j);
                    if (RederMainFrame.NodeList.get(umParceiro).getDestaqueTree()) continue;
                    boolean deposito = this.nodeAccountFound.addParceiro(umParceiro);
                    if (deposito) {
                        RederMainFrame.EdgeList.add(new EdgeBank(nest, umParceiro, RederMainFrame.EdgeList.size()));
                        merge1 = RederMainFrame.EdgeList.get(RederMainFrame.EdgeList.size() - 1);
                        merge2 = null;
                        for (k = 0; k < RederMainFrame.EdgeList.size(); ++k) {
                            ref = RederMainFrame.EdgeList.get(k);
                            c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                            boolean bl = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                            if (!c1 && !c2) continue;
                            merge2 = ref;
                            break;
                        }
                        if (merge2 == null) continue;
                        merge1.setLineWidth(merge2.getWidth());
                        merge1.setWeight(merge2.getWeight());
                        merge1.addUnit(merge2.getUnit() - 1);
                        merge1.setDefaultEdgeAssignment(false);
                        merge1.setEdgeColor(Color.LIGHT_GRAY);
                        merge2.setDestaque(true);
                        continue;
                    }
                    merge1 = null;
                    merge2 = null;
                    for (k = RederMainFrame.EdgeList.size() - 1; k >= 0; --k) {
                        ref = RederMainFrame.EdgeList.get(k);
                        c1 = ref.getA() == nest && ref.getB() == umParceiro;
                        boolean bl = c2 = ref.getB() == nest && ref.getA() == umParceiro;
                        if (c1 || c2) {
                            merge1 = ref;
                            if (merge2 != null) break;
                        }
                        c1 = ref.getA() == oneComponent && ref.getB() == umParceiro;
                        boolean bl2 = c2 = ref.getB() == oneComponent && ref.getA() == umParceiro;
                        if (!c1 && !c2) continue;
                        merge2 = ref;
                        if (merge1 != null) break;
                    }
                    if (merge1 == null || merge2 == null) continue;
                    merge1.setLineWidth(merge1.getWidth() + merge2.getWidth());
                    merge1.setWeight(merge1.getWeight() + merge2.getWeight());
                    merge1.addUnit(merge2.getUnit());
                    merge1.setDefaultEdgeAssignment(false);
                    merge2.setDestaque(true);
                }
            }
            this.deleteSelectedEdges();
        }
        RederMainFrame.methods.updateBanks();
        RederMainFrame.lockMouse = false;
    }

    public void correctOutEdgeWidth(double cclimit) {
        int i;
        cclimit = Math.max(Math.min(cclimit, 1.0), 0.001);
        double rescale = 1.0;
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            double scl;
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            NodeBank na = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nb = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            double sznode = (double)((na.getW() + na.getH()) / 2.0f) * cclimit;
            sznode = Math.min(sznode, (double)((nb.getW() + nb.getH()) / 2.0f) * cclimit);
            double szedge = this.edgeAccount.getWidth();
            if (!(szedge > sznode) || !((scl = sznode / szedge) < rescale)) continue;
            rescale = scl;
        }
        if (rescale == 0.0 || rescale == 1.0) {
            return;
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            this.edgeAccount.setEdgeWidthScale((float)rescale);
        }
    }

    public void correctOutEdgeWidth(Double lb, Double ub) {
        NodeBank nb;
        NodeBank na;
        double maxSize = 0.0;
        double minSize = 1000000.0;
        for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
            this.edgeAccount = RederMainFrame.EdgeList.get(j);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            na = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            nb = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            if (!na.isContainer() || !nb.isContainer()) continue;
            double szedge = this.edgeAccount.getWidth();
            if (maxSize < szedge) {
                maxSize = szedge;
            }
            if (!(minSize > szedge)) continue;
            minSize = szedge;
        }
        if (ub == null || lb == null) {
            lb = minSize;
            ub = maxSize;
        }
        if (maxSize == minSize) {
            return;
        }
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (this.edgeAccount.isDefaultEdgeAssignmet()) continue;
            na = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            nb = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            if (!na.isContainer() || !nb.isContainer()) continue;
            double globalnorm = ((double)this.edgeAccount.getWidth() - minSize) / (maxSize - minSize);
            double width = lb + globalnorm * (ub - lb);
            this.edgeAccount.setLineWidth((float)width);
        }
    }

    public int reAssigments(String newparent, List<String> nodes, boolean updatecontent) {
        int countranfer = 0;
        if (newparent.equals(".$unroot")) {
            for (int i = 0; i < nodes.size(); ++i) {
                String nd = nodes.get(i);
                int nnode = RederMainFrame.keyNodeArray.indexOf(nd);
                if (nnode == -1) continue;
                this.nodeAccount = RederMainFrame.NodeList.get(nnode);
                if (!this.nodeAccount.isNodeNested()) continue;
                int nroot = RederMainFrame.keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
                    this.edgeAccount = RederMainFrame.EdgeList.get(j);
                    if (!this.edgeAccount.getEdgeAssociationType().equals("edgeTree") || this.edgeAccount.getA() != nroot || this.edgeAccount.getB() != nnode) continue;
                    RederMainFrame.EdgeList.remove(this.edgeAccount);
                    --j;
                }
            }
            RederMainFrame.methods.updateBanks();
            return countranfer;
        }
        int idNewParent = RederMainFrame.keyNodeArray.indexOf(newparent);
        if (idNewParent == -1) {
            return countranfer;
        }
        NodeBank nodeAccountNewParent = RederMainFrame.NodeList.get(idNewParent);
        if (!nodeAccountNewParent.isContainer()) {
            return countranfer;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            String nod = nodes.get(i);
            int idNode = RederMainFrame.keyNodeArray.indexOf(nod);
            if (idNode == -1 || idNewParent == idNode) continue;
            NodeBank nodeAccountNode = RederMainFrame.NodeList.get(idNode);
            int idOldParent = nodeAccountNode.getNestedAssignmentIndx();
            if (nodeAccountNewParent.isPartner(idNode)) {
                this.deleteOneEdge(idNewParent, idNode, "edgeContainer");
            } else {
                int rpath = idNewParent;
                while (rpath >= 0) {
                    if (rpath != idOldParent && nodeAccountNode.isPartner(rpath)) {
                        this.deleteOneEdge(rpath, idNode, "edgeTree");
                    }
                    rpath = RederMainFrame.NodeList.get(rpath).getNestedAssignmentIndx();
                }
            }
            if (nodeAccountNode.isNodeNested()) {
                int nc = this.tranferAssigment(idOldParent, idNewParent, idNode);
                countranfer += nc;
                continue;
            }
            int idEdge = RederMainFrame.EdgeList.size();
            RederMainFrame.EdgeList.add(new EdgeBank(idNewParent, idNode, idEdge));
            this.edgeAccount = RederMainFrame.EdgeList.get(RederMainFrame.EdgeList.size() - 1);
            this.edgeAccount.setLine(2.0f, "DOTTED");
            this.edgeAccount.setEdgeColor(nodeAccountNewParent.getNodeFillColor());
            ++countranfer;
        }
        this.updateBanks();
        if (updatecontent) {
            nodeAccountNewParent.updateContent();
        }
        this.globalChangeOrder("forwardNode", nodes);
        return countranfer;
    }

    private int tranferAssigment(int n1, int n2, int n3) {
        int cont = 0;
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            if (a != n1 || b != n3) continue;
            this.edgeAccount.setA(n2);
            ++cont;
        }
        return cont;
    }

    private void deleteOneEdge(int n1, int n2, String type) {
        for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
            boolean b2;
            this.edgeAccount = RederMainFrame.EdgeList.get(j);
            boolean b1 = this.edgeAccount.getA() == n1 && this.edgeAccount.getB() == n2;
            boolean bl = b2 = this.edgeAccount.getA() == n2 && this.edgeAccount.getB() == n1;
            if (!b1 && !b2 || !this.edgeAccount.getEdgeAssociationType().equals(type)) continue;
            RederMainFrame.EdgeList.remove(this.edgeAccount);
            --j;
        }
    }

    public void updateNodeTransform(boolean setHide, boolean setTransparency, boolean setAnchor, boolean setAssigned) {
        int i;
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.isTransformed()) continue;
            this.nodeAccount.nodeTransform();
            this.nodeAccount.setContainerHided(setHide);
            this.nodeAccount.setContainerTransparent(setTransparency);
            this.nodeAccount.setAnchored(setAnchor);
            if (!setAssigned) continue;
            this.assignTree(this.nodeAccount);
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            boolean c2;
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            NodeBank nodeAccountA = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccountB = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            boolean ca = nodeAccountA.isTransformed();
            boolean cb = nodeAccountB.isTransformed();
            boolean c1 = ca || cb;
            boolean bl = c2 = !nodeAccountB.getNestedAssignment().equals(nodeAccountA.getNodeID());
            if (c1 && c2) {
                this.edgeAccount.setDefaultEdgeAssignment(false);
            }
            if (nodeAccountA.isContainer() || !cb) continue;
            int a = this.edgeAccount.getA();
            int b = this.edgeAccount.getB();
            this.edgeAccount.setA(b);
            this.edgeAccount.setB(a);
            int d = this.edgeAccount.getArrowDirection();
            if (d == 1) {
                this.edgeAccount.setArrowDirection(2);
            }
            if (d == 2) {
                this.edgeAccount.setArrowDirection(1);
            }
            if (d == -1) {
                this.edgeAccount.setArrowDirection(-2);
            }
            if (d == -2) {
                this.edgeAccount.setArrowDirection(-1);
            }
            if (d == 4) {
                this.edgeAccount.setArrowDirection(-4);
            }
            if (d != -4) continue;
            this.edgeAccount.setArrowDirection(4);
        }
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setTransformed(false);
        }
        this.updateBanks();
    }

    public void updateBanks() {
        int i;
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            RederMainFrame.NodeList.get(i).resetParceiros();
            RederMainFrame.NodeList.get(i).resetContainerComponents();
            RederMainFrame.NodeList.get(i).resetNestedAssignment();
            RederMainFrame.NodeList.get(i).resetContainerEdgeMap();
            RederMainFrame.NodeList.get(i).resetInContainerSimpleEdges();
            RederMainFrame.NodeList.get(i).resetOutContainerSimpleEdges();
            RederMainFrame.NodeList.get(i).setDestaqueTree(false);
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            int nr;
            boolean c5;
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            this.edgeAccount.updateDefaultEdgeAssigment();
            NodeBank nodeAccountA = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccountB = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            nodeAccountA.addParceiro(this.edgeAccount.getB());
            nodeAccountB.addParceiro(this.edgeAccount.getA());
            boolean c1 = nodeAccountA.isContainer();
            boolean c2 = nodeAccountB.isContainer();
            boolean c3 = this.edgeAccount.isDefaultEdgeAssignmet();
            if (c1 && c3) {
                nodeAccountA.addContainerComponent(this.edgeAccount.getB());
                nodeAccountB.setNodeNested(nodeAccountA.getNodeID());
            } else if (!c3) {
                if (c1 && c2) {
                    for (int a = RederMainFrame.NodeList.size() - 1; a >= 0; --a) {
                        if (RederMainFrame.NodeList.get(a) == nodeAccountA) {
                            nodeAccountB.addContainerEdgeUnique(i);
                        } else {
                            if (RederMainFrame.NodeList.get(a) != nodeAccountB) continue;
                            nodeAccountA.addContainerEdgeUnique(i);
                        }
                        break;
                    }
                } else if (c1) {
                    nodeAccountA.addContainerEdgeUnique(i);
                } else if (c2) {
                    nodeAccountB.addContainerEdgeUnique(i);
                }
            }
            boolean c4 = nodeAccountA.isNodeNested() || nodeAccountB.isNodeNested();
            boolean bl = c5 = !nodeAccountA.getNestedAssignment().equals(nodeAccountB.getNestedAssignment());
            if (c1 || c2 || !c3 || !c4) continue;
            if (c5) {
                if (nodeAccountA.isNodeNested()) {
                    nr = RederMainFrame.keyNodeArray.indexOf(nodeAccountA.getNestedAssignment());
                    RederMainFrame.NodeList.get(nr).addOutContainerSimpleEdge(i);
                }
                if (!nodeAccountB.isNodeNested()) continue;
                nr = RederMainFrame.keyNodeArray.indexOf(nodeAccountB.getNestedAssignment());
                RederMainFrame.NodeList.get(nr).addOutContainerSimpleEdge(i);
                continue;
            }
            if (!nodeAccountA.isNodeNested()) continue;
            nr = RederMainFrame.keyNodeArray.indexOf(nodeAccountA.getNestedAssignment());
            RederMainFrame.NodeList.get(nr).addInContainerSimpleEdge(i);
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            this.edgeAccount.updateEdgeAssociation();
        }
        this.updateContainerTree();
    }

    public Integer[] getSortIndex(final Float[] data, boolean isDescending) {
        Integer[] idx = new Integer[data.length];
        for (int i = 0; i < data.length; ++i) {
            idx[i] = i;
        }
        Arrays.sort(idx, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Float.compare(data[o1].floatValue(), data[o2].floatValue());
            }
        });
        Integer[] index = new Integer[idx.length];
        if (isDescending) {
            for (int i = 0; i < idx.length; ++i) {
                index[i] = idx[idx.length - 1 - i];
            }
        } else {
            index = idx;
        }
        return index;
    }

    public void updateContainerTree() {
        int i;
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNestedPosition(0);
            this.nodeAccount.setNestedVelox(1.0);
            if (!this.nodeAccount.isNodeNested() && !this.nodeAccount.isContainer()) {
                this.nodeAccount.setRelativeSize(1.0);
            }
            if (!this.nodeAccount.isContainer()) continue;
            this.nodeAccount.updateTreeSize();
            this.nodeAccount.updateTreeLevels();
            this.nodeAccount.updateTreeComponents();
        }
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.updateNodeLevel();
        }
    }

    public void globalChangeOrder(String moveType) {
        int i;
        int i2;
        ArrayList<NodeBank> clone;
        ArrayList passingKeysArray = new ArrayList();
        HashMap passingKeyHash = new HashMap();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (moveType.equals("backward")) {
            clone = new ArrayList(RederMainFrame.NodeList.size());
            for (i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = RederMainFrame.NodeList.get(i2);
                if (!this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = RederMainFrame.NodeList.get(i2);
                if (this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
            }
            RederMainFrame.NodeList.clear();
            RederMainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        } else {
            clone = new ArrayList<NodeBank>();
            for (i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = RederMainFrame.NodeList.get(i2);
                if (!this.nodeAccount.getDestaque()) continue;
                clone.add(this.nodeAccount);
                RederMainFrame.NodeList.remove(this.nodeAccount);
                --i2;
            }
            for (i2 = 0; i2 < clone.size(); ++i2) {
                RederMainFrame.NodeList.add((NodeBank)clone.get(i2));
            }
            clone.clear();
        }
        passingKeysArray = (ArrayList)RederMainFrame.keyNodeArray.clone();
        passingKeyHash = (HashMap)RederMainFrame.keyNodeHash.clone();
        RederMainFrame.keyNodeArray.clear();
        RederMainFrame.keyNodeHash.clear();
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            RederMainFrame.keyNodeArray.add(name);
            RederMainFrame.keyNodeHash.put(name, i);
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            String name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)RederMainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)RederMainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        this.updateBanks();
    }

    public void globalChangeOrder(String moveType, List<String> listaMarcados) {
        int i;
        int nid;
        String nd;
        int i2;
        ArrayList<NodeBank> clone;
        ArrayList passingKeysArray = new ArrayList();
        HashMap passingKeyHash = new HashMap();
        passingKeysArray.clear();
        passingKeyHash.clear();
        if (moveType.equals("backward")) {
            clone = new ArrayList<NodeBank>(listaMarcados.size());
            for (i2 = 0; i2 < listaMarcados.size(); ++i2) {
                nd = listaMarcados.get(i2);
                nid = RederMainFrame.keyNodeArray.indexOf(nd);
                this.nodeAccount = RederMainFrame.NodeList.get(nid);
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = RederMainFrame.NodeList.get(i2);
                if (listaMarcados.contains(this.nodeAccount.getNodeID())) continue;
                clone.add(this.nodeAccount);
            }
            RederMainFrame.NodeList.clear();
            RederMainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        } else {
            clone = new ArrayList(listaMarcados.size());
            for (i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
                this.nodeAccount = RederMainFrame.NodeList.get(i2);
                if (listaMarcados.contains(this.nodeAccount.getNodeID())) continue;
                clone.add(this.nodeAccount);
            }
            for (i2 = 0; i2 < listaMarcados.size(); ++i2) {
                nd = listaMarcados.get(i2);
                nid = RederMainFrame.keyNodeArray.indexOf(nd);
                this.nodeAccount = RederMainFrame.NodeList.get(nid);
                clone.add(this.nodeAccount);
            }
            RederMainFrame.NodeList.clear();
            RederMainFrame.NodeList = (ArrayList)clone.clone();
            clone.clear();
        }
        passingKeysArray = (ArrayList)RederMainFrame.keyNodeArray.clone();
        passingKeyHash = (HashMap)RederMainFrame.keyNodeHash.clone();
        RederMainFrame.keyNodeArray.clear();
        RederMainFrame.keyNodeHash.clear();
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            String name = this.nodeAccount.getNodeID();
            RederMainFrame.keyNodeArray.add(name);
            RederMainFrame.keyNodeHash.put(name, i);
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            String name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)RederMainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)RederMainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        this.updateBanks();
    }

    public void combinar(ArrayList<Integer> listaMarcados, Color groupColor) {
        int gn = 0;
        String groupName = "G" + gn;
        while (RederMainFrame.keyNodeHash.containsKey(groupName)) {
            groupName = "G" + ++gn;
        }
        RederMainFrame.NodeList.add(new NodeBank(groupName, RederMainFrame.NodeList.size()));
        int newGrupo = RederMainFrame.NodeList.size() - 1;
        RederMainFrame.keyNodeHash.put(groupName, newGrupo);
        RederMainFrame.keyNodeArray.add(groupName);
        NodeBank grupoAccount = RederMainFrame.NodeList.get(newGrupo);
        grupoAccount.setAsGroup(true);
        float areaGrupo = 0.0f;
        float xg = 0.0f;
        float yg = 0.0f;
        RederMainFrame.lockMouse = true;
        for (int i = 0; i < listaMarcados.size(); ++i) {
            int marcado = listaMarcados.get(i);
            this.nodeAccount = RederMainFrame.NodeList.get(marcado);
            if (this.nodeAccount.isGroup()) {
                grupoAccount.setGroupComponents(this.nodeAccount.getGroupComponets());
                grupoAccount.setGroupCompNumber(this.nodeAccount.getGroupCompNumber());
            } else {
                grupoAccount.setGroupComponents(this.nodeAccount.getNodeID());
            }
            xg += this.nodeAccount.getX();
            yg += this.nodeAccount.getY();
            for (int j = 0; j < this.nodeAccount.getParceiros().size(); ++j) {
                boolean c2;
                boolean c1;
                EdgeBank ref;
                int k;
                EdgeBank merge2;
                EdgeBank merge1;
                int parceiro = this.nodeAccount.getParceiros().get(j);
                boolean deposito = grupoAccount.addParceiro(parceiro);
                if (deposito) {
                    RederMainFrame.EdgeList.add(new EdgeBank(newGrupo, parceiro, RederMainFrame.EdgeList.size()));
                    merge1 = RederMainFrame.EdgeList.get(RederMainFrame.EdgeList.size() - 1);
                    merge2 = null;
                    for (k = 0; k < RederMainFrame.EdgeList.size(); ++k) {
                        ref = RederMainFrame.EdgeList.get(k);
                        c1 = ref.getA() == marcado && ref.getB() == parceiro;
                        boolean bl = c2 = ref.getB() == marcado && ref.getA() == parceiro;
                        if (!c1 && !c2) continue;
                        merge2 = ref;
                        break;
                    }
                    if (merge2 == null) continue;
                    merge1.setLineWidth(merge2.getWidth());
                    merge1.setDefaultEdgeAssignment(false);
                    continue;
                }
                merge1 = null;
                merge2 = null;
                for (k = RederMainFrame.EdgeList.size() - 1; k >= 0; --k) {
                    ref = RederMainFrame.EdgeList.get(k);
                    c1 = ref.getA() == newGrupo && ref.getB() == parceiro;
                    boolean bl = c2 = ref.getB() == newGrupo && ref.getA() == parceiro;
                    if (c1 || c2) {
                        merge1 = ref;
                        if (merge2 != null) break;
                    }
                    c1 = ref.getA() == marcado && ref.getB() == parceiro;
                    boolean bl2 = c2 = ref.getB() == marcado && ref.getA() == parceiro;
                    if (!c1 && !c2) continue;
                    merge2 = ref;
                    if (merge1 != null) break;
                }
                if (merge1 == null || merge2 == null) continue;
                merge1.setLineWidth(merge1.getWidth() + merge2.getWidth());
            }
            areaGrupo = (float)((double)areaGrupo + Math.pow(this.nodeAccount.getNodeSizeScale(), 2.0));
        }
        grupoAccount.setAliases(groupName + "[" + grupoAccount.getGroupComponets() + "]");
        grupoAccount.setNode(xg / (float)listaMarcados.size(), yg / (float)listaMarcados.size());
        grupoAccount.setGroupSize(areaGrupo);
        grupoAccount.setNodeColor(groupColor);
        grupoAccount.setNodeLineColor(groupColor);
        this.globalActionDeleteNode();
        listaMarcados.clear();
        RederMainFrame.lockMouse = false;
    }

    public void globalActionDeleteNode() {
        String name;
        int i;
        ArrayList<String> nodosRetirados = new ArrayList<String>();
        ArrayList passingKeysArray = new ArrayList();
        HashMap passingKeyHash = new HashMap();
        nodosRetirados.clear();
        passingKeysArray.clear();
        passingKeyHash.clear();
        RederMainFrame.lockMouse = true;
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.getDestaque() || !this.nodeAccount.isContainer()) continue;
            this.nodeAccount.setDestaque(true);
        }
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (!this.nodeAccount.getDestaque()) continue;
            nodosRetirados.add(this.nodeAccount.getNodeID());
            RederMainFrame.NodeList.remove(this.nodeAccount);
            --i;
        }
        passingKeysArray = (ArrayList)RederMainFrame.keyNodeArray.clone();
        passingKeyHash = (HashMap)RederMainFrame.keyNodeHash.clone();
        RederMainFrame.keyNodeArray.clear();
        RederMainFrame.keyNodeHash.clear();
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            name = this.nodeAccount.getNodeID();
            RederMainFrame.keyNodeArray.add(name);
            RederMainFrame.keyNodeHash.put(name, i);
        }
        for (i = 0; i < nodosRetirados.size(); ++i) {
            Integer numero = (Integer)passingKeyHash.get(nodosRetirados.get(i));
            for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
                this.edgeAccount = RederMainFrame.EdgeList.get(j);
                int a = this.edgeAccount.getA();
                int b = this.edgeAccount.getB();
                if (numero != a && numero != b) continue;
                RederMainFrame.EdgeList.remove(this.edgeAccount);
                --j;
            }
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            name = (String)passingKeysArray.get(this.edgeAccount.getA());
            Integer number = (Integer)RederMainFrame.keyNodeHash.get(name);
            if (number != null) {
                this.edgeAccount.setA(number);
            }
            if ((number = (Integer)RederMainFrame.keyNodeHash.get(name = (String)passingKeysArray.get(this.edgeAccount.getB()))) == null) continue;
            this.edgeAccount.setB(number);
        }
        passingKeysArray.clear();
        passingKeyHash.clear();
        nodosRetirados.clear();
        this.updateBanks();
        RederMainFrame.lockMouse = false;
    }

    public void addEdgesAndNodes(String nodeA, String nodeB, boolean defaultNestedCondition) {
        int flagSteps = 0;
        if (nodeA.equals("") || nodeB.equals("")) {
            String node = "";
            if (!nodeA.equals("")) {
                node = nodeA;
            }
            if (!nodeB.equals("")) {
                node = nodeB;
            }
            if (!RederMainFrame.keyNodeHash.containsKey(node) && !node.equals("")) {
                RederMainFrame.NodeList.add(new NodeBank(node, RederMainFrame.NodeList.size()));
                int addNode = RederMainFrame.NodeList.size() - 1;
                RederMainFrame.keyNodeHash.put(node, addNode);
                RederMainFrame.keyNodeArray.add(node);
                this.nodeAccount = RederMainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
            }
        } else if (!nodeA.equals("") && !nodeB.equals("")) {
            int numeroB;
            int numeroA;
            int addNode;
            boolean flagA = false;
            boolean flagB = false;
            if (!RederMainFrame.keyNodeHash.containsKey(nodeA)) {
                RederMainFrame.NodeList.add(new NodeBank(nodeA, RederMainFrame.NodeList.size()));
                addNode = RederMainFrame.NodeList.size() - 1;
                RederMainFrame.keyNodeHash.put(nodeA, addNode);
                RederMainFrame.keyNodeArray.add(nodeA);
                this.nodeAccount = RederMainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
                flagA = true;
                numeroA = addNode;
            } else {
                numeroA = (Integer)RederMainFrame.keyNodeHash.get(nodeA);
            }
            if (!RederMainFrame.keyNodeHash.containsKey(nodeB)) {
                RederMainFrame.NodeList.add(new NodeBank(nodeB, RederMainFrame.NodeList.size()));
                addNode = RederMainFrame.NodeList.size() - 1;
                RederMainFrame.keyNodeHash.put(nodeB, addNode);
                RederMainFrame.keyNodeArray.add(nodeB);
                this.nodeAccount = RederMainFrame.NodeList.get(addNode);
                this.nodeAccount.setNodeColor(Color.WHITE);
                flagB = true;
                numeroB = addNode;
            } else {
                numeroB = (Integer)RederMainFrame.keyNodeHash.get(nodeB);
            }
            if (numeroA != numeroB) {
                if (flagA || flagB) {
                    flagSteps = 1;
                } else {
                    int n = RederMainFrame.EdgeList.size();
                    boolean flagFound = false;
                    for (int i = 0; i < n && !flagFound; ++i) {
                        this.edgeAccount = RederMainFrame.EdgeList.get(i);
                        if ((this.edgeAccount.getA() != numeroA || this.edgeAccount.getB() != numeroB) && (this.edgeAccount.getA() != numeroB || this.edgeAccount.getB() != numeroA)) continue;
                        flagFound = true;
                    }
                    if (!flagFound) {
                        flagSteps = 1;
                    }
                }
            }
            if (flagSteps == 1) {
                NodeBank nodeAccountA = RederMainFrame.NodeList.get(numeroA);
                NodeBank nodeAccountB = RederMainFrame.NodeList.get(numeroB);
                boolean c1 = nodeAccountA.isContainer();
                boolean c2 = nodeAccountB.isContainer();
                if (c1 && defaultNestedCondition) {
                    if (nodeAccountB.isNodeNested()) {
                        int numeroRoot = RederMainFrame.keyNodeArray.indexOf(nodeAccountB.getNestedAssignment());
                        for (int j = 0; j < RederMainFrame.EdgeList.size(); ++j) {
                            this.edgeAccount = RederMainFrame.EdgeList.get(j);
                            int a = this.edgeAccount.getA();
                            int b = this.edgeAccount.getB();
                            if ((numeroB != a || numeroRoot != b) && (numeroRoot != a || numeroB != b)) continue;
                            RederMainFrame.EdgeList.remove(this.edgeAccount);
                            break;
                        }
                    }
                    RederMainFrame.EdgeList.add(0, new EdgeBank(numeroA, numeroB, RederMainFrame.EdgeList.size()));
                    this.edgeAccount = RederMainFrame.EdgeList.get(0);
                    this.edgeAccount.setLine(2.0f, "DOTTED");
                    this.edgeAccount.setEdgeColor(nodeAccountA.getNodeFillColor());
                    flagSteps = 2;
                } else if (!c1 && !c2) {
                    RederMainFrame.EdgeList.add(new EdgeBank(numeroA, numeroB, RederMainFrame.EdgeList.size()));
                    flagSteps = 2;
                } else {
                    RederMainFrame.EdgeList.add(new EdgeBank(numeroA, numeroB, RederMainFrame.EdgeList.size()));
                    RederMainFrame.EdgeList.get(RederMainFrame.EdgeList.size() - 1).setDefaultEdgeAssignment(false);
                    flagSteps = 2;
                }
            }
        }
        if (flagSteps == 2) {
            this.updateBanks();
        }
    }

    public void deleteSelectedEdges() {
        RederMainFrame.lockMouse = true;
        for (int i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            this.edgeAccount = RederMainFrame.EdgeList.get(i);
            if (!this.edgeAccount.getDestaque()) continue;
            NodeBank nodeAccoutA = RederMainFrame.NodeList.get(this.edgeAccount.getA());
            NodeBank nodeAccoutB = RederMainFrame.NodeList.get(this.edgeAccount.getB());
            boolean c1 = nodeAccoutA.isContainer();
            boolean c2 = !nodeAccoutA.getNestedAssignment().equals(nodeAccoutB.getNestedAssignment());
            boolean c3 = this.edgeAccount.isDefaultEdgeAssignmet();
            boolean c4 = nodeAccoutA.isNodeNested();
            if (c1 && c2 && c3) {
                if (c4) {
                    int number = RederMainFrame.keyNodeArray.indexOf(nodeAccoutA.getNestedAssignment());
                    this.edgeAccount.setA(number);
                    this.edgeAccount.setEdgeColor(RederMainFrame.NodeList.get(number).getNodeFillColor());
                    continue;
                }
                this.edgeAccount.setDefaultEdgeAssignment(false);
                continue;
            }
            RederMainFrame.EdgeList.remove(this.edgeAccount);
            --i;
        }
        this.updateBanks();
        RederMainFrame.lockMouse = false;
    }

    public boolean isRelaxActive() {
        return RederMainFrame.isRelaxActive;
    }

    public void stopRelax() {
        RederMainFrame.activateRelaxDcall = false;
        RederMainFrame.isRelaxActive = false;
    }

    public void startRelax() {
        RederMainFrame.activateRelaxDcall = true;
    }

    public void stopPaint() {
        RederMainFrame.isPaintActive = false;
    }

    public void startPaint() {
        RederMainFrame.isPaintActive = true;
    }

    public void resetCooling() {
        RederMainFrame.temperature = 1.0;
    }

    public void updateRelaxPanel() {
        RederMainFrame.updateRelaxPanel = true;
    }

    public void setRelaxArgs(double att1, double att2, double att3, double att4, double att5, double att6, double att7, double att8, double att9) {
        RederMainFrame.setRelaxArgs(att1, att2, att3, att4, att5, att6, att7, att8, att9);
        this.updateRelaxPanel();
    }

    public void zeraZoom() {
        double focoX = RederMainFrame.drawpanel.getWidth() / 2;
        double focoY = RederMainFrame.drawpanel.getHeight() / 2;
        int size = RederMainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.resetZoom(pontos, RederMainFrame.getZoom(), focoX, focoY);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNodeToSave(x, y);
        }
    }

    public Point2D[] redoZoomScaleFromR(Point2D[] pontos) {
        double flip = 0.0;
        double fator = 0.0;
        if (RederMainFrame.getZoom() < 1.0) {
            flip = 1.0;
            fator = 1.0 - RederMainFrame.getZoom();
        } else if (RederMainFrame.getZoom() > 1.0) {
            flip = -1.0;
            fator = RederMainFrame.getZoom() - 1.0;
        }
        if (flip == 0.0) {
            return pontos;
        }
        double focoX = RederMainFrame.drawpanel.getWidth() / 2;
        double focoY = RederMainFrame.drawpanel.getHeight() / 2;
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        return pontos;
    }

    public void setZoom(double newZoom) {
        if ((newZoom /= 100.0) <= 0.0) {
            newZoom = 0.01;
        }
        double oldZoom = RederMainFrame.getZoom();
        double flip = 0.0;
        if (newZoom < oldZoom) {
            flip = 1.0;
        } else if (newZoom > oldZoom) {
            flip = -1.0;
        }
        if (flip == 0.0) {
            return;
        }
        double fator = flip * (-newZoom + oldZoom) / oldZoom;
        RederMainFrame.setZoom(newZoom);
        double focoX = RederMainFrame.drawpanel.getWidth() / 2;
        double focoY = RederMainFrame.drawpanel.getHeight() / 2;
        int size = RederMainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        RederMainFrame.drawpanel.setZoom((float)newZoom);
    }

    public Point2D[] setCenterFromR(Point2D[] pontos, double gX, double gY) {
        double focoX = (double)RederMainFrame.drawpanel.getWidth() * (gX /= 100.0);
        double focoY = (double)RederMainFrame.drawpanel.getHeight() * (gY /= 100.0);
        Zoom zm = new Zoom();
        pontos = zm.setCenter(pontos, focoX, focoY);
        return pontos;
    }

    public void fitToWindow(double scale) {
        int sz = RederMainFrame.NodeList.size();
        if (sz == 0) {
            return;
        }
        double focoX = RederMainFrame.drawpanel.getWidth() / 2;
        double focoY = RederMainFrame.drawpanel.getHeight() / 2;
        this.actionSetCenter(focoX, focoY);
        if (sz == 1) {
            RederMainFrame.updateGraph();
            return;
        }
        if (sz < 10) {
            scale *= 0.9;
        }
        double maxx = 0.0;
        double maxy = 0.0;
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            double nx = this.nodeAccount.getX();
            double ny = this.nodeAccount.getY();
            if (nx > maxx) {
                maxx = nx;
            }
            if (!(ny > maxy)) continue;
            maxy = ny;
        }
        double w = focoX * scale;
        double h = focoY * scale;
        double dw = maxx - focoX;
        double dh = maxy - focoY;
        if (dw > w || dh > h) {
            double flip = 1.0;
            dw = (dw - w) / dw;
            dh = (dh - h) / dh;
            double fator = Math.max(dw, dh);
            this.actionFit(flip, focoX, focoY, fator);
        } else if (dw < w && dh < h) {
            double flip = -1.0;
            dw = (w - dw) / dw;
            dh = (h - dh) / dh;
            double fator = Math.min(dw, dh);
            this.actionFit(flip, focoX, focoY, fator);
        }
    }

    private void actionSetCenter(double focoX, double focoY) {
        int size = RederMainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setCenter(pontos, focoX, focoY);
        for (int i = 0; i < pontos.length; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
    }

    private void actionFit(double flip, double focoX, double focoY, double fator) {
        double zoomInOut = RederMainFrame.getZoom() - flip * (RederMainFrame.getZoom() * fator);
        int size = RederMainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, zoomInOut, focoX, focoY);
            zoomInOut = 1.0;
        }
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        RederMainFrame.setZoom(zoomInOut);
        RederMainFrame.drawpanel.setZoom((float)zoomInOut);
        RederMainFrame.updateGraph();
    }

    public String duplicateNetwork(boolean isToCopyEdges, boolean isDefaultCopy) {
        int b;
        EdgeBank originalAccount;
        int a;
        int i;
        RederMainFrame.lockMouse = true;
        RederMainFrame.originalMarcados = new ArrayList();
        RederMainFrame.newMarcados = new ArrayList();
        RederMainFrame.originalMarcados.clear();
        RederMainFrame.newMarcados.clear();
        ArrayList<String> testaMarcados = new ArrayList<String>();
        testaMarcados.clear();
        int lowestTreeLevel = 10000000;
        int destaques = 0;
        boolean isContainer = false;
        for (int i2 = 0; i2 < RederMainFrame.NodeList.size(); ++i2) {
            this.nodeAccount = RederMainFrame.NodeList.get(i2);
            if (!this.nodeAccount.getDestaque()) continue;
            if (lowestTreeLevel > this.nodeAccount.getNodeLevel()) {
                lowestTreeLevel = this.nodeAccount.getNodeLevel();
                destaques = 1;
                isContainer = this.nodeAccount.isContainer();
                continue;
            }
            if (this.nodeAccount.getNodeLevel() != lowestTreeLevel) continue;
            ++destaques;
        }
        if (destaques == 0) {
            this.selectAllNodes();
            lowestTreeLevel = 0;
        } else if (destaques == 1 && !isContainer) {
            RederMainFrame.lockMouse = false;
            return "null";
        }
        int refcon = -1;
        for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            NodeBank oldAccount = RederMainFrame.NodeList.get(i);
            if (!oldAccount.getDestaque() || oldAccount.getNodeLevel() > lowestTreeLevel) continue;
            if (oldAccount.isContainer()) {
                refcon = oldAccount.duplicateContainer(oldAccount.getNestedAssignment(), isDefaultCopy);
                continue;
            }
            String cleanName = this.cleanNome(oldAccount.getNodeID());
            int teste = testaMarcados.indexOf(cleanName);
            if (teste >= 0) continue;
            testaMarcados.add(cleanName);
            int cc = (Integer)RederMainFrame.keyNodeHash.get(oldAccount.getNodeID());
            RederMainFrame.originalMarcados.add(cc);
            String copynode = this.getNomeProvisorio(oldAccount.getNodeID());
            RederMainFrame.NodeList.add(new NodeBank(copynode, RederMainFrame.NodeList.size()));
            RederMainFrame.keyNodeHash.put(copynode, RederMainFrame.NodeList.size() - 1);
            RederMainFrame.keyNodeArray.add(copynode);
            RederMainFrame.newMarcados.add(RederMainFrame.NodeList.size() - 1);
            NodeBank nodeCopyAccount = RederMainFrame.NodeList.get(RederMainFrame.NodeList.size() - 1);
            this.transferNodeAttribs(oldAccount, nodeCopyAccount, oldAccount.getNestedAssignment());
        }
        if (RederMainFrame.newMarcados.size() == 1 && (a = RederMainFrame.newMarcados.get(0).intValue()) >= 0 && a <= RederMainFrame.NodeList.size()) {
            this.deSelectNodes();
            RederMainFrame.NodeList.get(a).setDestaque(true);
            this.globalActionDeleteNode();
            RederMainFrame.lockMouse = false;
            return "null";
        }
        for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
            originalAccount = RederMainFrame.EdgeList.get(i);
            if (!isToCopyEdges && isDefaultCopy && !originalAccount.getEdgeAssociationType().equals("edgeTree")) continue;
            int a2 = originalAccount.getA();
            b = originalAccount.getB();
            int testa = RederMainFrame.originalMarcados.indexOf(a2);
            int testb = RederMainFrame.originalMarcados.indexOf(b);
            if (testa == -1 || testb == -1) continue;
            testa = RederMainFrame.newMarcados.get(testa);
            testb = RederMainFrame.newMarcados.get(testb);
            RederMainFrame.EdgeList.add(new EdgeBank(testa, testb, RederMainFrame.EdgeList.size()));
            EdgeBank copyAccount = RederMainFrame.EdgeList.get(RederMainFrame.EdgeList.size() - 1);
            this.transferEdgeAttribs(originalAccount, copyAccount);
        }
        this.updateBanks();
        if (!isToCopyEdges && !isDefaultCopy) {
            this.deSelectEdges();
            for (i = 0; i < RederMainFrame.EdgeList.size(); ++i) {
                int rb;
                int ra;
                originalAccount = RederMainFrame.EdgeList.get(i);
                if (originalAccount.getEdgeAssociationType().equals("edgeTree")) continue;
                int a3 = originalAccount.getA();
                b = originalAccount.getB();
                if (RederMainFrame.NodeList.get(a3).isCopy() || RederMainFrame.NodeList.get(b).isCopy() || (ra = RederMainFrame.NodeList.get(a3).getNestedAssignmentIndx()) >= 0 && RederMainFrame.NodeList.get(ra).isCopy() || (rb = RederMainFrame.NodeList.get(b).getNestedAssignmentIndx()) >= 0 && RederMainFrame.NodeList.get(rb).isCopy()) continue;
                int testa = RederMainFrame.newMarcados.indexOf(a3);
                int testb = RederMainFrame.newMarcados.indexOf(b);
                if (testa != -1 || testb != -1) continue;
                originalAccount.setDestaque(true);
            }
            this.deleteSelectedEdges();
        }
        if (RederMainFrame.newMarcados.size() > 1) {
            NodeBank newContainer;
            String res = this.aninhar(RederMainFrame.newMarcados, this.HexToColor("E6E6FFFF"), false, false, false, true);
            if (res.startsWith("N")) {
                refcon = (Integer)RederMainFrame.keyNodeHash.get(res);
                newContainer = RederMainFrame.NodeList.get(refcon);
                newContainer.setAnchored(true);
                newContainer.setAsCopy();
                float newX = newContainer.getX() + newContainer.getW() * (float)RederMainFrame.getZoom() * (float)newContainer.getRelativeSize();
                if (isDefaultCopy) {
                    newContainer.moveTree(newX, newContainer.getY());
                } else {
                    float oldX = newContainer.getX();
                    this.moveOriginalNetwork(newX - oldX);
                }
                this.deSelectNodes();
                this.deSelectEdges();
                RederMainFrame.lockMouse = false;
                return res;
            }
            if (refcon >= 0) {
                newContainer = RederMainFrame.NodeList.get(refcon);
                newContainer.setAnchored(true);
                newContainer.setAsCopy();
                float newX = newContainer.getX() + newContainer.getW() * (float)RederMainFrame.getZoom() * (float)newContainer.getRelativeSize();
                if (isDefaultCopy) {
                    newContainer.moveTree(newX, newContainer.getY());
                } else {
                    float oldX = newContainer.getX();
                    this.moveOriginalNetwork(oldX - newX);
                }
                this.deSelectNodes();
                this.deSelectEdges();
                RederMainFrame.lockMouse = false;
                return newContainer.getNodeID();
            }
            RederMainFrame.lockMouse = false;
            return "null";
        }
        RederMainFrame.lockMouse = false;
        return "null";
    }

    private void moveOriginalNetwork(float dx) {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (this.nodeAccount.isCopy() || this.nodeAccount.isNodeNested()) continue;
            if (this.nodeAccount.isContainer()) {
                this.nodeAccount.moveTree(this.nodeAccount.getX() + dx, this.nodeAccount.getY());
                continue;
            }
            this.nodeAccount.setX(this.nodeAccount.getX() + dx);
        }
    }

    public void transferNodeAttribs(NodeBank originalAccount, NodeBank copyAccount, String nestAssigment) {
        if (!originalAccount.isContainer()) {
            copyAccount.setAliases(originalAccount.getAliases());
        }
        copyAccount.setFont(originalAccount.getFont());
        copyAccount.setFontColor(originalAccount.getNodeFontColor());
        copyAccount.setFontSize(originalAccount.getFontSize());
        copyAccount.setFontOffsetX(originalAccount.getFontOffsetX());
        copyAccount.setFontOffsetY(originalAccount.getFontOffsetY());
        if (originalAccount.isContainer()) {
            copyAccount.setContainer(true);
            copyAccount.setAnchored(originalAccount.isAnchored());
            copyAccount.setContainerHided(originalAccount.isContainerHided());
            copyAccount.setContainerTransparent(originalAccount.isContainerTransparent());
        }
        copyAccount.setNodeNested(nestAssigment);
        if (originalAccount.isGroup()) {
            copyAccount.setAsGroup(true);
            copyAccount.setGroupCompNumber(originalAccount.getGroupCompNumber());
            copyAccount.setGroupComponents(originalAccount.getGroupComponets());
            copyAccount.setAsGroup(originalAccount.isGroup());
        }
        copyAccount.setNodeBend(originalAccount.getNodeBend());
        copyAccount.setNodeColor(originalAccount.getNodeFillColor());
        copyAccount.setNodeGradient(originalAccount.isNodeGradient());
        copyAccount.setNodeLineColor(originalAccount.getNodeLineColor());
        copyAccount.setNodeLineWidth(originalAccount.getNodeLineWidth());
        copyAccount.setNodeShape(originalAccount.getNodeShape());
        copyAccount.setNodeLineType(originalAccount.getNodeLineType());
        copyAccount.setNodeSizeScale(originalAccount.getNodeSizeScale());
        copyAccount.setWeight(originalAccount.getNodeWeight());
        copyAccount.setNode(originalAccount.getX(), originalAccount.getY());
        copyAccount.setAsCopy();
    }

    public String getNomeProvisorio(String node) {
        Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
        Matcher mt = pt.matcher(node);
        node = mt.matches() ? mt.group(1) + ".$N001" : node + ".$N001";
        return node;
    }

    public void transferEdgeAttribs(EdgeBank originalAccount, EdgeBank copyAccount) {
        copyAccount.setArrowDirection(originalAccount.getArrowDirection());
        copyAccount.setEdgeColor(originalAccount.getEdgeColor());
        copyAccount.setWeight(originalAccount.getMeanWeight());
        copyAccount.setLineType(originalAccount.getType());
        copyAccount.setLineWidth(originalAccount.getWidth());
        copyAccount.setOutEdge(originalAccount.isOutEdge());
        copyAccount.setDefaultEdgeAssignment(originalAccount.isDefaultEdgeAssignmet());
    }

    private String cleanNome(String node) {
        Pattern pt = Pattern.compile("(.*)\\.\\$N[\\d]+");
        Matcher mt = pt.matcher(node);
        if (mt.matches()) {
            node = mt.group(1);
        }
        return node;
    }

    public void setBackground(Color newColor) {
        if (newColor != null) {
            RederMainFrame.backgroundColor = newColor;
            RederMainFrame.drawpanel.setBackground(newColor);
        }
    }

    public void exitred() {
        exitred taskexit = new exitred();
        taskexit.execute();
    }

    public int addLegendSize(List<Float> sizevec, List<String> labvec, List<Color> colvec, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype, float edgelen) {
        int nnodes = sizevec.size();
        this.clearLegend(legtype);
        float maxLabLength = 0.0f;
        float a = 0.0f;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            if (a < sizevec.get(i).floatValue()) {
                a = sizevec.get(i).floatValue();
            }
            b = b + sizevec.get(i).floatValue() + interspace;
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        float totalH = a;
        float totalW = b;
        if (isVertical) {
            totalH = b;
            totalW = a;
        }
        float maxH = Math.min(a, b);
        float maxW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = RederMainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            RederMainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = RederMainFrame.LegendList.get(legID);
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgewidth")) {
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(sizevec.get(i).floatValue(), sizevec.get(i).floatValue(), edgelen);
                    totalW = edgelen;
                    maxW = edgelen;
                } else {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(sizevec.get(i).floatValue(), edgelen, sizevec.get(i).floatValue());
                    totalH = edgelen;
                    maxH = edgelen;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f);
                legendAccount.setLegSize(sizevec.get(i).floatValue());
            }
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
        }
        this.updateLegendOnLoad();
        return 1;
    }

    public int addLegendColor(List<Color> colvec, List<String> labvec, float size, float bend, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int i;
        float totalW;
        float totalH;
        int nnodes = colvec.size();
        float legbend = bend;
        if (isVertical) {
            legbend = 100.0f - bend;
        }
        this.clearLegend(legtype);
        float maxH = size * (0.5f + legbend / 100.0f);
        float maxW = size * (1.0f + (0.5f - legbend / 100.0f));
        if (isVertical) {
            totalH = maxH * (float)nnodes;
            totalW = maxW;
        } else {
            totalH = maxH;
            totalW = maxW * (float)nnodes;
        }
        float maxLabLength = 0.0f;
        for (i = 0; i < nnodes; ++i) {
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        for (i = 0; i < nnodes; ++i) {
            int legID = RederMainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            RederMainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = RederMainFrame.LegendList.get(legID);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setLegSize(size, maxH, maxW);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegBend(bend);
            legendAccount.setLegType(legtype);
            legendAccount.setLegShape("RECTANGLE");
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setNodeLineWidth(0.5f);
        }
        this.updateLegendOnLoad();
        return 1;
    }

    public int addLegendShape(List<String> shapevec, List<String> labvec, List<Color> colvec, float size, float interspace, int ftsize, String labx, float labxdist, String panelposition, float dxborder, float dyborder, boolean isVertical, String legtype) {
        int nnodes = shapevec.size();
        this.clearLegend(legtype);
        float a = size;
        float b = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            b = b + size + interspace;
        }
        float totalH = a;
        float totalW = b;
        if (isVertical) {
            totalH = b;
            totalW = a;
        }
        float maxLabLength = 0.0f;
        for (int i = 0; i < nnodes; ++i) {
            String legalias = labvec.get(i);
            if (!(maxLabLength < (float)legalias.length())) continue;
            maxLabLength = legalias.length();
        }
        float maxH = Math.min(a, b);
        float maxW = Math.min(a, b);
        for (int i = 0; i < nnodes; ++i) {
            int legID = RederMainFrame.LegendList.size();
            String legname = "leg" + legID;
            String legalias = labvec.get(i);
            RederMainFrame.LegendList.add(new LegendBank(legname, legID));
            LegendBank legendAccount = RederMainFrame.LegendList.get(legID);
            legendAccount.setMaxLabLength(Float.valueOf(maxLabLength));
            legendAccount.setAliases(legalias);
            legendAccount.setLabx(labx);
            legendAccount.setLabxDist(labxdist);
            legendAccount.setFontSize(ftsize);
            legendAccount.setNodeColor(colvec.get(i));
            legendAccount.setNodeLineColor(colvec.get(i));
            legendAccount.setLegType(legtype);
            if (legtype.equals("edgeshape")) {
                float len = 55.0f;
                if (isVertical) {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(size, size, len);
                    totalW = len;
                    maxW = len;
                } else {
                    legendAccount.setNode(0.0f, 0.0f);
                    legendAccount.setLegSize(size, len, size);
                    totalH = len;
                    maxH = len;
                }
            } else {
                legendAccount.setNode(0.0f, 0.0f);
                legendAccount.setLegSize(size);
            }
            legendAccount.setLegShape(shapevec.get(i));
            legendAccount.setDim(totalH, totalW, maxH, maxW);
            legendAccount.setMembership(i);
            legendAccount.setVertical(isVertical);
            legendAccount.setPanelPosition(panelposition);
            legendAccount.setDistBorder(dxborder, dyborder);
            legendAccount.setInterSpace(interspace);
            legendAccount.setNodeLineWidth(0.5f);
        }
        this.updateLegendOnLoad();
        return 1;
    }

    public void updateLegendOnLoad() {
        for (int i = 0; i < RederMainFrame.LegendList.size(); ++i) {
            LegendBank legendAccount = RederMainFrame.LegendList.get(i);
            legendAccount.realocateMembers();
            Font ft = new Font(legendAccount.getFont().getFontName(), 1, legendAccount.getFont().getSize() + 2);
            FontMetrics fm_large = RederMainFrame.drawpanel.getFontMetrics(ft);
            Rectangle2D st = fm_large.getStringBounds(legendAccount.getLabx(), RederMainFrame.drawpanel.getGraphics());
            legendAccount.setTitleWidth((float)st.getWidth());
            legendAccount.setTitleHeight((float)st.getHeight());
        }
    }

    public void clearLegend(String type) {
        LegendBank legAccount;
        int i;
        for (i = 0; i < RederMainFrame.LegendList.size(); ++i) {
            legAccount = RederMainFrame.LegendList.get(i);
            String tp = legAccount.getLegType();
            if (!tp.equals(type)) continue;
            RederMainFrame.LegendList.remove(i);
            --i;
        }
        for (i = 0; i < RederMainFrame.LegendList.size(); ++i) {
            legAccount = RederMainFrame.LegendList.get(i);
            legAccount.resetId(i);
        }
    }

    public int zoomNodeFilter(String nodeA, String nt) {
        for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            if (nt != null) {
                if (!this.nodeAccount.isNodeNested()) continue;
                int nrt = RederMainFrame.keyNodeArray.indexOf(this.nodeAccount.getNestedAssignment());
                String roodId = RederMainFrame.NodeList.get(nrt).getNodeID();
                String roodAlias = RederMainFrame.NodeList.get(nrt).getAliases();
                if (!roodId.equals(nt) || !roodAlias.equals(nt)) continue;
            }
            boolean matchID = nodeA.equals(this.nodeAccount.getNodeID());
            boolean matchAlias = nodeA.equals(this.nodeAccount.getAliases());
            if (!matchID && !matchAlias) continue;
            this.stopRelax();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.taskFilterlZoom(i);
            break;
        }
        return 0;
    }

    public void taskFilterlZoom(int nodefound) {
        if (this.taskFilterZoom != null && !this.taskFilterZoom.isCancelled()) {
            this.taskFilterZoom.cancel(true);
        }
        this.nodeAccountFound = RederMainFrame.NodeList.get(nodefound);
        if (this.nodeAccountFound.isContainer() && this.nodeAccountFound.getRelativeSize() != 1.0) {
            this.zoomContainer(0.0, 0.0, this.nodeAccountFound);
        }
        this.taskFilterZoom = new tarefaFilterZoom();
        this.taskFilterZoom.execute();
        while (!this.taskFilterZoom.isDone()) {
        }
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void setFilterZoom(double flip, double focoX, double focoY, double vlox) {
        if (flip == 0.0) {
            return;
        }
        double fator = vlox;
        double zoomInOut = RederMainFrame.getZoom() - flip * (RederMainFrame.getZoom() * fator);
        RederMainFrame.setZoom(zoomInOut);
        int size = RederMainFrame.NodeList.size();
        Point2D[] pontos = new Point2D[size];
        for (int i = 0; i < size; ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        for (int i = 0; i < size; ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(i);
            this.nodeAccount.setNode(x, y);
        }
        RederMainFrame.drawpanel.setZoom((float)zoomInOut);
    }

    private void zoomContainer(double flip, double fator, NodeBank containerAccount) {
        if (containerAccount == null) {
            return;
        }
        if (!containerAccount.isContainer()) {
            return;
        }
        double focoX = containerAccount.getX();
        double focoY = containerAccount.getY();
        double rsz = containerAccount.getRelativeSize();
        if (rsz < 0.25 && flip == 1.0) {
            return;
        }
        rsz -= flip * (rsz * fator);
        ArrayList<Integer> cc = containerAccount.getTreeComponents();
        Point2D[] pontos = new Point2D[cc.size()];
        for (int i = 0; i < cc.size(); ++i) {
            this.nodeAccount = RederMainFrame.NodeList.get(cc.get(i));
            pontos[i] = this.nodeAccount.getPoint();
        }
        Zoom zm = new Zoom();
        if (flip != 0.0) {
            pontos = zm.setZoom(pontos, flip, focoX, focoY, fator);
        } else {
            pontos = zm.resetZoom(pontos, rsz, focoX, focoY);
            rsz = 1.0;
        }
        for (int i = 0; i < cc.size(); ++i) {
            float x = (float)pontos[i].getX();
            float y = (float)pontos[i].getY();
            this.nodeAccount = RederMainFrame.NodeList.get(cc.get(i));
            this.nodeAccount.setNode(x, y);
        }
        containerAccount.setRelativeSize(rsz);
    }

    public Color HexToColor(String hex) {
        hex = hex.replace("#", "");
        switch (hex.length()) {
            case 6: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
            }
            case 8: {
                return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
            }
        }
        return null;
    }

    public String ColorToHex(Color color) {
        String hex = String.format("%02x%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        return hex;
    }

    class tarefaFilterZoom
    extends SwingWorker<Void, Void> {
        tarefaFilterZoom() {
        }

        @Override
        public Void doInBackground() throws InterruptedException {
            double nodsz = (double)Methods.this.nodeAccountFound.getW() * RederMainFrame.getZoom() * Methods.this.nodeAccountFound.getRelativeSize();
            float targetpx = (float)RederMainFrame.drawpanel.getWidth() / 2.0f;
            float targetpy = (float)RederMainFrame.drawpanel.getHeight() / 2.0f;
            float targetsz = (targetpx + targetpy) / 30.0f;
            if (Methods.this.nodeAccountFound.isContainer()) {
                targetsz *= 7.0f;
            }
            float dx = targetpx - Methods.this.nodeAccountFound.getX();
            float dy = targetpy - Methods.this.nodeAccountFound.getY();
            double dz = (double)targetsz - nodsz;
            float speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
            float evolx = Math.abs(dx) / speeds * speeds * 0.1f;
            float evoly = Math.abs(dy) / speeds * speeds * 0.1f;
            double evolz = Math.abs(dz) / (double)speeds * (double)speeds * 0.1;
            boolean andaz = false;
            boolean andax = false;
            boolean anday = false;
            boolean anda = !andax || !anday || !andaz;
            double ksteps = 0.0;
            while (anda && ksteps < 500.0) {
                float flip;
                ksteps += 1.0;
                if (!andaz) {
                    flip = dz <= 0.0 ? 1.0f : (dz > 0.0 ? -1.0f : 0.0f);
                    evolz = Math.min(0.05, evolz);
                    Methods.this.setFilterZoom(flip, Methods.this.nodeAccountFound.getX(), Methods.this.nodeAccountFound.getY(), evolz);
                }
                if (Math.abs(dz = (double)targetsz - (nodsz = (double)Methods.this.nodeAccountFound.getW() * RederMainFrame.getZoom() * Methods.this.nodeAccountFound.getRelativeSize())) <= (double)(targetsz / 20.0f)) {
                    andaz = true;
                }
                for (int i = 0; i < RederMainFrame.NodeList.size(); ++i) {
                    Methods.this.nodeAccount = RederMainFrame.NodeList.get(i);
                    if (!andax) {
                        flip = dx < 0.0f ? -1.0f : (dx > 0.0f ? 1.0f : 0.0f);
                        Methods.this.nodeAccount.setX(Methods.this.nodeAccount.getX() + evolx * flip);
                    }
                    if (anday) continue;
                    flip = dy < 0.0f ? -1.0f : (dy > 0.0f ? 1.0f : 0.0f);
                    Methods.this.nodeAccount.setY(Methods.this.nodeAccount.getY() + evoly * flip);
                }
                dx = targetpx - Methods.this.nodeAccountFound.getX();
                if (Math.abs(dx) <= 20.0f) {
                    andax = true;
                }
                if (Math.abs(dy = targetpy - Methods.this.nodeAccountFound.getY()) <= 20.0f) {
                    anday = true;
                }
                if (RederMainFrame.isPaintActive) {
                    RederMainFrame.drawpanel.repaint();
                }
                Thread.sleep(30L);
                speeds = (float)((double)(Math.abs(dx) + Math.abs(dy)) + Math.abs(dz));
                evolx = Math.abs(dx) / speeds * speeds * 0.1f;
                evoly = Math.abs(dy) / speeds * speeds * 0.1f;
                evolz = Math.abs(dz) / (double)speeds;
                boolean bl = anda = !andax || !anday || !andaz;
                if (Methods.this.nodeAccountFound != null) continue;
                anda = false;
            }
            return null;
        }

        @Override
        public void done() {
            if (Methods.this.nodeAccountFound != null) {
                Methods.this.nodeAccountFound.setDestaque(true);
                Methods.this.globalChangeOrder("forward");
                if (Methods.this.nodeAccountFound.isContainer()) {
                    if (RederMainFrame.isPaintActive) {
                        RederMainFrame.drawpanel.repaint();
                    }
                } else {
                    Methods.this.taskHighlight();
                }
            }
            if (Methods.this.taskFilterZoom != null && !Methods.this.taskFilterZoom.isCancelled()) {
                Methods.this.taskFilterZoom.cancel(true);
            }
        }
    }

    class exitred
    extends SwingWorker<Void, Void> {
        exitred() {
        }

        @Override
        public Void doInBackground() throws InterruptedException {
            Thread.sleep(30L);
            return null;
        }

        @Override
        public void done() {
            System.exit(0);
        }
    }

    class tarefaHighlight
    extends SwingWorker<Void, Void> {
        tarefaHighlight() {
        }

        @Override
        public Void doInBackground() throws IOException {
            double sz;
            int i;
            ArrayList<Integer> listaMarcados = new ArrayList<Integer>();
            listaMarcados.clear();
            double zn = RederMainFrame.getZoom();
            for (i = 0; i < RederMainFrame.NodeList.size(); ++i) {
                Methods.this.nodeAccount = RederMainFrame.NodeList.get(i);
                if (!Methods.this.nodeAccount.getDestaque()) continue;
                listaMarcados.add(i);
            }
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < listaMarcados.size(); ++j) {
                    Methods.this.nodeAccount = RederMainFrame.NodeList.get((Integer)listaMarcados.get(j));
                    sz = (double)Methods.this.nodeAccount.getNodeSizeScale() * zn;
                    Methods.this.nodeAccount.setHighlightSize(Methods.this.nodeAccount.getHighlightSize() + (double)i / 100.0 / sz);
                }
                if (RederMainFrame.isPaintActive) {
                    RederMainFrame.drawpanel.repaint();
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException j) {
                    // empty catch block
                }
            }
            for (i = 0; i < 10; ++i) {
                for (int j = 0; j < listaMarcados.size(); ++j) {
                    Methods.this.nodeAccount = RederMainFrame.NodeList.get((Integer)listaMarcados.get(j));
                    sz = (double)Methods.this.nodeAccount.getNodeSizeScale() * zn;
                    Methods.this.nodeAccount.setHighlightSize(Methods.this.nodeAccount.getHighlightSize() - (double)i / 100.0 / sz);
                    if (i != 9) continue;
                    Methods.this.nodeAccount.setHighlightSize(1.0);
                }
                if (RederMainFrame.isPaintActive) {
                    RederMainFrame.drawpanel.repaint();
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

