## ----echo=FALSE---------------------------------------------------------
options(width=74)

## -----------------------------------------------------------------------
library(RMassBank)
library(RMassBankData)

## ----echo=TRUE,eval=TRUE------------------------------------------------
RmbDefaultSettings()
rmbo <- getOption("RMassBank")
rmbo$spectraList <- list(
  list(mode="CID", ces="10eV", ce="10eV", res=12000),
  list(mode="CID", ces="20eV", ce="20eV", res=12000)
)

rmbo$multiplicityFilter <- 1
rmbo$annotations$instrument <- "Bruker micrOTOFq"
rmbo$annotations$instrument_type <- "LC-ESI-QTOF"
rmbo$recalibrator$MS1 <- "recalibrate.identity"
rmbo$recalibrator$MS2 <- "recalibrate.identity"
options("RMassBank" = rmbo)



## -----------------------------------------------------------------------
msmsList <- newMsmsWorkspace()

## -----------------------------------------------------------------------
msmsList@files <- list.files(system.file("spectra.Glucolesquerellin",
                                         package = "RMassBankData"),
                             "Glucolesquerellin.*mzML", full.names=TRUE)

## -----------------------------------------------------------------------
loadList(system.file("list/PlantDataset.csv",package="RMassBankData"))

## ----eval=TRUE----------------------------------------------------------
Args <- list(method="centWave",
                     peakwidth=c(5,12),
                     prefilter=c(0,0),
                     ppm=25, snthr=2)

## ----echo=FALSE,eval=TRUE-----------------------------------------------
par(mfcol=c(2,2))

## ----eval=TRUE, fig=TRUE------------------------------------------------
msmsList <- msmsRead(msmsList, files= msmsList@files, 
                     readMethod = "xcms", mode = "mH", Args = Args, plots = TRUE)
msmsList <- msmsWorkflow(msmsList, steps=2:8,
                         mode="mH", readMethod="xcms")

## -----------------------------------------------------------------------
mb <- newMbWorkspace(msmsList)
mb <- resetInfolists(mb)
mb <- loadInfolist(mb,system.file("infolists/PlantDataset.csv",
                                  package = "RMassBankData"))
# Step
mb <- mbWorkflow(mb, steps=1:8)

## ----eval=TRUE----------------------------------------------------------
msmsPeaklist <- newMsmsWorkspace()
msmsPeaklist@files <- list.files(system.file("spectra.Glucolesquerellin",
                                             package = "RMassBankData"),
                                 "Glucolesquerellin.*csv", full.names=TRUE)
msmsPeaklist <- msmsWorkflow(msmsPeaklist, steps=1:8,
                             mode="mH", readMethod="peaklist")

## -----------------------------------------------------------------------
sessionInfo()

