## ----setup, include=FALSE-----------------------------------------------------
library(NanoMethViz)
library(ggplot2)
knitr::opts_chunk$set(echo = TRUE)

## ---- message = FALSE---------------------------------------------------------
library(NanoMethViz)
# import example NanoMethResult object
nmr <- load_example_nanomethresult()
nmr

# convert to bsseq
bss <- methy_to_bsseq(nmr)
bss

## -----------------------------------------------------------------------------
# create gene annotation from exon annotation
gene_anno <- exons_to_genes(NanoMethViz::exons(nmr))

# create log-methylation-ratio matrix
lmr <- bsseq_to_log_methy_ratio(bss, regions = gene_anno)

## -----------------------------------------------------------------------------
plot_mds(lmr) +
    ggtitle("MDS Plot")

plot_pca(lmr) +
    ggtitle("PCA Plot")

## -----------------------------------------------------------------------------
new_labels <- gsub("B6Cast_Prom_", "", colnames(lmr))
new_labels <- gsub("(\\d)_(.*)", "\\2 \\1", new_labels)
groups <- gsub(" \\d", "", new_labels)

plot_mds(lmr, labels = new_labels, groups = groups) +
    ggtitle("MDS Plot") +
    scale_colour_brewer(palette = "Set1")

