## ----setup, include = FALSE---------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----workflow, echo=FALSE, fig.align='center', fig.cap='FLAMES pipeline workflow summary'----
knitr::include_graphics(system.file("images/FLAMESpipeline-01.png", package="FLAMES"))

## ----eval=TRUE, echo=TRUE-----------------------------------------------------
temp_path <- tempfile()
bfc <- BiocFileCache::BiocFileCache(temp_path, ask=FALSE)
file_url <- 
  "https://raw.githubusercontent.com/OliverVoogd/FLAMESData/master/data"
annot <- bfc[[names(BiocFileCache::bfcadd(bfc, "Annotation", 
                                          paste(file_url, 
                                                "gencodeshortened.gtf", 
                                                sep="/")))]]
genome_fa <- bfc[[names(BiocFileCache::bfcadd(bfc, 
                                              "Genomefa", 
                                              paste(file_url, 
                                                    "GRCh38shortened.fa", 
                                                    sep="/")))]]

fastq <- bfc[[names(BiocFileCache::bfcadd(bfc, "Fastq", paste(file_url, "sc_align2genome.sample.fastq.gz", sep="/")))]]

# setup other environment variables
config_file <- FLAMES::get_default_config_file()
outdir <- tempfile() 
if (!dir.exists(outdir)) {
    dir.create(outdir)
}

## ---- eval=FALSE--------------------------------------------------------------
#  library(FLAMES)
#  sce <- sc_long_pipeline(annot=annot, fastq=fastq, genome_fa=genome_fa, outdir=outdir, config_file=config_file, match_barcode=FALSE)

## ----eval=TRUE, echo=TRUE-----------------------------------------------------
temp_path <- tempfile()
bfc <- BiocFileCache::BiocFileCache(temp_path, ask=FALSE)
file_url <- 
  "https://raw.githubusercontent.com/OliverVoogd/FLAMESData/master/data"
annot <- bfc[[names(BiocFileCache::bfcadd(bfc, "Annotation", 
                                          paste(file_url, 
                                                "SIRV_isoforms_multi-fasta-annotation_C_170612a.gtf", 
                                                sep="/")))]]
genome_fa <- bfc[[names(BiocFileCache::bfcadd(bfc, 
                                              "Genomefa", 
                                              paste(file_url, 
                                                    "SIRV_isoforms_multi-fasta_170612a.fasta", 
                                                    sep="/")))]]

# download the two fastq files, move them to a folder to be merged together
fastq1 <- bfc[[names(BiocFileCache::bfcadd(bfc, "Fastq1", paste(file_url, "fastq/sample1.fastq.gz", sep="/")))]]
fastq2 <- bfc[[names(BiocFileCache::bfcadd(bfc, "Fastq2", paste(file_url, "fastq/sample2.fastq.gz", sep="/")))]]
fastq_dir <- paste(temp_path, "fastq_dir", sep="/") # the downloaded fastq files need to be in a directory to be merged together
dir.create(fastq_dir)
file.copy(c(fastq1, fastq2), fastq_dir)
unlink(c(fastq1, fastq2)) # the original files can be deleted

# setup other environment variables
config_file <- FLAMES::get_default_config_file()
outdir <- tempfile()
if (!dir.exists(outdir)) {
    dir.create(outdir)
}

## ----eval=FALSE---------------------------------------------------------------
#  library(FLAMES)
#  summarizedExperiment <- bulk_long_pipeline(annot=annot, fastq=fastq_dir, outdir=temp_path,
#                                             genome_fa=genome_fa, minimap2_dir=mm2_dir,
#                                             config_file = config_file)

## ----echo=FALSE---------------------------------------------------------------
utils::sessionInfo()

