## ---- echo = FALSE--------------------------------------------------------------------------------
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    warning = FALSE,
    fig.align = "center",
    dev = "jpeg"
)
options(width = 100)

## ---- echo = FALSE, message = FALSE---------------------------------------------------------------
library(simplifyEnrichment)
mat = readRDS(system.file("extdata", "random_GO_BP_sim_mat.rds", package = "simplifyEnrichment"))
go_id = rownames(mat)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  library(simplifyEnrichment)
#  set.seed(888)
#  go_id = random_GO(500)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  mat = GO_similarity(go_id)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  GO_similarity(go_id, measure = "Wang")

## ---- fig.width = 7*1.2, fig.height = 4*1.2-------------------------------------------------------
df = simplifyGO(mat)

## -------------------------------------------------------------------------------------------------
head(df)

## -------------------------------------------------------------------------------------------------
sort(table(df$cluster))

## ---- eval = FALSE--------------------------------------------------------------------------------
#  split(df, df$cluster)

## -------------------------------------------------------------------------------------------------
binary_cut(mat)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  cluster_terms(mat, method = "binary_cut")

## ---- fig.width = 10, fig.height = 7--------------------------------------------------------------
compare_clustering_methods(mat)

## ---- fig.width = 18, fig.height = 14, dev = "jpeg"-----------------------------------------------
compare_clustering_methods(mat, plot_type = "heatmap")

## ---- eval = FALSE--------------------------------------------------------------------------------
#  set.seed(123)
#  compare_clustering_methods(mat)
#  set.seed(123)
#  compare_clustering_methods(mat, plot_type = "heatmap")

## ---- eval = FALSE--------------------------------------------------------------------------------
#  clt = cmp_make_clusters(mat) # just a list of cluster labels
#  cmp_make_plot(mat, clt)
#  cmp_make_plot(mat, clt, plot_type = "heatmap")

## ---- eval = FALSE--------------------------------------------------------------------------------
#  register_clustering_methods(
#      method1 = function(mat, ...) ...,
#      method2 = function(mat, ...) ...,
#      ...
#  )

## -------------------------------------------------------------------------------------------------
sessionInfo()

