## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
library(sesame)
library(dplyr)
options(rmarkdown.html_vignette.check_title = FALSE)

## -----------------------------------------------------------------------------
sesameDataCache("Mammal40")

## -----------------------------------------------------------------------------
res_grn = sesameDataDownload("GSM4411982_Grn.idat.gz")
res_red = sesameDataDownload("GSM4411982_Red.idat.gz")
sset = readIDATpair(sprintf("%s/GSM4411982", res_red$dest_dir))

## -----------------------------------------------------------------------------
sset_normalized = sset %>%
                  noob %>%
                  dyeBiasCorrTypeINorm

## -----------------------------------------------------------------------------
betas = sset_normalized %>%
        qualityMask %>%
        detectionMask %>%
        getBetas

