/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications.idfilereaders;

import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.EnzymeFactory;
import com.compomics.util.experiment.identification.SearchParameters;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.preferences.ModificationProfile;
import com.compomics.util.waiting.WaitingHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import uk.ac.ebi.jmzidml.model.mzidml.AbstractParam;
import uk.ac.ebi.jmzidml.model.mzidml.CvParam;
import uk.ac.ebi.jmzidml.model.mzidml.DataCollection;
import uk.ac.ebi.jmzidml.model.mzidml.ModificationParams;
import uk.ac.ebi.jmzidml.model.mzidml.ParamList;
import uk.ac.ebi.jmzidml.model.mzidml.SearchDatabase;
import uk.ac.ebi.jmzidml.model.mzidml.SearchModification;
import uk.ac.ebi.jmzidml.model.mzidml.SpectrumIdentificationProtocol;
import uk.ac.ebi.jmzidml.model.mzidml.Tolerance;
import uk.ac.ebi.jmzidml.xml.io.MzIdentMLUnmarshaller;

public class MzIdentMLIdfileSearchParametersConverter
extends ExperimentObject {
    private static EnzymeFactory enzymeFactory = EnzymeFactory.getInstance();

    public static void main(String[] args) {
        try {
            File lEnzymeFile = new File("C:\\Users\\hba041\\My_Applications\\peptide-shaker\\resources\\conf\\peptideshaker_enzymes.xml");
            enzymeFactory.importEnzymes(lEnzymeFile);
            MzIdentMLIdfileSearchParametersConverter.getSearchParameters(new File("C:\\Users\\hba041\\Desktop\\yasset\\total-spectra-mascot.mzid"), new File("C:\\Users\\hba041\\Desktop\\test\\mzIdentML\\test.parameters"), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static SearchParameters getSearchParameters(File mzIdentMLFile, File searchParametersFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, ClassNotFoundException {
        Enzyme utilitiesEnzyme;
        SearchParameters searchParameters = new SearchParameters();
        searchParameters.setParametersFile(searchParametersFile);
        MzIdentMLUnmarshaller unmarshaller = new MzIdentMLUnmarshaller(mzIdentMLFile);
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            mzIdentMLFile = null;
            unmarshaller = null;
            return null;
        }
        ModificationProfile modificationProfile = new ModificationProfile();
        SpectrumIdentificationProtocol spectrumIdentificationProtocol = (SpectrumIdentificationProtocol)unmarshaller.unmarshal(SpectrumIdentificationProtocol.class);
        ModificationParams modifications = spectrumIdentificationProtocol.getModificationParams();
        for (SearchModification tempMod : modifications.getSearchModification()) {
            if (tempMod.getCvParam().isEmpty()) continue;
            CvParam cvParam = (CvParam)tempMod.getCvParam().get(0);
        }
        searchParameters.setModificationProfile(modificationProfile);
        DataCollection dataCollection = (DataCollection)unmarshaller.unmarshal(DataCollection.class);
        List databases = dataCollection.getInputs().getSearchDatabase();
        String databaseLocation = null;
        if (!databases.isEmpty()) {
            databaseLocation = ((SearchDatabase)databases.get(0)).getLocation();
            searchParameters.setFastaFile(new File(databaseLocation));
        }
        String enzyme = null;
        Integer maxMissedCleavages = null;
        List enzymes = spectrumIdentificationProtocol.getEnzymes().getEnzyme();
        if (!enzymes.isEmpty()) {
            ParamList paramList = ((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getEnzymeName();
            if (!paramList.getParamGroup().isEmpty()) {
                enzyme = ((AbstractParam)paramList.getParamGroup().get(0)).getName();
            }
            if (((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getMissedCleavages() != null) {
                maxMissedCleavages = ((uk.ac.ebi.jmzidml.model.mzidml.Enzyme)enzymes.get(0)).getMissedCleavages();
            }
        }
        if (enzyme != null && (utilitiesEnzyme = EnzymeFactory.getUtilitiesEnzyme(enzyme)) != null) {
            searchParameters.setEnzyme(utilitiesEnzyme);
        }
        if (maxMissedCleavages != null) {
            searchParameters.setnMissedCleavages(maxMissedCleavages);
        }
        Double precursorMinTolerance = null;
        Double precursorMaxTolerance = null;
        Boolean precursorToleranceTypeIsPpm = true;
        Tolerance tempPrecursorTolerance = spectrumIdentificationProtocol.getParentTolerance();
        for (CvParam cvParam : tempPrecursorTolerance.getCvParam()) {
            if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                precursorMaxTolerance = Double.valueOf(cvParam.getValue());
                precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                continue;
            }
            if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
            precursorMinTolerance = Double.valueOf(cvParam.getValue());
            precursorToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
        }
        if (precursorMinTolerance != null && precursorMaxTolerance != null) {
            Double precursorTolerance = Math.abs(precursorMinTolerance) - Math.abs(precursorMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(precursorMinTolerance)) : Double.valueOf(Math.max(Math.abs(precursorMinTolerance), Math.abs(precursorMaxTolerance)));
            searchParameters.setPrecursorAccuracy(precursorTolerance);
            if (precursorToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                searchParameters.setPrecursorAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        Double fragmentMinTolerance = null;
        Double fragmentMaxTolerance = null;
        Boolean fragmentToleranceTypeIsPpm = false;
        Tolerance tempFragmentTolerance = spectrumIdentificationProtocol.getFragmentTolerance();
        for (CvParam cvParam : tempFragmentTolerance.getCvParam()) {
            if (cvParam.getAccession().equalsIgnoreCase("MS:1001412")) {
                fragmentMaxTolerance = Double.valueOf(cvParam.getValue());
                fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
                continue;
            }
            if (!cvParam.getAccession().equalsIgnoreCase("MS:1001413")) continue;
            fragmentMinTolerance = Double.valueOf(cvParam.getValue());
            fragmentToleranceTypeIsPpm = cvParam.getUnitAccession().equalsIgnoreCase("UO:0000169");
        }
        if (fragmentMinTolerance != null && fragmentMaxTolerance != null) {
            Double fragmentTolerance = Math.abs(precursorMinTolerance) - Math.abs(fragmentMaxTolerance) < 1.0E-7 ? Double.valueOf(Math.abs(precursorMinTolerance)) : Double.valueOf(Math.max(Math.abs(precursorMinTolerance), Math.abs(fragmentMaxTolerance)));
            searchParameters.setPrecursorAccuracy(fragmentTolerance);
            if (fragmentToleranceTypeIsPpm.booleanValue()) {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.PPM);
            } else {
                searchParameters.setFragmentAccuracyType(SearchParameters.MassAccuracyType.DA);
            }
        }
        mzIdentMLFile = null;
        unmarshaller = null;
        if (waitingHandler != null && waitingHandler.isRunCanceled()) {
            return null;
        }
        if (searchParametersFile != null) {
            SearchParameters.saveIdentificationParameters(searchParameters, searchParametersFile);
        }
        return searchParameters;
    }
}

