## ----style, echo=FALSE, results="asis", message=FALSE-------------------------
BiocStyle::markdown()
knitr::opts_chunk$set(tidy = FALSE,
                      warning = FALSE,
                      message = FALSE)

## -----------------------------------------------------------------------------
library(sangeranalyseR)

## -----------------------------------------------------------------------------
inputFilesPath <- system.file("extdata/", package = "sangeranalyseR")

A_chloroticaFdReadFN <- file.path(inputFilesPath, 
                          "Allolobophora_chlorotica",
                          "RBNII",
                          "Achl_RBNII396-13_1_F.ab1")

## -----------------------------------------------------------------------------
singleRead <- SangerRead(readFeature   = "Forward Read",
                         readFileName  = A_chloroticaFdReadFN)

## -----------------------------------------------------------------------------
qualityBasePlot(singleRead)

## ----results="hide"-----------------------------------------------------------
updateQualityParam(singleRead,
                   TrimmingMethod         = "M1",
                   M1TrimmingCutoff       = 0.0003,
                   M2CutoffQualityScore   = NULL,
                   M2SlidingWindowSize    = NULL)

## -----------------------------------------------------------------------------
writeFastaSR(singleRead)

## ----eval=FALSE---------------------------------------------------------------
#  generateReportSR(singleRead)

## -----------------------------------------------------------------------------
rawDataDir <- system.file("extdata", package = "sangeranalyseR")
inputFilesParentDir <- file.path(rawDataDir, "Allolobophora_chlorotica", "ACHLO")
contigName <- "Achl_ACHLO006-09"
suffixForwardRegExp <- "_[0-9]*_[F].ab1"
suffixReverseRegExp <- "_[0-9]*_[R].ab1"

## -----------------------------------------------------------------------------
sangerContig <- SangerContig(parentDirectory      = inputFilesParentDir,
                             contigName           = contigName,
                             suffixForwardRegExp  = suffixForwardRegExp,
                             suffixReverseRegExp  = suffixReverseRegExp)

## ----eval=FALSE---------------------------------------------------------------
#  launchAppSC(sangerContig)

## -----------------------------------------------------------------------------
writeFastaSC(sangerContig)

## ----eval=FALSE---------------------------------------------------------------
#  generateReportSC(sangerContig)

## -----------------------------------------------------------------------------
rawDir <- system.file("extdata", package="sangeranalyseR")
parentDir <- file.path(rawDir, "Allolobophora_chlorotica", "RBNII")
suffixForwardRegExp <- "_[F]_[0-9]*.ab1"
suffixReverseRegExp <- "_[R]_[0-9]*.ab1"

## ----eval=FALSE---------------------------------------------------------------
#  sangerAlignment <-
#          SangerAlignment(parentDirectory = parentDir,
#                          suffixForwardRegExp = suffixForwardRegExp,
#                          suffixReverseRegExp = suffixReverseRegExp,)

## ----eval=FALSE---------------------------------------------------------------
#  launchAppSA(sangerAlignment)

## ----eval=FALSE---------------------------------------------------------------
#  writeFastaSA(sangerAlignment)

## ----eval=FALSE---------------------------------------------------------------
#  generateReportSA(sangerAlignment)

