/*
 * Decompiled with CFR 0.152.
 */
package jal.String;

import jal.String.BinaryPredicate;
import jal.String.Modification;
import jal.String.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    private static final boolean less(String string, String string2) {
        return string.compareTo(string2) < 0;
    }

    public static void sort(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(stringArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(stringArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            String string = stringArray[n3];
            int n4 = n3;
            String string2 = stringArray[n4 - 1];
            while (binaryPredicate.apply(string, string2)) {
                stringArray[n4] = string2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                string2 = stringArray[--n4 - 1];
            }
            stringArray[n4] = string;
        }
    }

    private static int quickPartition(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        String string = stringArray[n];
        String string2 = stringArray[n2 - 1];
        String string3 = stringArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(string3, string)) {
            if (binaryPredicate.apply(string, string2)) {
                string3 = string;
            } else if (binaryPredicate.apply(string3, string2)) {
                string3 = string2;
            }
        } else if (binaryPredicate.apply(string2, string)) {
            string3 = string;
        } else if (binaryPredicate.apply(string2, string3)) {
            string3 = string2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(stringArray[++n], string3)) {
                continue;
            }
            while (binaryPredicate.apply(string3, stringArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            String string4 = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string4;
        }
    }

    private static void qsortLoop(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(stringArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(stringArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(stringArray, n, n3, binaryPredicate);
            Sorting.stable_sort(stringArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(stringArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(String[] stringArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(stringArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(stringArray[n4], stringArray[n])) {
                String string = stringArray[n4];
                stringArray[n4] = stringArray[n];
                stringArray[n] = string;
                Sorting.adjust_heap(stringArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(stringArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(stringArray, stringArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(stringArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                stringArray2[n3] = stringArray[n];
                Sorting.adjust_heap(stringArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(stringArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(String[] stringArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(stringArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(stringArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(String[] stringArray, int n, int n2, String string, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(stringArray[n5], string)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(String[] stringArray, int n, int n2, String string, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(string, stringArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(String[] stringArray, int n, int n2, String string, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(stringArray[n5], string)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(string, stringArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(stringArray, n, n5, string, binaryPredicate);
            int n7 = Sorting.upper_bound(stringArray, n5 + 1, n + n3, string, binaryPredicate);
            return new Range(stringArray, n6, n7);
        }
        return new Range(stringArray, n, n);
    }

    public static boolean binary_search(String[] stringArray, int n, int n2, String string, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(stringArray, n, n2, string, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(string, stringArray[n3]);
    }

    public static int merge(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            stringArray3[n5++] = binaryPredicate.apply(stringArray2[n3], stringArray[n]) ? stringArray2[n3++] : stringArray[n++];
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(String[] stringArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(stringArray[n2], stringArray[n])) {
                String string = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(stringArray, n2, n3, stringArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(stringArray, n, n2, stringArray[n4], binaryPredicate);
        }
        Modification.rotate(stringArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(stringArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(stringArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) {
                stringArray3[n5++] = stringArray2[n3++];
                continue;
            }
            stringArray3[n5++] = stringArray[n++];
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) {
                ++n3;
                continue;
            }
            stringArray3[n5++] = stringArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (binaryPredicate.apply(stringArray2[n3], stringArray[n])) {
                stringArray3[n5++] = stringArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        String string = stringArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(stringArray[n3], string)) {
            stringArray[n2] = stringArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        stringArray[n2] = string;
    }

    private static void adjust_heap(String[] stringArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        String string = stringArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(stringArray[n + n6], stringArray[n + (n6 - 1)])) {
                --n6;
            }
            stringArray[n + n5] = stringArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            stringArray[n + n5] = stringArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(stringArray[n + n7], string)) {
            stringArray[n + n5] = stringArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        stringArray[n + n5] = string;
    }

    public static void pop_heap(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        String string = stringArray[--n2];
        stringArray[n2] = stringArray[n];
        stringArray[n] = string;
        Sorting.adjust_heap(stringArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(stringArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            String string = stringArray[--n2];
            stringArray[n2] = stringArray[n];
            stringArray[n] = string;
            Sorting.adjust_heap(stringArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(stringArray[n3], stringArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(stringArray[n], stringArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(stringArray[n], stringArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(stringArray2[n3++], stringArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(stringArray[--n3], stringArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(stringArray[n3], stringArray[--n5])) {
            }
            String string = stringArray[n3];
            stringArray[n3] = stringArray[n5];
            stringArray[n5] = string;
            Modification.reverse(stringArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(stringArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(String[] stringArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(stringArray[n4], stringArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(stringArray[--n5], stringArray[n3])) {
            }
            String string = stringArray[n3];
            stringArray[n3] = stringArray[n5];
            stringArray[n5] = string;
            Modification.reverse(stringArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(stringArray, n, n2);
        return false;
    }

    public static void sort(String[] stringArray, int n, int n2) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(stringArray, n, n2);
        }
        Sorting.insertion_sort(stringArray, n, n2);
    }

    public static void insertion_sort(String[] stringArray, int n, int n2) {
        int n3 = n;
        while (++n3 < n2) {
            String string = stringArray[n3];
            int n4 = n3;
            String string2 = stringArray[n4 - 1];
            while (Sorting.less(string, string2)) {
                stringArray[n4] = string2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                string2 = stringArray[--n4 - 1];
            }
            stringArray[n4] = string;
        }
    }

    private static int quickPartition(String[] stringArray, int n, int n2) {
        String string = stringArray[n];
        String string2 = stringArray[n2 - 1];
        String string3 = stringArray[n + (n2 - n) / 2];
        if (Sorting.less(string3, string)) {
            if (Sorting.less(string, string2)) {
                string3 = string;
            } else if (Sorting.less(string3, string2)) {
                string3 = string2;
            }
        } else if (Sorting.less(string2, string)) {
            string3 = string;
        } else if (Sorting.less(string2, string3)) {
            string3 = string2;
        }
        --n;
        while (true) {
            if (Sorting.less(stringArray[++n], string3)) {
                continue;
            }
            while (Sorting.less(string3, stringArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            String string4 = stringArray[n];
            stringArray[n] = stringArray[n2];
            stringArray[n2] = string4;
        }
    }

    private static void qsortLoop(String[] stringArray, int n, int n2) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(stringArray, n, n2)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(String[] stringArray, int n, int n2) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(stringArray, n, n2);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(stringArray, n, n3);
            Sorting.stable_sort(stringArray, n3, n2);
            Sorting.inplace_merge(stringArray, n, n3, n2);
        }
    }

    public static void partial_sort(String[] stringArray, int n, int n2, int n3) {
        Sorting.make_heap(stringArray, n, n2);
        int n4 = n2;
        while (n4 < n3) {
            if (Sorting.less(stringArray[n4], stringArray[n])) {
                String string = stringArray[n4];
                stringArray[n4] = stringArray[n];
                stringArray[n] = string;
                Sorting.adjust_heap(stringArray, n, n, n2);
            }
            ++n4;
        }
        Sorting.sort_heap(stringArray, n, n2);
    }

    public static int partial_sort_copy(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(stringArray, stringArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(stringArray2, n3, n4);
        n += n5;
        while (n < n2) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                stringArray2[n3] = stringArray[n];
                Sorting.adjust_heap(stringArray2, n3, n3, n4);
            }
            ++n;
        }
        Sorting.sort_heap(stringArray2, n3, n4);
        return n4;
    }

    public static void nth_element(String[] stringArray, int n, int n2, int n3) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(stringArray, n, n3);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(stringArray, n, n3);
    }

    public static int lower_bound(String[] stringArray, int n, int n2, String string) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (Sorting.less(stringArray[n5], string)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(String[] stringArray, int n, int n2, String string) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (Sorting.less(string, stringArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(String[] stringArray, int n, int n2, String string) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (Sorting.less(stringArray[n5], string)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (Sorting.less(string, stringArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(stringArray, n, n5, string);
            int n7 = Sorting.upper_bound(stringArray, n5 + 1, n + n3, string);
            return new Range(stringArray, n6, n7);
        }
        return new Range(stringArray, n, n);
    }

    public static boolean binary_search(String[] stringArray, int n, int n2, String string) {
        int n3 = Sorting.lower_bound(stringArray, n, n2, string);
        return n3 < n2 && !Sorting.less(string, stringArray[n3]);
    }

    public static int merge(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            stringArray3[n5++] = Sorting.less(stringArray2[n3], stringArray[n]) ? stringArray2[n3++] : stringArray[n++];
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(String[] stringArray, int n, int n2, int n3) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (Sorting.less(stringArray[n2], stringArray[n])) {
                String string = stringArray[n];
                stringArray[n] = stringArray[n2];
                stringArray[n2] = string;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(stringArray, n2, n3, stringArray[n5]);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(stringArray, n, n2, stringArray[n4]);
        }
        Modification.rotate(stringArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(stringArray, n, n5, n2);
        Sorting.inplace_merge(stringArray, n2, n4, n3);
    }

    public static boolean includes(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray2[n3], stringArray[n])) {
                return false;
            }
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (Sorting.less(stringArray2[n3], stringArray[n])) {
                stringArray3[n5++] = stringArray2[n3++];
                continue;
            }
            stringArray3[n5++] = stringArray[n++];
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                ++n;
                continue;
            }
            if (Sorting.less(stringArray2[n3], stringArray[n])) {
                ++n3;
                continue;
            }
            stringArray3[n5++] = stringArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (Sorting.less(stringArray2[n3], stringArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3, int n4, int n5) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                stringArray3[n5++] = stringArray[n++];
                continue;
            }
            if (Sorting.less(stringArray2[n3], stringArray[n])) {
                stringArray3[n5++] = stringArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(stringArray, stringArray3, n, n2, n5);
        Modification.copy(stringArray2, stringArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(String[] stringArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        String string = stringArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && Sorting.less(stringArray[n3], string)) {
            stringArray[n2] = stringArray[n3];
            n2 = n3;
            n3 = n2 + (n2 - n - 1) / 2;
        }
        stringArray[n2] = string;
    }

    private static void adjust_heap(String[] stringArray, int n, int n2, int n3) {
        String string = stringArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (Sorting.less(stringArray[n + n6], stringArray[n + (n6 - 1)])) {
                --n6;
            }
            stringArray[n + n5] = stringArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            stringArray[n + n5] = stringArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && Sorting.less(stringArray[n + n7], string)) {
            stringArray[n + n5] = stringArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        stringArray[n + n5] = string;
    }

    public static void pop_heap(String[] stringArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        String string = stringArray[--n2];
        stringArray[n2] = stringArray[n];
        stringArray[n] = string;
        Sorting.adjust_heap(stringArray, n, n, n2);
    }

    public static void make_heap(String[] stringArray, int n, int n2) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(stringArray, n, n + n3, n2);
        } while (n3-- != 0);
    }

    public static void sort_heap(String[] stringArray, int n, int n2) {
        while (n2 - n > 1) {
            String string = stringArray[--n2];
            stringArray[n2] = stringArray[n];
            stringArray[n] = string;
            Sorting.adjust_heap(stringArray, n, n, n2);
        }
    }

    public static int max_element(String[] stringArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!Sorting.less(stringArray[n3], stringArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(String[] stringArray, int n, int n2) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!Sorting.less(stringArray[n], stringArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(String[] stringArray, String[] stringArray2, int n, int n2, int n3, int n4) {
        while (n < n2 && n3 < n4) {
            if (Sorting.less(stringArray[n], stringArray2[n3])) {
                return true;
            }
            if (!Sorting.less(stringArray2[n3++], stringArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(String[] stringArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!Sorting.less(stringArray[--n3], stringArray[n4])) continue;
            int n5 = n2;
            while (!Sorting.less(stringArray[n3], stringArray[--n5])) {
            }
            String string = stringArray[n3];
            stringArray[n3] = stringArray[n5];
            stringArray[n5] = string;
            Modification.reverse(stringArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(stringArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(String[] stringArray, int n, int n2) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!Sorting.less(stringArray[n4], stringArray[--n3])) continue;
            int n5 = n2;
            while (!Sorting.less(stringArray[--n5], stringArray[n3])) {
            }
            String string = stringArray[n3];
            stringArray[n3] = stringArray[n5];
            stringArray[n5] = string;
            Modification.reverse(stringArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(stringArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

