/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.map;

import cern.colt.GenericSorting;
import cern.colt.Swapper;
import cern.colt.function.IntComparator;
import cern.colt.function.IntObjectProcedure;
import cern.colt.function.IntProcedure;
import cern.colt.list.IntArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.AbstractMap;

public abstract class AbstractIntObjectMap
extends AbstractMap {
    protected AbstractIntObjectMap() {
    }

    public boolean containsKey(final int n) {
        return !this.forEachKey(new IntProcedure(){

            public boolean apply(int n2) {
                return n != n2;
            }
        });
    }

    public boolean containsValue(final Object object) {
        return !this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int n, Object object2) {
                return object != object2;
            }
        });
    }

    public AbstractIntObjectMap copy() {
        return (AbstractIntObjectMap)this.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AbstractIntObjectMap)) {
            return false;
        }
        final AbstractIntObjectMap abstractIntObjectMap = (AbstractIntObjectMap)object;
        if (abstractIntObjectMap.size() != this.size()) {
            return false;
        }
        return this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int n, Object object) {
                return abstractIntObjectMap.containsKey(n) && abstractIntObjectMap.get(n) == object;
            }
        }) && abstractIntObjectMap.forEachPair(new IntObjectProcedure(){

            public boolean apply(int n, Object object) {
                return AbstractIntObjectMap.this.containsKey(n) && AbstractIntObjectMap.this.get(n) == object;
            }
        });
    }

    public abstract boolean forEachKey(IntProcedure var1);

    public boolean forEachPair(final IntObjectProcedure intObjectProcedure) {
        return this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                return intObjectProcedure.apply(n, AbstractIntObjectMap.this.get(n));
            }
        });
    }

    public abstract Object get(int var1);

    public int keyOf(final Object object) {
        final int[] nArray = new int[1];
        boolean bl = this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int n, Object object2) {
                boolean bl;
                boolean bl2 = bl = object == object2;
                if (bl) {
                    nArray[0] = n;
                }
                return !bl;
            }
        });
        if (bl) {
            return Integer.MIN_VALUE;
        }
        return nArray[0];
    }

    public IntArrayList keys() {
        IntArrayList intArrayList = new IntArrayList(this.size());
        this.keys(intArrayList);
        return intArrayList;
    }

    public void keys(final IntArrayList intArrayList) {
        intArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                intArrayList.add(n);
                return true;
            }
        });
    }

    public void keysSortedByValue(IntArrayList intArrayList) {
        this.pairsSortedByValue(intArrayList, new ObjectArrayList(this.size()));
    }

    public void pairsMatching(final IntObjectProcedure intObjectProcedure, final IntArrayList intArrayList, final ObjectArrayList objectArrayList) {
        intArrayList.clear();
        objectArrayList.clear();
        this.forEachPair(new IntObjectProcedure(){

            public boolean apply(int n, Object object) {
                if (intObjectProcedure.apply(n, object)) {
                    intArrayList.add(n);
                    objectArrayList.add(object);
                }
                return true;
            }
        });
    }

    public void pairsSortedByKey(IntArrayList intArrayList, ObjectArrayList objectArrayList) {
        this.keys(intArrayList);
        intArrayList.sort();
        objectArrayList.setSize(intArrayList.size());
        int n = intArrayList.size();
        while (--n >= 0) {
            objectArrayList.setQuick(n, this.get(intArrayList.getQuick(n)));
        }
    }

    public void pairsSortedByValue(IntArrayList intArrayList, ObjectArrayList objectArrayList) {
        this.keys(intArrayList);
        this.values(objectArrayList);
        final int[] nArray = intArrayList.elements();
        final Object[] objectArray = objectArrayList.elements();
        Swapper swapper = new Swapper(){

            public void swap(int n, int n2) {
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2] = object;
                int n3 = nArray[n];
                nArray[n] = nArray[n2];
                nArray[n2] = n3;
            }
        };
        IntComparator intComparator = new IntComparator(){

            public int compare(int n, int n2) {
                int n3 = ((Comparable)objectArray[n]).compareTo((Comparable)objectArray[n2]);
                return n3 < 0 ? -1 : (n3 > 0 ? 1 : (nArray[n] < nArray[n2] ? -1 : (nArray[n] == nArray[n2] ? 0 : 1)));
            }
        };
        GenericSorting.quickSort(0, intArrayList.size(), intComparator, swapper);
    }

    public abstract boolean put(int var1, Object var2);

    public abstract boolean removeKey(int var1);

    public String toString() {
        IntArrayList intArrayList = this.keys();
        intArrayList.sort();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = intArrayList.get(n2);
            stringBuffer.append(String.valueOf(n3));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n3)));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringByValue() {
        IntArrayList intArrayList = new IntArrayList();
        this.keysSortedByValue(intArrayList);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = intArrayList.size() - 1;
        int n2 = 0;
        while (n2 <= n) {
            int n3 = intArrayList.get(n2);
            stringBuffer.append(String.valueOf(n3));
            stringBuffer.append("->");
            stringBuffer.append(String.valueOf(this.get(n3)));
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public ObjectArrayList values() {
        ObjectArrayList objectArrayList = new ObjectArrayList(this.size());
        this.values(objectArrayList);
        return objectArrayList;
    }

    public void values(final ObjectArrayList objectArrayList) {
        objectArrayList.clear();
        this.forEachKey(new IntProcedure(){

            public boolean apply(int n) {
                objectArrayList.add(AbstractIntObjectMap.this.get(n));
                return true;
            }
        });
    }
}

