/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.expansion;

import java.util.Collection;
import psidev.psi.mi.tab.expansion.ExpansionStrategy;
import psidev.psi.mi.tab.expansion.InteractionCategory;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.Participant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryExpansionStrategy
implements ExpansionStrategy {
    private static final String SELF_PSI_REF = "MI:0503";
    private static final String PUTATIVE_SELF_PSI_REF = "MI:0898";

    protected boolean isBinary(Interaction interaction2) {
        if (interaction2 == null) {
            throw new IllegalArgumentException("Interaction must not be null.");
        }
        return interaction2.getParticipants().size() == 2;
    }

    protected Interaction copyInteraction(Interaction source) {
        Interaction target = new Interaction();
        target.setId(source.getId());
        target.setImexId(source.getImexId());
        target.setNames(source.getNames());
        target.setXref(source.getXref());
        target.getConfidences().addAll(source.getConfidences());
        target.getExperiments().addAll(source.getExperiments());
        target.getInteractionTypes().addAll(source.getInteractionTypes());
        target.setModelled(source.isModelled());
        target.setIntraMolecular(source.isIntraMolecular());
        target.setNegative(source.isNegative());
        target.getParameters().addAll(source.getParameters());
        target.getAttributes().addAll(source.getAttributes());
        target.setAvailability(source.getAvailability());
        return target;
    }

    protected Interaction buildInteraction(Interaction interactionTemplate, Participant p1, Participant p2) {
        Interaction i = this.copyInteraction(interactionTemplate);
        i.getParticipants().add(p1);
        i.getParticipants().add(p2);
        return i;
    }

    @Override
    public InteractionCategory findInteractionCategory(Interaction interaction2) {
        if (interaction2.getParticipants().size() == 1) {
            Participant c = interaction2.getParticipants().iterator().next();
            if (interaction2.isIntraMolecular()) {
                return InteractionCategory.self_intra_molecular;
            }
            return InteractionCategory.self_inter_molecular;
        }
        if (interaction2.getParticipants().size() == 2) {
            return InteractionCategory.binary;
        }
        if (interaction2.getParticipants().size() > 2) {
            return InteractionCategory.n_ary;
        }
        return null;
    }

    protected boolean containsRole(Collection<ExperimentalRole> experimentalRoles, String[] rolesToFind) {
        if (experimentalRoles != null) {
            for (ExperimentalRole expRole : experimentalRoles) {
                if (expRole.getXref() == null || expRole.getXref().getPrimaryRef() == null) continue;
                String ac = expRole.getXref().getPrimaryRef().getRefTypeAc();
                for (String roleToFind : rolesToFind) {
                    if (!roleToFind.equals(ac)) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

