/*
 * Decompiled with CFR 0.152.
 */
package psidev.psi.mi.tab.converter.xml2tab;

import java.util.List;
import psidev.psi.mi.tab.converter.IdentifierGenerator;
import psidev.psi.mi.tab.converter.tab2xml.XmlConversionException;
import psidev.psi.mi.tab.converter.xml2tab.CvConverter;
import psidev.psi.mi.tab.converter.xml2tab.InteractorConverter;
import psidev.psi.mi.tab.converter.xml2tab.RangeUtils;
import psidev.psi.mi.tab.model.BinaryInteraction;
import psidev.psi.mi.tab.model.CrossReference;
import psidev.psi.mi.tab.model.Interactor;
import psidev.psi.mi.xml.converter.ConverterException;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.BiologicalRole;
import psidev.psi.mi.xml.model.DbReference;
import psidev.psi.mi.xml.model.ExperimentalRole;
import psidev.psi.mi.xml.model.Feature;
import psidev.psi.mi.xml.model.FeatureType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.ParticipantIdentificationMethod;
import psidev.psi.mi.xml.model.Xref;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MitabInteractorConverter
extends InteractorConverter<Interactor> {
    public static final String PSIMI = "psi-mi";
    public static final String PSIMI_MI = "MI:0488";
    public static final String IDENTITY = "identity";
    public static final String IDENTITY_REF = "MI:0356";
    private static final String FEATURE_TYPE = "MI:0116";
    private static final String UNSPECIFIED_ROLE = "MI:0499";
    private CvConverter cvConverter = new CvConverter();

    @Override
    public Participant buildParticipantA(psidev.psi.mi.xml.model.Interactor xmlInteractor, BinaryInteraction binaryInteraction, int index) throws XmlConversionException {
        Object mitabInteractor = binaryInteraction.getInteractorA();
        return this.buildParticipant(xmlInteractor, (Interactor)mitabInteractor);
    }

    @Override
    public Participant buildParticipantB(psidev.psi.mi.xml.model.Interactor xmlInteractor, BinaryInteraction binaryInteraction, int index) throws XmlConversionException {
        Object mitabInteractor = binaryInteraction.getInteractorB();
        return this.buildParticipant(xmlInteractor, (Interactor)mitabInteractor);
    }

    protected Participant buildParticipant(psidev.psi.mi.xml.model.Interactor interactor, Interactor mitabInteractor) throws XmlConversionException {
        Participant participant = null;
        if (interactor != null && mitabInteractor != null) {
            List<CrossReference> participantIdentificationMethods;
            List<Integer> stoichiometry;
            ExperimentalRole experimentalRole;
            BiologicalRole biologicalRole;
            participant = new Participant();
            participant.setId(IdentifierGenerator.getInstance().nextId());
            participant.setInteractor(interactor);
            List<CrossReference> biologicalRoles = mitabInteractor.getBiologicalRoles();
            if (biologicalRoles.isEmpty()) {
                biologicalRole = new BiologicalRole();
                Names names = new Names();
                names.setShortLabel("unspecified role");
                names.setFullName("unspecified role");
                DbReference dbRef = new DbReference();
                dbRef.setDb(PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setId(UNSPECIFIED_ROLE);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                biologicalRole.setNames(names);
                biologicalRole.setXref(new Xref(dbRef));
            } else {
                biologicalRole = this.cvConverter.fromMitab(biologicalRoles, BiologicalRole.class);
            }
            participant.setBiologicalRole(biologicalRole);
            List<CrossReference> experimentalRoles = mitabInteractor.getExperimentalRoles();
            if (experimentalRoles.isEmpty()) {
                experimentalRole = new ExperimentalRole();
                Names names = new Names();
                names.setShortLabel("unspecified role");
                names.setFullName("unspecified role");
                DbReference dbRef = new DbReference();
                dbRef.setDb(PSIMI);
                dbRef.setDbAc(PSIMI_MI);
                dbRef.setId(UNSPECIFIED_ROLE);
                dbRef.setRefType(IDENTITY);
                dbRef.setRefTypeAc(IDENTITY_REF);
                experimentalRole.setNames(names);
                experimentalRole.setXref(new Xref(dbRef));
            } else {
                experimentalRole = this.cvConverter.fromMitab(experimentalRoles, ExperimentalRole.class);
            }
            participant.getExperimentalRoles().add(experimentalRole);
            List<psidev.psi.mi.tab.model.Feature> features = mitabInteractor.getFeatures();
            if (!features.isEmpty()) {
                for (psidev.psi.mi.tab.model.Feature mitabFeature : features) {
                    Feature xmlfeature = new Feature();
                    xmlfeature.setId(IdentifierGenerator.getInstance().nextId());
                    FeatureType featureType = new FeatureType();
                    if (mitabFeature.getFeatureType() != null) {
                        Names featureTypeNames = new Names();
                        featureTypeNames.setShortLabel(mitabFeature.getFeatureType());
                        featureTypeNames.setFullName(mitabFeature.getFeatureType());
                        featureType.setNames(featureTypeNames);
                        DbReference dbRef = new DbReference();
                        dbRef.setDb(PSIMI);
                        dbRef.setDbAc(PSIMI_MI);
                        dbRef.setId(FEATURE_TYPE);
                        dbRef.setRefType(IDENTITY);
                        dbRef.setRefTypeAc(IDENTITY_REF);
                        Xref xref2 = new Xref(dbRef);
                        featureType.setXref(xref2);
                        xmlfeature.setFeatureType(featureType);
                        Attribute attribute = new Attribute("MI:0018", "caution", "Due to a limitation in the conversion form MITAB to XML, the real xref for the feature type can not be provided. However, you could use the name of the feature type.");
                        xmlfeature.getAttributes().add(attribute);
                    }
                    if (mitabFeature.getRanges() != null && !mitabFeature.getRanges().isEmpty()) {
                        try {
                            xmlfeature.getRanges().addAll(RangeUtils.fromMitab(mitabFeature.getRanges()));
                        }
                        catch (ConverterException e2) {
                            throw new XmlConversionException("The ranges could not be converted");
                        }
                    }
                    if (mitabFeature.getText() != null && !mitabFeature.getText().isEmpty()) {
                        Attribute attribute = new Attribute("MI:0612", "comment", "This feature in mitab had the next text: " + mitabFeature.getText());
                        xmlfeature.getAttributes().add(attribute);
                    }
                    participant.getFeatures().add(xmlfeature);
                }
            }
            if (!(stoichiometry = mitabInteractor.getStoichiometry()).isEmpty()) {
                for (Integer integer : stoichiometry) {
                    Attribute attribute = new Attribute("MI:0612", "comment", "Stoichiometry: " + integer.toString());
                    if (participant.getAttributes().contains(attribute)) continue;
                    participant.getAttributes().add(attribute);
                }
            }
            if (!(participantIdentificationMethods = mitabInteractor.getParticipantIdentificationMethods()).isEmpty()) {
                boolean found = false;
                Names names = new Names();
                Xref xref3 = new Xref();
                for (CrossReference participantIdentificationMethod : participantIdentificationMethods) {
                    if (!found && participantIdentificationMethod.getDatabase().equalsIgnoreCase(PSIMI)) {
                        names.setShortLabel(participantIdentificationMethod.getText());
                        names.setFullName(participantIdentificationMethod.getText());
                        DbReference dbRef = new DbReference();
                        dbRef.setDb(PSIMI);
                        dbRef.setDbAc(PSIMI_MI);
                        dbRef.setId(participantIdentificationMethod.getIdentifier());
                        dbRef.setRefType(IDENTITY);
                        dbRef.setRefTypeAc(IDENTITY_REF);
                        xref3.setPrimaryRef(dbRef);
                        found = true;
                        continue;
                    }
                    String database = participantIdentificationMethod.getDatabase();
                    DbReference dbRef = new DbReference();
                    dbRef.setId(participantIdentificationMethod.getIdentifier());
                    dbRef.setDb(participantIdentificationMethod.getDatabase());
                    if (database.equals("intact")) {
                        dbRef.setDbAc("MI:0469");
                        dbRef.setRefType(IDENTITY);
                        dbRef.setRefTypeAc(IDENTITY_REF);
                    }
                    xref3.getSecondaryRef().add(dbRef);
                    if (!participantIdentificationMethod.hasText()) continue;
                    Alias alias = new Alias(participantIdentificationMethod.getText());
                    if (names.getAliases().isEmpty()) {
                        names.getAliases().add(alias);
                        continue;
                    }
                    if (names.getAliases().contains(alias)) continue;
                    names.getAliases().add(alias);
                }
                if (found) {
                    ParticipantIdentificationMethod xmlParticipantIdMethod = new ParticipantIdentificationMethod();
                    xmlParticipantIdMethod.setNames(names);
                    xmlParticipantIdMethod.setXref(xref3);
                    participant.getParticipantIdentificationMethods().add(xmlParticipantIdMethod);
                } else {
                    log.warn("No psi-mi participant identification method given.");
                }
            }
        } else {
            log.warn("No interactor given.");
        }
        return participant;
    }
}

