/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.mem;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.mem.ArrayBunch;
import com.hp.hpl.jena.mem.HashCommon;
import com.hp.hpl.jena.mem.NodeToTriplesMapBase;
import com.hp.hpl.jena.mem.SetBunch;
import com.hp.hpl.jena.mem.TripleBunch;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Set;

public class NodeToTriplesMap
extends NodeToTriplesMapBase {
    public NodeToTriplesMap(Triple.Field indexField, Triple.Field f2, Triple.Field f3) {
        super(indexField, f2, f3);
    }

    public boolean add(Triple t) {
        Object o = this.getIndexField(t);
        OpenSetBunch s = (OpenSetBunch)this.bunchMap.get(o);
        if (s == null) {
            s = this.createSetBunch();
            this.bunchMap.put(o, s);
        }
        if (s.baseSet().add(t)) {
            ++this.size;
            return true;
        }
        return false;
    }

    private OpenSetBunch createSetBunch() {
        return new OpenSetBunch();
    }

    public boolean remove(Triple t) {
        Object o = this.getIndexField(t);
        OpenSetBunch s = (OpenSetBunch)this.bunchMap.get(o);
        if (s == null) {
            return false;
        }
        Set base = s.baseSet();
        boolean result = base.remove(t);
        if (result) {
            --this.size;
        }
        if (base.isEmpty()) {
            this.bunchMap.remove(o);
        }
        return result;
    }

    public Iterator iterator(Object o, HashCommon.NotifyEmpty container2) {
        TripleBunch b = this.bunchMap.get(o);
        return b == null ? NullIterator.instance : b.iterator();
    }

    public boolean contains(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        return s == null ? false : s.contains(t);
    }

    protected static boolean equalsObjectOK(Triple t) {
        Node o = t.getObject();
        return o.isLiteral() ? o.getLiteralDatatype() == null : true;
    }

    public boolean containsBySameValueAs(Triple t) {
        return NodeToTriplesMap.equalsObjectOK(t) ? this.contains(t) : this.slowContains(t);
    }

    protected boolean slowContains(Triple t) {
        TripleBunch s = this.bunchMap.get(this.getIndexField(t));
        if (s == null) {
            return false;
        }
        ExtendedIterator it = s.iterator();
        while (it.hasNext()) {
            if (!t.matches((Triple)it.next())) continue;
            return true;
        }
        return false;
    }

    public ExtendedIterator iterateAll(Triple pattern) {
        return this.indexField.filterOn(pattern).and(this.f2.filterOn(pattern)).and(this.f3.filterOn(pattern)).filterKeep(this.iterateAll());
    }

    public ExtendedIterator iterator(Node index, Node n2, Node n32) {
        TripleBunch s = this.bunchMap.get(index.getIndexingValue());
        return s == null ? NullIterator.instance : this.f2.filterOn(n2).and(this.f3.filterOn(n32)).filterKeep(s.iterator());
    }

    public Iterator iteratorForIndexed(Object y) {
        return this.get(y).iterator();
    }

    private TripleBunch get(Object y) {
        return this.bunchMap.get(y);
    }

    private static class OpenSetBunch
    extends SetBunch {
        private static final TripleBunch empty = new ArrayBunch();

        public OpenSetBunch() {
            super(empty);
        }

        public Set baseSet() {
            return this.elements;
        }
    }
}

