## ---- echo = FALSE------------------------------------------------------------
knitr::opts_chunk$set(comment = "", message=FALSE, warning = FALSE)

## ----eval = FALSE-------------------------------------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  
#  BiocManager::install("methylGSA")

## -----------------------------------------------------------------------------
library(methylGSA)

## -----------------------------------------------------------------------------
library(IlluminaHumanMethylation450kanno.ilmn12.hg19)

## ----eval = FALSE-------------------------------------------------------------
#  library(IlluminaHumanMethylationEPICanno.ilm10b4.hg19)

## -----------------------------------------------------------------------------
data(cpgtoy)
head(cpg.pval, 20)

## -----------------------------------------------------------------------------
res1 = methylglm(cpg.pval = cpg.pval, minsize = 200, 
                 maxsize = 500, GS.type = "KEGG")
head(res1, 15)

## ----eval=FALSE---------------------------------------------------------------
#  res2 = methylRRA(cpg.pval = cpg.pval, method = "ORA",
#                      minsize = 200, maxsize = 210)
#  head(res2, 15)

## ----eval=FALSE---------------------------------------------------------------
#  res3 = methylRRA(cpg.pval = cpg.pval, method = "GSEA",
#                      minsize = 200, maxsize = 210)
#  head(res3, 10)

## ----eval=FALSE---------------------------------------------------------------
#  res4 = methylgometh(cpg.pval = cpg.pval, sig.cut = 0.001,
#                          minsize = 200, maxsize = 210)
#  head(res4, 15)

## -----------------------------------------------------------------------------
data(GSlisttoy)
## to make the display compact, only a proportion of each gene set is shown
head(lapply(GS.list, function(x) x[1:30]), 3)   

## ----eval=FALSE---------------------------------------------------------------
#  library(BiocParallel)
#  res_p = methylglm(cpg.pval = cpg.pval, minsize = 200,
#                    maxsize = 500, GS.type = "KEGG", parallel = TRUE)

## -----------------------------------------------------------------------------
data(CpG2Genetoy)
head(CpG2Gene)   

## -----------------------------------------------------------------------------
FullAnnot = prepareAnnot(CpG2Gene) 

## -----------------------------------------------------------------------------
GS.list = GS.list[1:10]
res5 = methylRRA(cpg.pval = cpg.pval, FullAnnot = FullAnnot, method = "ORA", 
                    GS.list = GS.list, GS.idtype = "SYMBOL", 
                    minsize = 100, maxsize = 300)
head(res5, 10)

## ----eval=FALSE---------------------------------------------------------------
#  res6 = methylglm(cpg.pval = cpg.pval, array.type = "450K",
#                      GS.type = "Reactome", minsize = 100, maxsize = 110)
#  head(res6, 10)

## -----------------------------------------------------------------------------
barplot(res1, num = 8, colorby = "pvalue")

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

