## -----------------------------------------------------------------------------
library(geneplast)
data(gpdata.gs)

## ----label='newOgp', eval=TRUE------------------------------------------------
ogp <- gplast.preprocess(cogdata=cogdata, sspids=sspids, cogids=cogids, verbose=FALSE)

## ----label='gplastTest', eval=TRUE--------------------------------------------
ogp <- gplast(ogp, verbose=FALSE)

## ----label='gplastRes', eval=TRUE---------------------------------------------
res <- gplast.get(ogp,what="results")
head(res)

## ----label='newOgr', eval=TRUE------------------------------------------------
ogr <- groot.preprocess(cogdata=cogdata, phyloTree=phyloTree, spid="9606", cogids=cogids, verbose=FALSE)

## ----label='grootTest', eval=TRUE---------------------------------------------
set.seed(1)
ogr <- groot(ogr, nPermutations=100, verbose=FALSE)

## ----label='grootRes1', eval=TRUE---------------------------------------------
res <- groot.get(ogr,what="results")
head(res)

## ----label='grootRes2', eval=TRUE---------------------------------------------
groot.plot(ogr,whichOG="NOG40170")

## ----label='rootRes', eval=TRUE-----------------------------------------------
groot.plot(ogr,plot.lcas = TRUE)

## ---- eval=FALSE--------------------------------------------------------------
#  # source("https://bioconductor.org/biocLite.R")
#  # biocLite("geneplast.data.string.v91")
#  library(geneplast.data.string.v91)
#  data(gpdata_string_v91)

## ---- eval=FALSE--------------------------------------------------------------
#  ogr <- groot.preprocess(cogdata=cogdata, phyloTree=phyloTree, spid="9606")

## ---- eval=FALSE--------------------------------------------------------------
#  ogr <- groot(ogr, nPermutations=100, verbose=TRUE)

## ---- eval=FALSE--------------------------------------------------------------
#  library(RedeR)
#  library(igraph)
#  library(RColorBrewer)
#  data(ppi.gs)

## ---- eval=FALSE--------------------------------------------------------------
#  g <- ogr2igraph(ogr, cogdata, ppi.gs, idkey = "ENTREZ")

## ---- eval=FALSE--------------------------------------------------------------
#  pal <- brewer.pal(9, "RdYlBu")
#  color_col <- colorRampPalette(pal)(25) #set a color for each root!
#  g <- att.setv(g=g, from="Root", to="nodeColor", cols=color_col, na.col = "grey80", breaks = seq(1,25))

## ---- eval=FALSE--------------------------------------------------------------
#  g <- att.setv(g = g, from = "SYMBOL", to = "nodeAlias")
#  E(g)$edgeColor <- "grey80"
#  V(g)$nodeLineColor <- "grey80"

## ---- eval=FALSE--------------------------------------------------------------
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)
#  addGraph(rdp, g)
#  addLegend.color(rdp, colvec=g$legNodeColor$scale, size=15, labvec=g$legNodeColor$legend, title="Roots represented in Fig4")

## ---- eval=FALSE--------------------------------------------------------------
#  g1  <- induced_subgraph(g=g, V(g)$name[V(g)$Apoptosis==1])
#  g2  <- induced_subgraph(g=g, V(g)$name[V(g)$GenomeStability==1])

## ---- eval=FALSE--------------------------------------------------------------
#  myTheme <- list(nestFontSize=25, zoom=80, isNest=TRUE, gscale=65, theme=2)
#  addGraph(rdp, g1, gcoord=c(25, 50), theme = c(myTheme, nestAlias="Apoptosis"))
#  addGraph(rdp, g2, gcoord=c(75, 50), theme = c(myTheme, nestAlias="Genome Stability"))
#  relax(rdp, p1=50, p2=50, p3=50, p4=50, p5= 50, ps = TRUE)

## ---- eval=FALSE--------------------------------------------------------------
#  library(RTN)
#  library(Fletcher2013b)
#  library(RedeR)
#  library(igraph)
#  library(RColorBrewer)
#  data("rtni1st")

## ---- eval=FALSE--------------------------------------------------------------
#  regs <- c("FOXM1","PTTG1")
#  g <- tni.graph(rtni1st, gtype = "rmap", tfs = regs)

## ---- eval=FALSE--------------------------------------------------------------
#  g <- ogr2igraph(ogr, cogdata, g, idkey = "ENTREZ")

## ---- eval=FALSE--------------------------------------------------------------
#  pal <- brewer.pal(9, "RdYlBu")
#  color_col <- colorRampPalette(pal)(25) #set a color for each root!
#  g <- att.setv(g=g, from="Root", to="nodeColor", cols=color_col, na.col = "grey80", breaks = seq(1,25))

## ---- eval=FALSE--------------------------------------------------------------
#  idx <- V(g)$SYMBOL %in% regs
#  V(g)$nodeFontSize[idx] <- 30
#  V(g)$nodeFontSize[!idx] <- 1
#  E(g)$edgeColor <- "grey80"
#  V(g)$nodeLineColor <- "grey80"

## ---- eval=FALSE--------------------------------------------------------------
#  rdp <- RedPort()
#  calld(rdp)
#  resetd(rdp)
#  addGraph( rdp, g, layout=NULL)
#  addLegend.color(rdp, colvec=g$legNodeColor$scale, size=15, labvec=g$legNodeColor$legend, title="Roots represented in Fig4")
#  relax(rdp, 15, 100, 20, 50, 10, 100, 10, 2, ps=TRUE)

## ----label='Session information', eval=TRUE, echo=FALSE-----------------------
sessionInfo()

