/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.MDFunction;
import edu.rit.numeric.TooManyIterationsException;
import java.util.Arrays;

public class MDMinimizationDownhillSimplex {
    public final MDFunction fcn;
    public final int N;
    public final double[][] x;
    public final double[] f;
    public double tol = 1.0E-6;
    public boolean debug;
    private int i_max;
    private int i_2ndmax;
    private int i_min;
    private int evalCount;
    private double[] x_sum;
    private double[] x_trial;
    private double f_trial;
    private static final int MAXEVAL = 5000;

    public MDMinimizationDownhillSimplex(MDFunction mDFunction) {
        this.fcn = mDFunction;
        this.N = mDFunction.argumentLength();
        this.x = new double[this.N + 1][this.N];
        this.f = new double[this.N + 1];
        this.x_sum = new double[this.N];
        this.x_trial = new double[this.N];
    }

    public void setSimplex(double[] dArray, double d) {
        System.arraycopy(dArray, 0, this.x[0], 0, this.N);
        int n = 0;
        while (n < this.N) {
            double[] dArray2 = this.x[n + 1];
            int n2 = n++;
            dArray2[n2] = dArray2[n2] + d;
        }
    }

    public void setSimplex(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, this.x[0], 0, this.N);
        for (int i = 0; i < this.N; ++i) {
            double[] dArray3 = this.x[i + 1];
            int n = i;
            dArray3[n] = dArray3[n] + dArray2[i];
        }
    }

    public void minimize() {
        int n;
        if (this.tol <= 0.0) {
            throw new IllegalArgumentException("MDMinimizationDownhillSimplex.minimize(): tol = " + this.tol + " illegal");
        }
        for (n = 0; n <= this.N; ++n) {
            this.f[n] = this.fcn.f(this.x[n]);
        }
        this.evalCount = this.N + 1;
        this.compute_x_sum();
        n = 1;
        while (true) {
            if (this.debug) {
                this.subclassDebug(n, this.evalCount);
            }
            if (this.f[0] > this.f[1]) {
                this.i_max = 0;
                this.i_min = 1;
                this.i_2ndmax = 1;
            } else {
                this.i_max = 1;
                this.i_min = 0;
                this.i_2ndmax = 0;
            }
            for (int i = 2; i <= this.N; ++i) {
                if (this.f[i] > this.f[this.i_max]) {
                    this.i_2ndmax = this.i_max;
                    this.i_max = i;
                } else if (this.f[i] > this.f[this.i_2ndmax]) {
                    this.i_2ndmax = i;
                }
                if (!(this.f[i] < this.f[this.i_min])) continue;
                this.i_min = i;
            }
            if (this.reldif(this.f[this.i_max], this.f[this.i_min]) < this.tol) {
                this.swap_x(0, this.i_min);
                this.swap_f(0, this.i_min);
                return;
            }
            if (this.evalCount >= 5000) {
                throw new TooManyIterationsException("MDMinimizationDownhillSimplex.minimize(): Too many function evaluations (5000) with no solution");
            }
            this.compute_x_trial(-1.0);
            if (this.f_trial <= this.f[this.i_min]) {
                this.compute_x_trial(2.0);
            } else if (this.f_trial >= this.f[this.i_2ndmax]) {
                double d = this.f_trial;
                this.compute_x_trial(0.5);
                if (this.f_trial >= d) {
                    double[] dArray = this.x[this.i_min];
                    for (int i = 0; i <= this.N; ++i) {
                        if (i == this.i_min) continue;
                        double[] dArray2 = this.x[i];
                        for (int j = 0; j < this.N; ++j) {
                            dArray2[j] = 0.5 * (dArray2[j] + dArray[j]);
                        }
                        this.f[i] = this.fcn.f(dArray2);
                    }
                    this.evalCount += this.N;
                    this.compute_x_sum();
                }
            }
            ++n;
        }
    }

    protected void subclassDebug(int n, int n2) {
    }

    private void compute_x_sum() {
        Arrays.fill(this.x_sum, 0.0);
        for (int i = 0; i <= this.N; ++i) {
            double[] dArray = this.x[i];
            for (int j = 0; j < this.N; ++j) {
                int n = j;
                this.x_sum[n] = this.x_sum[n] + dArray[j];
            }
        }
    }

    private double reldif(double d, double d2) {
        return 2.0 * Math.abs(d - d2) / (Math.abs(d) + Math.abs(d2) + 1.0E-10);
    }

    private void swap_x(int n, int n2) {
        double[] dArray = this.x[n];
        this.x[n] = this.x[n2];
        this.x[n2] = dArray;
    }

    private void swap_f(int n, int n2) {
        double d = this.f[n];
        this.f[n] = this.f[n2];
        this.f[n2] = d;
    }

    private void compute_x_trial(double d) {
        int n;
        double d2 = (1.0 - d) / (double)this.N;
        double d3 = d2 - d;
        double[] dArray = this.x[this.i_max];
        for (n = 0; n < this.N; ++n) {
            this.x_trial[n] = d2 * this.x_sum[n] - d3 * dArray[n];
        }
        this.f_trial = this.fcn.f(this.x_trial);
        ++this.evalCount;
        if (this.f_trial < this.f[this.i_max]) {
            for (n = 0; n < this.N; ++n) {
                this.x_sum[n] = this.x_sum[n] - dArray[n] + this.x_trial[n];
                dArray[n] = this.x_trial[n];
            }
            this.f[this.i_max] = this.f_trial;
        }
    }
}

