## ---- echo = FALSE, message = FALSE---------------------------------------------------------------
library(markdown)
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    fig.align = "center")
options(width = 100)
options(rmarkdown.html_vignette.check_title = FALSE)
library(cola)

## -------------------------------------------------------------------------------------------------
data(golub_cola)
res = golub_cola["ATC:skmeans"]
res

## -------------------------------------------------------------------------------------------------
mat = get_matrix(res)

## -------------------------------------------------------------------------------------------------
mat2 = t(scale(t(mat)))

## ---- fig.width = 8, fig.height = 6, out.width = "600"--------------------------------------------
cl = predict_classes(res, k = 3, mat2)
cl

## -------------------------------------------------------------------------------------------------
data.frame(cola_class = get_classes(res, k = 3)[, "class"],
           predicted = cl[, "class"])

## ---- fig.width = 8, fig.height = 6, out.width = "600"--------------------------------------------
cl = predict_classes(res, k = 3, mat2, dist_method = "correlation")
cl

## -------------------------------------------------------------------------------------------------
tb = get_signatures(res, k = 3, plot = FALSE)
# the centroids are already in `tb`, both scaled and unscaled, we just simply extract it
sig_mat = tb[, grepl("scaled_mean", colnames(tb))]
sig_mat = as.matrix(sig_mat)
colnames(sig_mat) = paste0("class", seq_len(ncol(sig_mat)))
head(sig_mat)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  cl = predict_classes(sig_mat, mat2)
#  cl = predict_classes(sig_mat, mat2, dist_method = "correlation")

## -------------------------------------------------------------------------------------------------
sessionInfo()

