## ---- echo = FALSE, message = FALSE---------------------------------------------------------------
library(markdown)
options(markdown.HTML.options = c("use_xhtml", "smartypants", "base64_images", "mathjax", "highlight_code"))
options(markdown.HTML.stylesheet = system.file("resources", "markdown.css", package = "markdown"))
library(knitr)
knitr::opts_chunk$set(
    error = FALSE,
    tidy  = FALSE,
    message = FALSE,
    warning = FALSE,
    fig.align = "center")
options(width = 100)
options(rmarkdown.html_vignette.check_title = FALSE)
library(cola)

## ---- results = "hide"----------------------------------------------------------------------------
download.file("https://jokergoo.github.io/cola_examples/TCGA_GBM/TCGA_GBM_subgroup.rds", 
    destfile = "TCGA_GBM_subgroup.rds", quiet = TRUE)
rl = readRDS("TCGA_GBM_subgroup.rds")
file.remove("TCGA_GBM_subgroup.rds")

## -------------------------------------------------------------------------------------------------
library(cola)
res = rl["ATC:skmeans"]
res

## ---- fig.width = 8, fig.height = 7, out.width = "500"--------------------------------------------
set.seed(123)
get_signatures(res, k = 4)

## -------------------------------------------------------------------------------------------------
head(rownames(res))

## ---- eval = FALSE--------------------------------------------------------------------------------
#  lt = functional_enrichment(res, k = 4)

## ---- echo = FALSE--------------------------------------------------------------------------------
if(file.exists("lt_functional_enrichment_TCGA_GBM.rds")) {
	lt = readRDS("lt_functional_enrichment_TCGA_GBM.rds")
} else {
	lt = functional_enrichment(res, k = 4)
	saveRDS(lt, "lt_functional_enrichment_TCGA_GBM.rds", compress = "xz")
}

## -------------------------------------------------------------------------------------------------
names(lt)
head(lt[[1]])

## -------------------------------------------------------------------------------------------------
data(golub_cola) 

## ---- fig.width = 8, fig.height = 7, out.width = "500"--------------------------------------------
res = golub_cola["ATC:skmeans"]
head(rownames(res))
set.seed(123)
get_signatures(res, k = 3)

## -------------------------------------------------------------------------------------------------
library(hu6800.db)
x = hu6800ENTREZID
mapped_probes = mappedkeys(x)
id_mapping = unlist(as.list(x[mapped_probes]))
head(id_mapping)

## -------------------------------------------------------------------------------------------------
sum(!is.na(id_mapping[rownames(res)]))/nrow(res)

## ---- eval = FALSE--------------------------------------------------------------------------------
#  lt = functional_enrichment(res, k = 3, id_mapping = id_mapping)

## -------------------------------------------------------------------------------------------------
sessionInfo()

